/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public RenameCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String extCollectionName = message.getStr("name");
        String target = message.getStr("target");
        if (this.ocmh.zkStateReader.aliasesManager != null) {
            this.ocmh.zkStateReader.aliasesManager.update();
        }
        if (extCollectionName == null || target == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "both collection 'name' and 'target' name must be specified");
        }
        Aliases aliases = this.ocmh.zkStateReader.getAliases();
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? aliases.resolveSimpleAlias(extCollectionName) : extCollectionName;
        if (!state.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "source collection '" + collectionName + "' not found.");
        }
        if (this.ocmh.zkStateReader.getAliases().hasAlias(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "target alias '" + target + "' exists: " + this.ocmh.zkStateReader.getAliases().getCollectionAliasListMap().get(target));
        }
        this.ocmh.zkStateReader.aliasesManager.applyModificationAndExportToZk(a -> a.cloneWithRename(extCollectionName, target));
    }
}

