/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;

public abstract class TupleStream
implements Closeable,
Serializable,
MapWriter {
    private static final long serialVersionUID = 1L;
    private UUID streamNodeId = UUID.randomUUID();

    public abstract void setStreamContext(StreamContext var1);

    public abstract List<TupleStream> children();

    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract Tuple read() throws IOException;

    public abstract StreamComparator getStreamSort();

    public abstract Explanation toExplanation(StreamFactory var1) throws IOException;

    public int getCost() {
        return 0;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.open();
        ew.put("docs", iw -> {
            try {
                Tuple tuple;
                while ((tuple = this.read()) != null) {
                    iw.add(tuple);
                    if (!tuple.EOF) continue;
                    this.close();
                    break;
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        });
    }

    public UUID getStreamNodeId() {
        return this.streamNodeId;
    }

    public static List<String> getShards(String zkHost, String collection, StreamContext streamContext) throws IOException {
        Map shardsMap = null;
        ArrayList<String> shards = new ArrayList();
        if (streamContext != null) {
            shardsMap = (Map)streamContext.get("shards");
        }
        if (shardsMap != null) {
            shards = (List)shardsMap.get(collection);
        } else {
            CloudSolrClient cloudSolrClient = streamContext.getSolrClientCache().getCloudSolrClient(zkHost);
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = TupleStream.getSlices(collection, zkStateReader, true);
            Set<String> liveNodes = clusterState.getLiveNodes();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    shuffler.add(replica);
                }
                Collections.shuffle(shuffler, new Random());
                Replica rep = (Replica)shuffler.get(0);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                shards.add(url);
            }
        }
        return shards;
    }

    public static Collection<Slice> getSlices(String collectionName, ZkStateReader zkStateReader, boolean checkAlias) throws IOException {
        Aliases aliases;
        String alias;
        ClusterState clusterState = zkStateReader.getClusterState();
        Map<String, DocCollection> collectionsMap = clusterState.getCollectionsMap();
        if (collectionsMap.containsKey(collectionName)) {
            return collectionsMap.get(collectionName).getActiveSlices();
        }
        for (String collectionMapKey : collectionsMap.keySet()) {
            if (!collectionMapKey.equalsIgnoreCase(collectionName)) continue;
            return collectionsMap.get(collectionMapKey).getActiveSlices();
        }
        if (checkAlias && (alias = (aliases = zkStateReader.getAliases()).getCollectionAlias(collectionName)) != null) {
            ArrayList<Slice> slices = new ArrayList<Slice>();
            List<String> aliasList = StrUtils.splitSmart(alias, ",", true);
            for (String aliasCollectionName : aliasList) {
                slices.addAll(collectionsMap.get(aliasCollectionName).getActiveSlices());
            }
            return slices;
        }
        throw new IOException("Slices not found for " + collectionName);
    }
}

