/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.ClusterDataProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.rule.ImplicitSnitch;
import org.apache.solr.common.cloud.rule.RemoteCallback;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientDataProvider
implements ClusterDataProvider,
MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static SolrClientDataProvider INST;
    public AutoScalingConfig config;
    private final CloudSolrClient solrClient;
    private final Map<String, Map<String, Map<String, List<ReplicaInfo>>>> data = new HashMap<String, Map<String, Map<String, List<ReplicaInfo>>>>();
    private Set<String> liveNodes;
    private Map<String, Object> snitchSession = new HashMap<String, Object>();
    private Map<String, Map> nodeVsTags = new HashMap<String, Map>();

    public SolrClientDataProvider(CloudSolrClient solrClient) {
        this.solrClient = solrClient;
        ZkStateReader zkStateReader = solrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        this.liveNodes = clusterState.getLiveNodes();
        Map<String, ClusterState.CollectionRef> all = clusterState.getCollectionStates();
        all.forEach((collName, ref) -> {
            DocCollection coll = ref.get();
            if (coll == null) {
                return;
            }
            coll.forEachReplica((shard, replica) -> {
                Map nodeData = this.data.computeIfAbsent(replica.getNodeName(), k -> new HashMap());
                Map collData = nodeData.computeIfAbsent(collName, k -> new HashMap());
                List replicas = collData.computeIfAbsent(shard, k -> new ArrayList());
                replicas.add(new ReplicaInfo(replica.getName(), (String)collName, (String)shard, replica.getType(), (Map<String, Object>)new HashMap<String, Object>()));
            });
        });
        if (log.isDebugEnabled()) {
            INST = this;
        }
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        ClusterState.CollectionRef state = this.solrClient.getClusterStateProvider().getState(coll);
        return state == null || state.get() == null ? null : (String)state.get().getProperties().get("policy");
    }

    @Override
    public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
        AutoScalingSnitch snitch = new AutoScalingSnitch();
        ClientSnitchCtx ctx = new ClientSnitchCtx(null, node, this.snitchSession, this.solrClient);
        snitch.getTags(node, new HashSet<String>(tags), ctx);
        this.nodeVsTags.put(node, ctx.getTags());
        return ctx.getTags();
    }

    @Override
    public Map<String, Map<String, List<ReplicaInfo>>> getReplicaInfo(String node, Collection<String> keys) {
        return this.data.computeIfAbsent(node, s -> Collections.emptyMap());
    }

    @Override
    public Collection<String> getNodes() {
        return this.liveNodes;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put("liveNodes", this.liveNodes);
        ew.put("replicaInfo", Utils.getDeepCopy(this.data, 5));
        ew.put("nodeValues", this.nodeVsTags);
    }

    static class AutoScalingSnitch
    extends ImplicitSnitch {
        AutoScalingSnitch() {
        }

        @Override
        protected void getRemoteInfo(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
            ClientSnitchCtx snitchContext = (ClientSnitchCtx)ctx;
            HashMap<String, String> metricsKeyVsTag = new HashMap<String, String>();
            for (String tag2 : requestedTags) {
                if (tag2.startsWith("sysprop.")) {
                    metricsKeyVsTag.put("solr.jvm:system.properties:" + tag2.substring("sysprop.".length()), tag2);
                    continue;
                }
                if (!tag2.startsWith("metrics:")) continue;
                metricsKeyVsTag.put(tag2.substring("metrics:".length()), tag2);
            }
            if (!metricsKeyVsTag.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.add("key", metricsKeyVsTag.keySet().toArray(new String[metricsKeyVsTag.size()]));
                try {
                    SimpleSolrResponse rsp = snitchContext.invoke(solrNode, "/admin/metrics", params);
                    metricsKeyVsTag.forEach((key, tag) -> {
                        Object v = Utils.getObjectByPath(rsp.nl, true, Arrays.asList("metrics", key));
                        if (v != null) {
                            snitchContext.getTags().put((String)tag, v);
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("could not get tags from node " + solrNode, (Throwable)e);
                }
            }
            HashSet<String> groups = new HashSet<String>();
            ArrayList<String> prefixes = new ArrayList<String>();
            if (requestedTags.contains("freedisk")) {
                groups.add("solr.node");
                prefixes.add("CONTAINER.fs.usableSpace");
            }
            if (requestedTags.contains("cores")) {
                groups.add("solr.core");
                prefixes.add("CORE.coreName");
            }
            if (requestedTags.contains("sysLoadAvg")) {
                groups.add("solr.jvm");
                prefixes.add("os.systemLoadAverage");
            }
            if (requestedTags.contains("heapUsage")) {
                groups.add("solr.jvm");
                prefixes.add("memory.heap.usage");
            }
            if (groups.isEmpty() || prefixes.isEmpty()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("group", StrUtils.join(groups, ','));
            params.add("prefix", StrUtils.join(prefixes, ','));
            try {
                Number n;
                SimpleSolrResponse rsp = snitchContext.invoke(solrNode, "/admin/metrics", params);
                Map m = rsp.nl.asMap(4);
                if (requestedTags.contains("freedisk") && (n = (Number)Utils.getObjectByPath((Object)m, true, "metrics/solr.node/CONTAINER.fs.usableSpace")) != null) {
                    ctx.getTags().put("freedisk", n.doubleValue() / 1024.0 / 1024.0 / 1024.0);
                }
                if (requestedTags.contains("cores")) {
                    int count = 0;
                    Map cores = (Map)m.get("metrics");
                    for (Object o : cores.keySet()) {
                        if (!o.toString().startsWith("solr.core.")) continue;
                        ++count;
                    }
                    ctx.getTags().put("cores", count);
                }
                if (requestedTags.contains("sysLoadAvg") && (n = (Number)Utils.getObjectByPath((Object)m, true, "metrics/solr.jvm/os.systemLoadAverage")) != null) {
                    ctx.getTags().put("sysLoadAvg", n.doubleValue() * 100.0);
                }
                if (requestedTags.contains("heapUsage") && (n = (Number)Utils.getObjectByPath((Object)m, true, "metrics/solr.jvm/memory.heap.usage")) != null) {
                    ctx.getTags().put("heapUsage", n.doubleValue() * 100.0);
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    static class ClientSnitchCtx
    extends SnitchContext {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        ZkClientClusterStateProvider zkClientClusterStateProvider;
        CloudSolrClient solrClient;

        public ClientSnitchCtx(SnitchContext.SnitchInfo perSnitch, String node, Map<String, Object> session, CloudSolrClient solrClient) {
            super(perSnitch, node, session);
            this.solrClient = solrClient;
            this.zkClientClusterStateProvider = (ZkClientClusterStateProvider)solrClient.getClusterStateProvider();
        }

        @Override
        public Map getZkJson(String path) throws KeeperException, InterruptedException {
            return Utils.getJson(this.zkClientClusterStateProvider.getZkStateReader().getZkClient(), path, true);
        }

        @Override
        public void invokeRemote(String node, ModifiableSolrParams params, String klas, RemoteCallback callback) {
        }

        public SimpleSolrResponse invoke(String solrNode, String path, SolrParams params) throws IOException, SolrServerException {
            String url = this.zkClientClusterStateProvider.getZkStateReader().getBaseUrlForNodeName(solrNode);
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params);
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder().withHttpClient(this.solrClient.getHttpClient())).withBaseSolrUrl(url).withResponseParser(new BinaryResponseParser())).build();){
                NamedList<Object> rsp = client.request(request);
                request.response.nl = rsp;
                SimpleSolrResponse simpleSolrResponse = request.response;
                return simpleSolrResponse;
            }
        }
    }
}

