/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.RegressionEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ResidualsEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ResidualsEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (3 != values.length) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - three values expected but found %d", this.toExpression(this.constructingFactory), values.length));
        }
        if (Arrays.stream(values).filter(value -> null == value).count() > 0L) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null value found", this.toExpression(this.constructingFactory)));
        }
        if (!(values[0] instanceof RegressionEvaluator.RegressionTuple)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a RegressionTuple", this.toExpression(this.constructingFactory), values[0].getClass().getSimpleName()));
        }
        if (!(values[1] instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
        }
        if (!(values[2] instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the third value, expecting a list", this.toExpression(this.constructingFactory), values[2].getClass().getSimpleName()));
        }
        if (((List)values[1]).stream().filter(value -> !(value instanceof Number)).count() > 0L) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a list of numbers for the second value", this.toExpression(this.constructingFactory)));
        }
        if (((List)values[2]).stream().filter(value -> !(value instanceof Number)).count() > 0L) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a list of numbers for the third value", this.toExpression(this.constructingFactory)));
        }
        RegressionEvaluator.RegressionTuple regressedTuple = (RegressionEvaluator.RegressionTuple)values[0];
        List l1 = (List)values[1];
        List l2 = (List)values[2];
        if (l2.size() < l1.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - first list (%d) has more values than the second list (%d)", this.toExpression(this.constructingFactory), l1.size(), l2.size()));
        }
        ArrayList<Double> residuals = new ArrayList<Double>();
        for (int idx = 0; idx < l1.size(); ++idx) {
            double value1 = ((Number)l1.get(idx)).doubleValue();
            double value2 = ((Number)l2.get(idx)).doubleValue();
            double prediction = regressedTuple.predict(value1);
            double residual = value2 - prediction;
            residuals.add(residual);
        }
        return residuals;
    }
}

