/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public class CollectionApiMapping {
    private static Collection<String> getParamNames_(CommandOperation op, CommandMeta command) {
        ArrayList<String> result = new ArrayList<String>();
        Object o = op.getCommandData();
        if (o instanceof Map) {
            Map map = (Map)o;
            CollectionApiMapping.collectKeyNames(map, result, "");
        }
        return result;
    }

    public static void collectKeyNames(Map<String, Object> map, List<String> result, String prefix) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() instanceof Map) {
                CollectionApiMapping.collectKeyNames((Map)e.getValue(), result, prefix + e.getKey() + ".");
                continue;
            }
            result.add(prefix + e.getKey());
        }
    }

    public static interface CommandMeta {
        public String getName();

        public SolrRequest.METHOD getHttpMethod();

        public V2EndPoint getEndPoint();

        default public Collection<String> getParamNames(CommandOperation op) {
            return CollectionApiMapping.getParamNames_(op, this);
        }

        default public String getParamSubstitute(String name) {
            return name;
        }
    }

    public static enum ConfigSetEndPoint implements V2EndPoint
    {
        LIST_CONFIG("cluster.configs"),
        CONFIG_COMMANDS("cluster.configs.Commands"),
        CONFIG_DEL("cluster.configs.delete");

        public final String spec;

        private ConfigSetEndPoint(String spec) {
            this.spec = spec;
        }

        @Override
        public String getSpecName() {
            return this.spec;
        }
    }

    public static enum ConfigSetMeta implements CommandMeta
    {
        LIST(ConfigSetEndPoint.LIST_CONFIG, SolrRequest.METHOD.GET, null, ConfigSetParams.ConfigSetAction.LIST),
        CREATE(ConfigSetEndPoint.CONFIG_COMMANDS, SolrRequest.METHOD.POST, "create", ConfigSetParams.ConfigSetAction.CREATE),
        DEL(ConfigSetEndPoint.CONFIG_DEL, SolrRequest.METHOD.DELETE, null, ConfigSetParams.ConfigSetAction.DELETE);

        public final ConfigSetEndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final String cmdName;
        public final ConfigSetParams.ConfigSetAction action;

        private ConfigSetMeta(ConfigSetEndPoint endPoint, SolrRequest.METHOD method, String cmdName, ConfigSetParams.ConfigSetAction action) {
            this.cmdName = cmdName;
            this.endPoint = endPoint;
            this.method = method;
            this.action = action;
        }

        @Override
        public String getName() {
            return this.cmdName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public V2EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    public static interface V2EndPoint {
        public String getSpecName();
    }

    public static enum EndPoint implements V2EndPoint
    {
        CLUSTER("cluster"),
        CLUSTER_ALIASES("cluster.aliases"),
        CLUSTER_CMD("cluster.Commands"),
        CLUSTER_NODES("cluster.nodes"),
        CLUSTER_CMD_STATUS("cluster.commandstatus"),
        CLUSTER_CMD_STATUS_DELETE("cluster.commandstatus.delete"),
        COLLECTIONS_COMMANDS("collections.Commands"),
        COLLECTIONS("collections"),
        COLLECTION_STATE("collections.collection"),
        PER_COLLECTION("collections.collection.Commands"),
        PER_COLLECTION_DELETE("collections.collection.delete"),
        PER_COLLECTION_SHARDS_COMMANDS("collections.collection.shards.Commands"),
        PER_COLLECTION_PER_SHARD_COMMANDS("collections.collection.shards.shard.Commands"),
        PER_COLLECTION_PER_SHARD_DELETE("collections.collection.shards.shard.delete"),
        PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE("collections.collection.shards.shard.replica.delete");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    public static enum Meta implements CommandMeta
    {
        GET_COLLECTIONS(EndPoint.COLLECTIONS, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LIST),
        GET_CLUSTER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LIST, "/cluster", null),
        GET_CLUSTER_OVERSEER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.OVERSEERSTATUS, "/cluster/overseer", null),
        GET_CLUSTER_STATUS_CMD(EndPoint.CLUSTER_CMD_STATUS, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.REQUESTSTATUS),
        DELETE_CLUSTER_STATUS(EndPoint.CLUSTER_CMD_STATUS_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETESTATUS),
        GET_A_COLLECTION(EndPoint.COLLECTION_STATE, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.CLUSTERSTATUS),
        LIST_ALIASES(EndPoint.CLUSTER_ALIASES, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LISTALIASES),
        CREATE_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATE, CollectionParams.CollectionAction.CREATE.toLower(), Utils.makeMap("collection.configName", "config", "createNodeSet.shuffle", "shuffleNodes", "createNodeSet", "nodeSet"), Utils.makeMap("properties.", "property.")),
        DELETE_COLL(EndPoint.PER_COLLECTION_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETE, CollectionParams.CollectionAction.DELETE.toLower(), Utils.makeMap("name", "collection")),
        RELOAD_COLL(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.RELOAD, CollectionParams.CollectionAction.RELOAD.toLower(), Utils.makeMap("name", "collection")),
        MODIFY_COLLECTION(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.MODIFYCOLLECTION, "modify", null),
        MIGRATE_DOCS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.MIGRATE, "migrate-docs", Utils.makeMap("split.key", "splitKey", "target.collection", "target", "forward.timeout", "forwardTimeout")),
        REBALANCE_LEADERS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.REBALANCELEADERS, "rebalance-leaders", null),
        CREATE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATEALIAS, "create-alias", null),
        DELETE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.DELETEALIAS, "delete-alias", null),
        CREATE_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATESHARD, "create", Utils.makeMap("createNodeSet", "nodeSet"), Utils.makeMap("coreProperties.", "property.")){

            @Override
            public String getParamSubstitute(String param) {
                return super.getParamSubstitute(param);
            }
        }
        ,
        SPLIT_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.SPLITSHARD, "split", Utils.makeMap("split.key", "splitKey"), Utils.makeMap("coreProperties.", "property.")),
        DELETE_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETESHARD),
        CREATE_REPLICA(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDREPLICA, "add-replica", null, Utils.makeMap("coreProperties.", "property.")),
        DELETE_REPLICA(EndPoint.PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETEREPLICA),
        SYNC_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.SYNCSHARD, "synch-shard", null),
        ADD_REPLICA_PROPERTY(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDREPLICAPROP, "add-replica-property", Utils.makeMap("property", "name", "property.value", "value")),
        DELETE_REPLICA_PROPERTY(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.DELETEREPLICAPROP, "delete-replica-property", null),
        ADD_ROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDROLE, "add-role", null),
        REMOVE_ROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.REMOVEROLE, "remove-role", null),
        SET_CLUSTER_PROPERTY(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CLUSTERPROP, "set-property", null),
        BACKUP_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.BACKUP, "backup-collection", null),
        RESTORE_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.RESTORE, "restore-collection", null),
        GET_NODES(EndPoint.CLUSTER_NODES, SolrRequest.METHOD.GET, null),
        FORCE_LEADER(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.FORCELEADER, "force-leader", null),
        BALANCE_SHARD_UNIQUE(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.BALANCESHARDUNIQUE, "balance-shard-unique", null);

        public final String commandName;
        public final EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final Map<String, String> paramstoAttr;
        public final Map<String, String> prefixSubstitutes;
        public final CollectionParams.CollectionAction action;

        public SolrRequest.METHOD getMethod() {
            return this.method;
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action) {
            this(endPoint, method, action, null, null);
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action, String commandName, Map paramstoAttr) {
            this(endPoint, method, action, commandName, paramstoAttr, Collections.EMPTY_MAP);
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action, String commandName, Map paramstoAttr, Map prefixSubstitutes) {
            this.action = action;
            this.commandName = commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.paramstoAttr = paramstoAttr == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(paramstoAttr);
            this.prefixSubstitutes = Collections.unmodifiableMap(prefixSubstitutes);
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public Collection<String> getParamNames(CommandOperation op) {
            ArrayList<String> paramNames = CollectionApiMapping.getParamNames_(op, this);
            if (!this.prefixSubstitutes.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>(paramNames.size());
                for (Map.Entry<String, String> e : this.prefixSubstitutes.entrySet()) {
                    for (String paramName : paramNames) {
                        if (paramName.startsWith(e.getKey())) {
                            result.add(paramName.replace(e.getKey(), e.getValue()));
                            continue;
                        }
                        result.add(paramName);
                    }
                    paramNames = result;
                }
            }
            return paramNames;
        }

        @Override
        public String getParamSubstitute(String param) {
            String s;
            String string = s = this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
            if (this.prefixSubstitutes != null) {
                for (Map.Entry<String, String> e : this.prefixSubstitutes.entrySet()) {
                    if (!s.startsWith(e.getValue())) continue;
                    return s.replace(e.getValue(), e.getKey());
                }
            }
            return s;
        }

        public Object getReverseParamSubstitute(String param) {
            String s;
            String string = s = this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
            if (this.prefixSubstitutes != null) {
                for (Map.Entry<String, String> e : this.prefixSubstitutes.entrySet()) {
                    if (!param.startsWith(e.getValue())) continue;
                    return new Pair<String, String>(e.getKey().substring(0, e.getKey().length() - 1), param.substring(e.getValue().length()));
                }
            }
            return s;
        }
    }
}

