/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud.rule;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.cloud.rule.RemoteCallback;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnitchContext
implements RemoteCallback {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private String node;
    private Map<String, Object> session;
    public final SnitchInfo snitchInfo;
    public Exception exception;

    public SnitchContext(SnitchInfo perSnitch, String node, Map<String, Object> session) {
        this.snitchInfo = perSnitch;
        this.node = node;
        this.session = session;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void store(String s, Object val) {
        if (this.session != null) {
            this.session.put(s, val);
        }
    }

    public Object retrieve(String s) {
        return this.session != null ? this.session.get(s) : null;
    }

    public abstract Map getZkJson(String var1) throws KeeperException, InterruptedException;

    public String getNode() {
        return this.node;
    }

    public abstract void invokeRemote(String var1, ModifiableSolrParams var2, String var3, RemoteCallback var4);

    @Override
    public void remoteCallback(SnitchContext ctx, Map<String, Object> returnedVal) {
        this.tags.putAll(returnedVal);
    }

    public String getErrMsg() {
        return this.exception == null ? null : this.exception.getMessage();
    }

    public static abstract class SnitchInfo {
        private final Map<String, Object> conf;

        protected SnitchInfo(Map<String, Object> conf) {
            this.conf = conf;
        }

        public abstract Set<String> getTagNames();
    }
}

