/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.7604953758285915\n      > SELECT _FUNC_(null);\n       0.7604953758285915\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0011#\u0001>B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015I\u0005\u0001\"\u0001O\u0011\u0015I\u0005\u0001\"\u0001P\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015A\u0006\u0001\"\u0015Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015\u0011\b\u0001\"\u0011O\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u00199\u0003\u0001\"\u0011\u0002\n!9\u00111\u0004\u0001\u0005R\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\tY\u0003AI\u0001\n\u0003\ti\u0003C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131\n\u0005\n\u00037\u0002\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019iB\u0004\u0002.\nB\t!a,\u0007\r\u0005\u0012\u0003\u0012AAY\u0011\u0019I\u0015\u0004\"\u0001\u0002:\"9\u00111X\r\u0005\u0002\u0005u\u0006\"CA^3\u0005\u0005I\u0011QAa\u0011%\t9-GI\u0001\n\u0003\t)\u0005C\u0005\u0002Jf\t\t\u0011\"!\u0002L\"I\u0011Q\\\r\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003?L\u0012\u0011!C\u0005\u0003C\u0014AAU1oI*\u00111\u0005J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002&M\u0005A1-\u0019;bYf\u001cHO\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001aQR\u0004CA\u00193\u001b\u0005\u0011\u0013BA\u001a#\u0005\r\u0011Fi\u0012\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b!J|G-^2u!\t)4(\u0003\u0002=m\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\tq\b\u0005\u00022\u0001&\u0011\u0011I\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0005iS\u0012,7+Z3e+\u0005)\u0005CA\u001bG\u0013\t9eGA\u0004C_>dW-\u00198\u0002\u0013!LG-Z*fK\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002L\u00196\u0003\"!\r\u0001\t\u000bu*\u0001\u0019A \t\u000f\r+\u0001\u0013!a\u0001\u000bR\t1\n\u0006\u0002L!\")Qh\u0002a\u0001\u007f\u0005Yq/\u001b;i\u001d\u0016<8+Z3e)\tY5\u000bC\u0003U\u0011\u0001\u0007Q+\u0001\u0003tK\u0016$\u0007CA\u001bW\u0013\t9fG\u0001\u0003M_:<\u0017\u0001D3wC2Le\u000e^3s]\u0006dGC\u0001.^!\t)4,\u0003\u0002]m\t1Ai\\;cY\u0016DQAX\u0005A\u0002}\u000bQ!\u001b8qkR\u0004\"\u0001Y1\u000e\u0003\u0011J!A\u0019\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2!Z6q!\t1\u0017.D\u0001h\u0015\tA'%A\u0004d_\u0012,w-\u001a8\n\u0005)<'\u0001C#yaJ\u001cu\u000eZ3\t\u000b1T\u0001\u0019A7\u0002\u0007\r$\b\u0010\u0005\u0002g]&\u0011qn\u001a\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\t(\u00021\u0001f\u0003\t)g/A\u0005ge\u0016\u001c\bnQ8qs\u0006ia\r\\1u\u0003J<W/\\3oiN,\u0012!\u001e\t\u0005mz\f\u0019A\u0004\u0002xy:\u0011\u0001p_\u0007\u0002s*\u0011!PL\u0001\u0007yI|w\u000e\u001e \n\u0003]J!! \u001c\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0011%#XM]1u_JT!! \u001c\u0011\u0007U\n)!C\u0002\u0002\bY\u00121!\u00118z+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005Ua\u0002BA\b\u0003#\u0001\"\u0001\u001f\u001c\n\u0007\u0005Ma'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'1\u0014\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002L\u0003?Aa!!\t\u000f\u0001\u0004y\u0014\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006\u0017\u0006\u001d\u0012\u0011\u0006\u0005\b{=\u0001\n\u00111\u0001@\u0011\u001d\u0019u\u0002%AA\u0002\u0015\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00020)\u001aq(!\r,\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00107\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\n9DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002H)\u001aQ)!\r\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t1\fgn\u001a\u0006\u0003\u0003/\nAA[1wC&!\u0011qCA)\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0006E\u00026\u0003CJ1!a\u00197\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019!!\u001b\t\u0013\u0005-D#!AA\u0002\u0005}\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rA1\u00111OA=\u0003\u0007i!!!\u001e\u000b\u0007\u0005]d'\u0001\u0006d_2dWm\u0019;j_:L1a`A;\u0003!\u0019\u0017M\\#rk\u0006dGcA#\u0002\u0000!I\u00111\u000e\f\u0002\u0002\u0003\u0007\u00111A\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0015\u000b)\tC\u0005\u0002l]\t\t\u00111\u0001\u0002\u0004!:\u0002!!#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi*!)\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0004c\u0005-\u0015bAAGE\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAJ\u0003\u0005-qLR+O\u0007~C3l]3fIvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u0012\u0018M\u001c3p[\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011j]\u0012,\u0007/\u001a8eK:$\b%\u00198eA%$WM\u001c;jG\u0006dG.\u001f\u0011eSN$(/\u001b2vi\u0016$\u0007\u0005K5/S:\"g&\u000b\u0011v]&4wN]7ms\u0002\"\u0017n\u001d;sS\n,H/\u001a3!m\u0006dW/Z:!S:\u00043\f\r\u0017!c%r\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0015!a\u0018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0018:mIJt\u0007\u000e\u001a:kE\"4\u0007N\u001b5g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9:d\u0007\r\u001b:kM:T\u0007\u000f\u001a9ke\nTG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111]]2\u0004\u0007N\u001d6g]*\u0004H\r\u001d6sE*$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003?\u000b!H\u0003\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oA%\u001c\bE\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA%t\u0007eZ3oKJ\fG\u000eI2bg\u0016t#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAV\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0005%\u0006tG\r\u0005\u000223M!\u0011$a-;!\r)\u0014QW\u0005\u0004\u0003o3$AB!osJ+g\r\u0006\u0002\u00020\u0006)\u0011\r\u001d9msR\u00191*a0\t\u000bQ[\u0002\u0019A+\u0015\u000b-\u000b\u0019-!2\t\u000bub\u0002\u0019A \t\u000f\rc\u0002\u0013!a\u0001\u000b\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0017\u0011\u001c\t\u0006k\u0005=\u00171[\u0005\u0004\u0003#4$AB(qi&|g\u000eE\u00036\u0003+|T)C\u0002\u0002XZ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAn=\u0005\u0005\t\u0019A&\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002dB!\u0011qJAs\u0013\u0011\t9/!\u0015\u0003\r=\u0013'.Z2u\u0001")
public class Rand
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(6).append("rand(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Rand withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != rand.hideSeed()) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

