/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListener$class;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0005\u0013\ti1\u000b]5mY2K7\u000f^3oKJT!a\u0001\u0003\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00151\u0011AB1qC\u000eDWMC\u0001\b\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E!R\"\u0001\n\u000b\u0005M\u0011\u0011!C:dQ\u0016$W\u000f\\3s\u0013\t)\"CA\u0007Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAq\u0001\b\u0001C\u0002\u0013%Q$\u0001\u000bti\u0006<W-\u00133U_R\u000b7o['fiJL7m]\u000b\u0002=A!q\u0004\n\u0014*\u001b\u0005\u0001#BA\u0011#\u0003\u001diW\u000f^1cY\u0016T!a\t\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002&A\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u0006(\u0013\tACBA\u0002J]R\u00042a\b\u0016-\u0013\tY\u0003EA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA\u00171\u001b\u0005q#BA\u0018\u0003\u0003!)\u00070Z2vi>\u0014\u0018BA\u0019/\u0005-!\u0016m]6NKR\u0014\u0018nY:\t\rM\u0002\u0001\u0015!\u0003\u001f\u0003U\u0019H/Y4f\u0013\u0012$v\u000eV1tW6+GO]5dg\u0002Bq!\u000e\u0001C\u0002\u0013%a'A\bta&dG.\u001a3Ti\u0006<W-\u00133t+\u00059\u0004cA\u00109M%\u0011\u0011\b\t\u0002\b\u0011\u0006\u001c\bnU3u\u0011\u0019Y\u0004\u0001)A\u0005o\u0005\u00012\u000f]5mY\u0016$7\u000b^1hK&#7\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003)\u0019H/Y4fg\u0012{g.Z\u000b\u0002\u007fA\u0011\u0001iR\u0007\u0002\u0003*\u0011!iQ\u0001\u000bG>t7-\u001e:sK:$(B\u0001#F\u0003\u0011)H/\u001b7\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001*\u0011\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u0019Q\u0005\u0001)A\u0005\u007f\u0005Y1\u000f^1hKN$uN\\3!\u0011\u0015a\u0005\u0001\"\u0001N\u0003AqW/\\*qS2dW\rZ*uC\u001e,7/F\u0001'\u0011\u0015y\u0005\u0001\"\u0011Q\u0003%yg\u000eV1tW\u0016sG\r\u0006\u0002R)B\u00111BU\u0005\u0003'2\u0011A!\u00168ji\")QK\u0014a\u0001-\u00069A/Y:l\u000b:$\u0007CA\tX\u0013\tA&C\u0001\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d+bg.,e\u000e\u001a\u0005\u00065\u0002!\teW\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$\"!\u0015/\t\u000buK\u0006\u0019\u00010\u0002\u001bM$\u0018mZ3D_6\u0004H.\u001a;f!\t\tr,\u0003\u0002a%\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012DQA\u0019\u0001\u0005B\r\f\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0003#\u0012DQ!Z1A\u0002\u0019\faA[8c\u000b:$\u0007CA\th\u0013\tA'CA\nTa\u0006\u00148\u000eT5ti\u0016tWM\u001d&pE\u0016sG\r")
public class SpillListener
implements SparkListener {
    private final HashMap<Object, ArrayBuffer<TaskMetrics>> stageIdToTaskMetrics;
    private final HashSet<Object> spilledStageIds;
    private final CountDownLatch stagesDone;

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        SparkListener$class.onStageSubmitted(this, stageSubmitted);
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        SparkListener$class.onTaskStart(this, taskStart);
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult taskGettingResult) {
        SparkListener$class.onTaskGettingResult(this, taskGettingResult);
    }

    @Override
    public void onJobStart(SparkListenerJobStart jobStart) {
        SparkListener$class.onJobStart(this, jobStart);
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate environmentUpdate) {
        SparkListener$class.onEnvironmentUpdate(this, environmentUpdate);
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        SparkListener$class.onBlockManagerAdded(this, blockManagerAdded);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        SparkListener$class.onBlockManagerRemoved(this, blockManagerRemoved);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        SparkListener$class.onUnpersistRDD(this, unpersistRDD);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        SparkListener$class.onApplicationStart(this, applicationStart);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        SparkListener$class.onApplicationEnd(this, applicationEnd);
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate executorMetricsUpdate) {
        SparkListener$class.onExecutorMetricsUpdate(this, executorMetricsUpdate);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded2) {
        SparkListener$class.onExecutorAdded(this, executorAdded2);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved executorRemoved2) {
        SparkListener$class.onExecutorRemoved(this, executorRemoved2);
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        SparkListener$class.onBlockUpdated(this, blockUpdated);
    }

    private HashMap<Object, ArrayBuffer<TaskMetrics>> stageIdToTaskMetrics() {
        return this.stageIdToTaskMetrics;
    }

    private HashSet<Object> spilledStageIds() {
        return this.spilledStageIds;
    }

    private CountDownLatch stagesDone() {
        return this.stagesDone;
    }

    public int numSpilledStages() {
        Predef$.MODULE$.assert(this.stagesDone().await(10L, TimeUnit.SECONDS));
        return this.spilledStageIds().size();
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        ((ArrayBuffer)this.stageIdToTaskMetrics().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<TaskMetrics> apply() {
                return new ArrayBuffer();
            }
        })).$plus$eq((Object)taskEnd.taskMetrics());
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageComplete) {
        boolean spilled;
        int stageId = stageComplete.stageInfo().stageId();
        Seq metrics = (Seq)Option$.MODULE$.option2Iterable(this.stageIdToTaskMetrics().remove((Object)BoxesRunTime.boxToInteger((int)stageId))).toSeq().flatten((Function1)Predef$.MODULE$.$conforms());
        boolean bl = spilled = BoxesRunTime.unboxToLong((Object)((TraversableOnce)metrics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$3) {
                return x$3.memoryBytesSpilled();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L;
        if (spilled) {
            this.spilledStageIds().$plus$eq((Object)BoxesRunTime.boxToInteger((int)stageId));
        }
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        this.stagesDone().countDown();
    }

    public SpillListener() {
        SparkListener$class.$init$(this);
        this.stageIdToTaskMetrics = new HashMap();
        this.spilledStageIds = new HashSet();
        this.stagesDone = new CountDownLatch(1);
    }
}

