/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.UnifiedMemoryManager;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class UnifiedMemoryManager$ {
    public static final UnifiedMemoryManager$ MODULE$;
    private final int RESERVED_SYSTEM_MEMORY_BYTES;

    static {
        new UnifiedMemoryManager$();
    }

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return this.RESERVED_SYSTEM_MEMORY_BYTES;
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * conf.getDouble("spark.memory.storageFraction", 0.5)), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long reservedMemory;
        double minSystemMemory;
        long systemMemory = conf.getLong("spark.testing.memory", Runtime.getRuntime().maxMemory());
        if ((double)systemMemory < (minSystemMemory = (double)(reservedMemory = conf.getLong("spark.testing.reservedMemory", conf.contains("spark.testing") ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"System memory ", " must "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)systemMemory)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be at least ", ". Please use a larger heap size."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minSystemMemory)}))).toString());
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = conf.getDouble("spark.memory.fraction", 0.75);
        return (long)((double)usableMemory * memoryFraction);
    }

    private UnifiedMemoryManager$() {
        MODULE$ = this;
        this.RESERVED_SYSTEM_MEMORY_BYTES = 314572800;
    }
}

