/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!B\u0001\u0003\u0001\u0011Q!\u0001F+oS\u001aLW\rZ'f[>\u0014\u00180T1oC\u001e,'O\u0003\u0002\u0004\t\u00051Q.Z7pefT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\n\u0003\u0001-\u0001\"\u0001D\u0007\u000e\u0003\tI!A\u0004\u0002\u0003\u001b5+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0011!\u0001\u0002A!A!\u0002\u0013\u0011\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005IQ.\u0019=NK6|'/_\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!Aj\u001c8h\u0011!\u0001\u0003A!A!\u0002\u0013I\u0012AC7bq6+Wn\u001c:zA!A!\u0005\u0001B\u0001B\u0003%\u0011$A\tti>\u0014\u0018mZ3SK\u001eLwN\\*ju\u0016D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\t]Vl7i\u001c:fgB\u0011!DJ\u0005\u0003Om\u00111!\u00138u\u0011\u0019I\u0003\u0001\"\u0001\u0003U\u00051A(\u001b8jiz\"Ra\u000b\u0017.]=\u0002\"\u0001\u0004\u0001\t\u000bAA\u0003\u0019\u0001\n\t\u000b]A\u0003\u0019A\r\t\u000b\tB\u0003\u0019A\r\t\u000b\u0011B\u0003\u0019A\u0013\t\u000bE\u0002A\u0011\u0002\u001a\u0002\u001f\u0005\u001c8/\u001a:u\u0013:4\u0018M]5b]R$\u0012a\r\t\u00035QJ!!N\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006o\u0001!\t\u0005G\u0001\u0011[\u0006D8\u000b^8sC\u001e,W*Z7pefDa!\u000f\u0001\u0005B\tQ\u0014AF1dcVL'/Z#yK\u000e,H/[8o\u001b\u0016lwN]=\u0015\teYTh\u0010\u0005\u0006ya\u0002\r!G\u0001\t]Vl')\u001f;fg\")a\b\u000fa\u00013\u0005iA/Y:l\u0003R$X-\u001c9u\u0013\u0012DQ\u0001\u0011\u001dA\u0002\u0005\u000b!\"\\3n_JLXj\u001c3f!\ta!)\u0003\u0002D\u0005\tQQ*Z7peflu\u000eZ3\t\u000b\u0015\u0003A\u0011\t$\u0002)\u0005\u001c\u0017/^5sKN#xN]1hK6+Wn\u001c:z)\u00119%JU*\u0011\u0005iA\u0015BA%\u001c\u0005\u001d\u0011un\u001c7fC:DQa\u0013#A\u00021\u000bqA\u00197pG.LE\r\u0005\u0002N!6\taJ\u0003\u0002P\t\u000591\u000f^8sC\u001e,\u0017BA)O\u0005\u001d\u0011En\\2l\u0013\u0012DQ\u0001\u0010#A\u0002eAQ\u0001\u0016#A\u0002U\u000bQ\"\u001a<jGR,GM\u00117pG.\u001c\bc\u0001,\\;6\tqK\u0003\u0002Y3\u00069Q.\u001e;bE2,'B\u0001.\u001c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039^\u0013aAQ;gM\u0016\u0014\b\u0003\u0002\u000e_\u0019\u0002L!aX\u000e\u0003\rQ+\b\u000f\\33!\ti\u0015-\u0003\u0002c\u001d\nY!\t\\8dWN#\u0018\r^;t\u0011\u0015!\u0007\u0001\"\u0011f\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u00119em\u001a5\t\u000b-\u001b\u0007\u0019\u0001'\t\u000bq\u001a\u0007\u0019A\r\t\u000bQ\u001b\u0007\u0019A+\b\u000b)\u0014\u0001\u0012A6\u0002)Us\u0017NZ5fI6+Wn\u001c:z\u001b\u0006t\u0017mZ3s!\taANB\u0003\u0002\u0005!\u0005Qn\u0005\u0002m]B\u0011!d\\\u0005\u0003an\u0011a!\u00118z%\u00164\u0007\"B\u0015m\t\u0003\u0011H#A6\t\u000fQd'\u0019!C\u0005k\u0006a\"+R*F%Z+EiX*Z'R+UjX'F\u001b>\u0013\u0016l\u0018\"Z)\u0016\u001bV#A\u0013\t\r]d\u0007\u0015!\u0003&\u0003u\u0011ViU#S-\u0016#ulU-T)\u0016ku,T#N\u001fJKvLQ-U\u000bN\u0003\u0003\"B=m\t\u0003Q\u0018!B1qa2LHcA\u0016|y\")\u0001\u0003\u001fa\u0001%!)A\u0005\u001fa\u0001K!)a\u0010\u001cC\u0005\u007f\u0006aq-\u001a;NCblU-\\8ssR\u0019\u0011$!\u0001\t\u000bAi\b\u0019\u0001\n")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxMemory;
    private final long storageRegionSize;

    public static UnifiedMemoryManager apply(SparkConf sparkConf, int n) {
        return UnifiedMemoryManager$.MODULE$.apply(sparkConf, n);
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    private void assertInvariant() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.storageMemoryPool().poolSize() == this.maxMemory());
    }

    @Override
    public synchronized long maxStorageMemory() {
        return this.maxMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            long l;
            block3: {
                block2: {
                    this.assertInvariant();
                    Predef$.MODULE$.assert(numBytes >= 0L);
                    memoryMode2 = memoryMode;
                    if (!((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) break block2;
                    l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ UnifiedMemoryManager $outer;

                        public final void apply(long extraMemoryNeeded) {
                            this.apply$mcVJ$sp(extraMemoryNeeded);
                        }

                        public void apply$mcVJ$sp(long extraMemoryNeeded) {
                            this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(extraMemoryNeeded);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ UnifiedMemoryManager $outer;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    break block3;
                }
                if (!((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) break block4;
                l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
            }
            return l;
        }
        throw new MatchError((Object)memoryMode2);
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        this.assertInvariant();
        Predef$.MODULE$.assert(numBytes >= 0L);
        if (numBytes > this.maxStorageMemory()) {
            this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnifiedMemoryManager $outer;
                private final BlockId blockId$1;
                private final long numBytes$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxStorageMemory())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.numBytes$1 = numBytes$1;
                }
            });
            return false;
        }
        if (numBytes > this.storageMemoryPool().memoryFree()) {
            long memoryBorrowedFromExecution = Math.min(this.onHeapExecutionMemoryPool().memoryFree(), numBytes);
            this.onHeapExecutionMemoryPool().decrementPoolSize(memoryBorrowedFromExecution);
            this.storageMemoryPool().incrementPoolSize(memoryBorrowedFromExecution);
        }
        return this.storageMemoryPool().acquireMemory(blockId, numBytes, evictedBlocks);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        return this.acquireStorageMemory(blockId, numBytes, evictedBlocks);
    }

    public final void org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(long extraMemoryNeeded) {
        long memoryReclaimableFromStorage;
        if (extraMemoryNeeded > 0L && (memoryReclaimableFromStorage = package$.MODULE$.max(this.storageMemoryPool().memoryFree(), this.storageMemoryPool().poolSize() - this.storageRegionSize)) > 0L) {
            long spaceToReclaim = this.storageMemoryPool().freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
            this.storageMemoryPool().decrementPoolSize(spaceToReclaim);
            this.onHeapExecutionMemoryPool().incrementPoolSize(spaceToReclaim);
        }
    }

    public final long org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1() {
        return this.maxMemory() - package$.MODULE$.min(this.storageMemoryUsed(), this.storageRegionSize);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxMemory, long storageRegionSize, int numCores) {
        this.maxMemory = maxMemory;
        this.storageRegionSize = storageRegionSize;
        super(conf, numCores, storageRegionSize, maxMemory - storageRegionSize);
        this.assertInvariant();
    }
}

