/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.partial;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.partial.ApproximateEvaluator;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.StudentTCacher;
import org.apache.spark.util.StatCounter;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t)\u00111c\u0012:pkB,GmU;n\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u000fA\f'\u000f^5bY*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014x-\u0006\u0002\fAM\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\u0011\u0019BCF\u0018\u000e\u0003\tI!!\u0006\u0002\u0003)\u0005\u0003\bO]8yS6\fG/Z#wC2,\u0018\r^8s!\u00119BD\b\u0016\u000e\u0003aQ!!\u0007\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002DA\u0004ICNDW*\u00199\u0011\u0005}\u0001C\u0002\u0001\u0003\u0006C\u0001\u0011\ra\t\u0002\u0002)\u000e\u0001\u0011C\u0001\u0013(!\tiQ%\u0003\u0002'\u001d\t9aj\u001c;iS:<\u0007CA\u0007)\u0013\tIcBA\u0002B]f\u0004\"aK\u0017\u000e\u00031R!!\u0007\u0003\n\u00059b#aC*uCR\u001cu.\u001e8uKJ\u0004B\u0001M\u001a\u001fk5\t\u0011G\u0003\u00023\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q\n$aA'baB\u00111CN\u0005\u0003o\t\u0011QBQ8v]\u0012,G\rR8vE2,\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u0019Q|G/\u00197PkR\u0004X\u000f^:\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\rIe\u000e\u001e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005Q1m\u001c8gS\u0012,gnY3\u0011\u00055\u0001\u0015BA!\u000f\u0005\u0019!u.\u001e2mK\")1\t\u0001C\u0001\t\u00061A(\u001b8jiz\"2!\u0012$H!\r\u0019\u0002A\b\u0005\u0006s\t\u0003\rA\u000f\u0005\u0006}\t\u0003\ra\u0010\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u00035yW\u000f\u001e9viNlUM]4fIV\t!\bC\u0004M\u0001\u0001\u0007I\u0011A'\u0002#=,H\u000f];ug6+'oZ3e?\u0012*\u0017\u000f\u0006\u0002O#B\u0011QbT\u0005\u0003!:\u0011A!\u00168ji\"9!kSA\u0001\u0002\u0004Q\u0014a\u0001=%c!1A\u000b\u0001Q!\ni\nab\\;uaV$8/T3sO\u0016$\u0007\u0005C\u0004W\u0001\u0001\u0007I\u0011A,\u0002\tM,Xn]\u000b\u0002-!9\u0011\f\u0001a\u0001\n\u0003Q\u0016\u0001C:v[N|F%Z9\u0015\u00059[\u0006b\u0002*Y\u0003\u0003\u0005\rA\u0006\u0005\u0007;\u0002\u0001\u000b\u0015\u0002\f\u0002\u000bM,Xn\u001d\u0011\t\u000b}\u0003A\u0011\t1\u0002\u000b5,'oZ3\u0015\u00079\u000b7\rC\u0003c=\u0002\u0007!(\u0001\u0005pkR\u0004X\u000f^%e\u0011\u0015!g\f1\u0001\u0017\u0003)!\u0018m]6SKN,H\u000e\u001e\u0005\u0006M\u0002!\teZ\u0001\u000eGV\u0014(/\u001a8u%\u0016\u001cX\u000f\u001c;\u0015\u0003=\u0002")
public class GroupedSumEvaluator<T>
implements ApproximateEvaluator<HashMap<T, StatCounter>, Map<T, BoundedDouble>> {
    private final int totalOutputs;
    private final double confidence;
    private int outputsMerged;
    private HashMap<T, StatCounter> sums;

    public int outputsMerged() {
        return this.outputsMerged;
    }

    public void outputsMerged_$eq(int x$1) {
        this.outputsMerged = x$1;
    }

    public HashMap<T, StatCounter> sums() {
        return this.sums;
    }

    public void sums_$eq(HashMap<T, StatCounter> x$1) {
        this.sums = x$1;
    }

    @Override
    public void merge(int outputId, HashMap<T, StatCounter> taskResult) {
        this.outputsMerged_$eq(this.outputsMerged() + 1);
        for (Map.Entry<T, StatCounter> entry : taskResult.entrySet()) {
            StatCounter old = this.sums().get(entry.getKey());
            StatCounter statCounter = old == null ? this.sums().put(entry.getKey(), entry.getValue()) : old.merge(entry.getValue());
        }
    }

    @Override
    public Map<T, BoundedDouble> currentResult() {
        scala.collection.mutable.HashMap hashMap;
        if (this.outputsMerged() == this.totalOutputs) {
            HashMap<T, BoundedDouble> result = new HashMap<T, BoundedDouble>(this.sums().size());
            for (Map.Entry<T, StatCounter> entry : this.sums().entrySet()) {
                double sum2 = entry.getValue().sum();
                result.put(entry.getKey(), new BoundedDouble(sum2, 1.0, sum2, sum2));
            }
            hashMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(result).asScala();
        } else if (this.outputsMerged() == 0) {
            hashMap = new scala.collection.mutable.HashMap();
        } else {
            double p = (double)this.outputsMerged() / (double)this.totalOutputs;
            StudentTCacher studentTCacher = new StudentTCacher(this.confidence);
            HashMap<T, BoundedDouble> result = new HashMap<T, BoundedDouble>(this.sums().size());
            for (Map.Entry<T, StatCounter> entry : this.sums().entrySet()) {
                StatCounter counter = entry.getValue();
                double meanEstimate = counter.mean();
                double meanVar = counter.sampleVariance() / (double)counter.count();
                double countEstimate = ((double)(counter.count() + 1L) - p) / p;
                double countVar = (double)(counter.count() + 1L) * (1.0 - p) / (p * p);
                double sumEstimate = meanEstimate * countEstimate;
                double sumVar = meanEstimate * meanEstimate * countVar + countEstimate * countEstimate * meanVar + meanVar * countVar;
                double sumStdev = package$.MODULE$.sqrt(sumVar);
                double confFactor = studentTCacher.get(counter.count());
                double low = sumEstimate - confFactor * sumStdev;
                double high = sumEstimate + confFactor * sumStdev;
                result.put(entry.getKey(), new BoundedDouble(sumEstimate, this.confidence, low, high));
            }
            hashMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(result).asScala();
        }
        return hashMap;
    }

    public GroupedSumEvaluator(int totalOutputs, double confidence) {
        this.totalOutputs = totalOutputs;
        this.confidence = confidence;
        this.outputsMerged = 0;
        this.sums = new HashMap();
    }
}

