/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkException;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.netty.Dispatcher$;
import org.apache.spark.rpc.netty.Inbox;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.LocalNettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointAddress;
import org.apache.spark.rpc.netty.RpcMessage;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.Promise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tma!B\u0001\u0003\u0001\ta!A\u0003#jgB\fGo\u00195fe*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\u0019I!A\u0006\u0004\u0003\u000f1{wmZ5oO\"A\u0001\u0004\u0001B\u0001B\u0003%!$\u0001\u0005oKR$\u00180\u00128w\u0007\u0001\u0001\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u00179+G\u000f^=Sa\u000e,eN\u001e\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0012\u0003CA\u000e\u0001\u0011\u0015Ab\u00041\u0001\u001b\r\u0011!\u0003\u0001B\u0013\u0003\u0019\u0015sG\r]8j]R$\u0015\r^1\u0014\u0005\rj\u0001\u0002C\u0014$\u0005\u000b\u0007I\u0011\u0001\u0015\u0002\t9\fW.Z\u000b\u0002SA\u0011!&\f\b\u0003\u001d-J!\u0001L\b\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y=A\u0001\"M\u0012\u0003\u0002\u0003\u0006I!K\u0001\u0006]\u0006lW\r\t\u0005\tg\r\u0012)\u0019!C\u0001i\u0005AQM\u001c3q_&tG/F\u00016!\t1t'D\u0001\u0005\u0013\tADAA\u0006Sa\u000e,e\u000e\u001a9pS:$\b\u0002\u0003\u001e$\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0013\u0015tG\r]8j]R\u0004\u0003\u0002\u0003\u001f$\u0005\u000b\u0007I\u0011A\u001f\u0002\u0007I,g-F\u0001?!\tYr(\u0003\u0002A\u0005\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"A!i\tB\u0001B\u0003%a(\u0001\u0003sK\u001a\u0004\u0003\"B\u0010$\t\u0003!E\u0003B#H\u0011&\u0003\"AR\u0012\u000e\u0003\u0001AQaJ\"A\u0002%BQaM\"A\u0002UBQ\u0001P\"A\u0002yBqaS\u0012C\u0002\u0013\u0005A*A\u0003j]\n|\u00070F\u0001N!\tYb*\u0003\u0002P\u0005\t)\u0011J\u001c2pq\"1\u0011k\tQ\u0001\n5\u000ba!\u001b8c_b\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\nK:$\u0007o\\5oiN,\u0012!\u0016\t\u0005-vKS)D\u0001X\u0015\tA\u0016,\u0001\u0006d_:\u001cWO\u001d:f]RT!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tqvKA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\u0005\u0007A\u0002\u0001\u000b\u0011B+\u0002\u0015\u0015tG\r]8j]R\u001c\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002\u0019\u0015tG\r]8j]R\u0014VMZ:\u0016\u0003\u0011\u0004BAV/6KB\u0011aGZ\u0005\u0003O\u0012\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0003\u0004j\u0001\u0001\u0006I\u0001Z\u0001\u000eK:$\u0007o\\5oiJ+gm\u001d\u0011\t\u000f-\u0004!\u0019!C\u0005Y\u0006I!/Z2fSZ,'o]\u000b\u0002[B\u0019aK\\#\n\u0005=<&a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007BB9\u0001A\u0003%Q.\u0001\u0006sK\u000e,\u0017N^3sg\u0002Bqa\u001d\u0001A\u0002\u0013%A/A\u0004ti>\u0004\b/\u001a3\u0016\u0003U\u0004\"A\u0004<\n\u0005]|!a\u0002\"p_2,\u0017M\u001c\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\u0005mt\bC\u0001\b}\u0013\tixB\u0001\u0003V]&$\bbB@y\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0004bBA\u0002\u0001\u0001\u0006K!^\u0001\tgR|\u0007\u000f]3eA!B\u0011\u0011AA\u0004\u00033\tY\u0002\u0005\u0003\u0002\n\u0005UQBAA\u0006\u0015\rA\u0016Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0006b]:|G/\u0019;j_:T!!a\u0005\u0002\u000b)\fg/\u0019=\n\t\u0005]\u00111\u0002\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!!\b\u0002\tQD\u0017n\u001d\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003M\u0011XmZ5ti\u0016\u0014(\u000b]2F]\u0012\u0004x.\u001b8u)\u0015q\u0014QEA\u0014\u0011\u00199\u0013q\u0004a\u0001S!11'a\bA\u0002UBq!a\u000b\u0001\t\u0003\ti#A\thKR\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001a$2!ZA\u0018\u0011\u0019\u0019\u0014\u0011\u0006a\u0001k!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012\u0001\u0006:f[>4XM\u00159d\u000b:$\u0007o\\5oiJ+g\rF\u0002|\u0003oAaaMA\u0019\u0001\u0004)\u0004bBA\u001e\u0001\u0011%\u0011QH\u0001\u0016k:\u0014XmZ5ti\u0016\u0014(\u000b]2F]\u0012\u0004x.\u001b8u)\rY\u0018q\b\u0005\u0007O\u0005e\u0002\u0019A\u0015\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F\u0005!1\u000f^8q)\rY\u0018q\t\u0005\b\u0003\u0013\n\t\u00051\u0001f\u00039\u0011\boY#oIB|\u0017N\u001c;SK\u001aDq!!\u0014\u0001\t\u0003\ty%A\u0005q_N$Hk\\!mYR\u001910!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\nq!\\3tg\u0006<W\rE\u0002\u001c\u0003/J1!!\u0017\u0003\u00051IeNY8y\u001b\u0016\u001c8/Y4f\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n\u0011\u0003]8tiJ+Wn\u001c;f\u001b\u0016\u001c8/Y4f)\u0015Y\u0018\u0011MA5\u0011!\t\u0019&a\u0017A\u0002\u0005\r\u0004cA\u000e\u0002f%\u0019\u0011q\r\u0002\u0003\u001dI+\u0017/^3ti6+7o]1hK\"A\u00111NA.\u0001\u0004\ti'\u0001\u0005dC2d'-Y2l!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\naa\u00197jK:$(bAA<\r\u00059a.\u001a;x_J\\\u0017\u0002BA>\u0003c\u00121C\u00159d%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.Dq!a \u0001\t\u0003\t\t)\u0001\tq_N$Hj\\2bY6+7o]1hKR)10a!\u0002\u0006\"A\u00111KA?\u0001\u0004\t\u0019\u0007\u0003\u0005\u0002\b\u0006u\u0004\u0019AAE\u0003\u0005\u0001\bCBAF\u0003\u001f\u000b\u0019*\u0004\u0002\u0002\u000e*\u0011\u0001lD\u0005\u0005\u0003#\u000biIA\u0004Qe>l\u0017n]3\u0011\u00079\t)*C\u0002\u0002\u0018>\u00111!\u00118z\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000b\u0011\u0003]8ti>sWmV1z\u001b\u0016\u001c8/Y4f)\rY\u0018q\u0014\u0005\t\u0003'\nI\n1\u0001\u0002d!9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0016a\u00039pgRlUm]:bO\u0016$ra_AT\u0003W\u000bi\u000bC\u0004\u0002*\u0006\u0005\u0006\u0019A\u0015\u0002\u0019\u0015tG\r]8j]Rt\u0015-\\3\t\u0011\u0005M\u0013\u0011\u0015a\u0001\u0003+B\u0001\"a,\u0002\"\u0002\u0007\u0011\u0011W\u0001\u0012G\u0006dGNY1dW&37\u000b^8qa\u0016$\u0007C\u0002\b\u00024\u0006]60C\u0002\u00026>\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005e\u0016\u0011\u001a\b\u0005\u0003w\u000b)M\u0004\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t-G\u0001\u0007yI|w\u000e\u001e \n\u0003AI1!a2\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!a3\u0002N\nIQ\t_2faRLwN\u001c\u0006\u0004\u0003\u000f|\u0001bBA\"\u0001\u0011\u0005\u0011\u0011\u001b\u000b\u0002w\"9\u0011Q\u001b\u0001\u0005\u0002\u0005E\u0017\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0011\u001d\tI\u000e\u0001C\u0001\u00037\faA^3sS\u001aLHcA;\u0002^\"1q%a6A\u0002%B\u0011\"!9\u0001\u0005\u0004%I!a9\u0002\u0015QD'/Z1ea>|G.\u0006\u0002\u0002fB\u0019a+a:\n\u0007\u0005%xK\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\b\u0002CAw\u0001\u0001\u0006I!!:\u0002\u0017QD'/Z1ea>|G\u000e\t\u0004\u0007\u0003c\u0004A!a=\u0003\u00175+7o]1hK2{w\u000e]\n\u0007\u0003_\f)P!\u0001\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?\\\u0003\u0011a\u0017M\\4\n\t\u0005}\u0018\u0011 \u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005](1A\u0005\u0005\u0005\u000b\tIP\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001dy\u0012q\u001eC\u0001\u0005\u0013!\"Aa\u0003\u0011\u0007\u0019\u000by\u000f\u0003\u0005\u0003\u0010\u0005=H\u0011IAi\u0003\r\u0011XO\u001c\u0005\n\u0005'\u0001!\u0019!C\u0005\u0005+\t!\u0002U8jg>t\u0007+\u001b7m+\u0005)\u0005b\u0002B\r\u0001\u0001\u0006I!R\u0001\f!>L7o\u001c8QS2d\u0007\u0005")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentMap<String, EndpointData> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor threadpool;
    private final EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private ConcurrentMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            block5: {
                if (this.stopped()) {
                    throw new IllegalStateException("RpcEnv has been stopped");
                }
                if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) break block5;
                EndpointData data = (EndpointData)this.endpoints().get(name);
                this.endpointRefs().put(data.endpoint(), data.ref());
                BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data));
                return endpointRef;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is already an RpcEndpoint called ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    public void org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(String name) {
        EndpointData data = (EndpointData)this.endpoints().remove(name);
        if (data != null) {
            data.inbox().stop();
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Dispatcher $outer;
                public final InboxMessage message$1;

                public final void apply(Exception e) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$postToAll$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message ", " dropped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.message$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)new Serializable(this, callback){
            public static final long serialVersionUID = 0L;
            private final RpcResponseCallback callback$1;

            public final void apply(Exception e) {
                this.callback$1.onFailure((Throwable)e);
            }
            {
                this.callback$1 = callback$1;
            }
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)new Serializable(this, p){
            public static final long serialVersionUID = 0L;
            private final Promise p$1;

            public final void apply(Exception e) {
                this.p$1.tryFailure((Throwable)e);
            }
            {
                this.p$1 = p$1;
            }
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Exception e) {
                throw e;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Boolean bl;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Boolean bl2;
            EndpointData data = (EndpointData)this.endpoints().get(endpointName);
            if (this.stopped() || data == null) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                data.inbox().post(message);
                this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
                bl2 = BoxesRunTime.boxToBoolean((boolean)false);
            }
            bl = bl2;
        }
        boolean shouldCallOnStop = BoxesRunTime.unboxToBoolean((Object)bl);
        if (shouldCallOnStop) {
            Exception error2 = this.stopped() ? new IllegalStateException("RpcEnv already stopped.") : new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find ", " or it has been stopped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{endpointName})));
            callbackIfStopped.apply((Object)error2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                return;
            }
            this.stopped_$eq(true);
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Dispatcher $outer;

            public final void apply(String name) {
                this.$outer.org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(name);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
        this.threadpool().shutdown();
    }

    public void awaitTermination() {
        this.threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    private ThreadPoolExecutor threadpool() {
        return this.threadpool;
    }

    public EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    }

    /*
     * WARNING - void declaration
     */
    public Dispatcher(NettyRpcEnv nettyEnv) {
        void var3_3;
        this.nettyEnv = nettyEnv;
        Logging$class.$init$(this);
        this.endpoints = new ConcurrentHashMap<String, EndpointData>();
        this.endpointRefs = new ConcurrentHashMap<RpcEndpoint, RpcEndpointRef>();
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int numThreads = nettyEnv.conf().getInt("spark.rpc.netty.dispatcher.numThreads", Runtime.getRuntime().availableProcessors());
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "dispatcher-event-loop");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)new Serializable(this, pool){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Dispatcher $outer;
            private final ThreadPoolExecutor pool$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.pool$1.execute(this.$outer.new MessageLoop());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pool$1 = pool$1;
            }
        });
        this.threadpool = var3_3;
        this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    public class MessageLoop
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    EndpointData data;
                    block7: {
                        try {
                            EndpointData endpointData = data = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill();
                            if (endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null) break block7;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String>)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$1;

                                public final String apply() {
                                    return this.e$1.getMessage();
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            }, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
                        return;
                    }
                    data.inbox().process(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer());
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }

    public class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }
}

