/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import org.apache.spark.Accumulator;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.Partition;
import org.apache.spark.Partition$class;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0001\u0011Q!AD*ik\u001a4G.Z'baR\u000b7o\u001b\u0006\u0003\u0007\u0011\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0013!\raQbD\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0005)\u0006\u001c8\u000e\u0005\u0002\r!%\u0011\u0011C\u0001\u0002\n\u001b\u0006\u00048\u000b^1ukN\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oO\"Iq\u0003\u0001B\u0001B\u0003%\u0011dH\u0001\bgR\fw-Z%e\u0007\u0001\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0013\t9R\u0002C\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001aE\u0005q1\u000f^1hK\u0006#H/Z7qi&#\u0017BA\u0011\u000e\u0011!!\u0003A!A!\u0002\u0013)\u0013A\u0003;bg.\u0014\u0015N\\1ssB\u0019a%K\u0016\u000e\u0003\u001dR!\u0001\u000b\u0003\u0002\u0013\t\u0014x.\u00193dCN$\u0018B\u0001\u0016(\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u0002\u001bY9J!!L\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005iy\u0013B\u0001\u0019\u001c\u0005\u0011\u0011\u0015\u0010^3\t\u0011I\u0002!\u0011!Q\u0001\nM\n\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0005M!\u0014BA\u001b\u0005\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u00058\u0001\t\u0005\r\u0011\"\u00039\u0003\u0011awnY:\u0016\u0003e\u00022A\u000f\"F\u001d\tY\u0004I\u0004\u0002=\u007f5\tQH\u0003\u0002?1\u00051AH]8pizJ\u0011\u0001H\u0005\u0003\u0003n\tq\u0001]1dW\u0006<W-\u0003\u0002D\t\n\u00191+Z9\u000b\u0005\u0005[\u0002C\u0001\u0007G\u0013\t9%A\u0001\u0007UCN\\Gj\\2bi&|g\u000e\u0003\u0005J\u0001\t\u0005\r\u0011\"\u0003K\u0003!awnY:`I\u0015\fHCA&O!\tQB*\u0003\u0002N7\t!QK\\5u\u0011\u001dy\u0005*!AA\u0002e\n1\u0001\u001f\u00132\u0011!\t\u0006A!A!B\u0013I\u0014!\u00027pGN\u0004\u0003F\u0001)T!\tQB+\u0003\u0002V7\tIAO]1og&,g\u000e\u001e\u0005\t/\u0002\u0011\t\u0011)A\u00051\u0006!\u0012N\u001c;fe:\fG.Q2dk6,H.\u0019;peN\u00042A\u000f\"Z!\r\u0019\"\fX\u0005\u00037\u0012\u00111\"Q2dk6,H.\u0019;peB\u0011!$X\u0005\u0003=n\u0011A\u0001T8oO\")\u0001\r\u0001C\u0001C\u00061A(\u001b8jiz\"rAY2eK\u001a<\u0007\u000e\u0005\u0002\r\u0001!)qc\u0018a\u00013!)\u0011e\u0018a\u00013!)Ae\u0018a\u0001K!)!g\u0018a\u0001g!)qg\u0018a\u0001s!)qk\u0018a\u00011\")\u0001\r\u0001C\u0001UR\u0011!m\u001b\u0005\u0006Y&\u0004\r!G\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004o\u0001\t\u0007I\u0011\u0002\u001d\u0002\u001bA\u0014XMZ3se\u0016$Gj\\2t\u0011\u0019\u0001\b\u0001)A\u0005s\u0005q\u0001O]3gKJ\u0014X\r\u001a'pGN\u0004\u0003FA8T\u0011\u0015\u0019\b\u0001\"\u0011u\u0003\u001d\u0011XO\u001c+bg.$\"aD;\t\u000bY\u0014\b\u0019A<\u0002\u000f\r|g\u000e^3yiB\u00111\u0003_\u0005\u0003s\u0012\u00111\u0002V1tW\u000e{g\u000e^3yi\")1\u0010\u0001C!q\u0005\u0011\u0002O]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t\u0011\u0015i\b\u0001\"\u0011\u007f\u0003!!xn\u0015;sS:<G#A@\u0011\t\u0005\u0005\u0011q\u0001\b\u00045\u0005\r\u0011bAA\u00037\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\u001c\u0001")
public class ShuffleMapTask
extends Task<MapStatus>
implements Logging {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private transient Seq<TaskLocation> locs;
    private final transient Seq<TaskLocation> preferredLocs;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private Seq<TaskLocation> locs() {
        return this.locs;
    }

    private void locs_$eq(Seq<TaskLocation> x$1) {
        this.locs = x$1;
    }

    private Seq<TaskLocation> preferredLocs() {
        return this.preferredLocs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MapStatus runTask(TaskContext context) {
        Tuple2 tuple22;
        long deserializeStartTime = System.currentTimeMillis();
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        RDD rdd = (RDD)tuple2._1();
        ShuffleDependency dep = (ShuffleDependency)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)rdd, (Object)dep);
        RDD rdd2 = (RDD)tuple23._1();
        ShuffleDependency dep2 = (ShuffleDependency)tuple23._2();
        this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
        this.metrics_$eq((Option<TaskMetrics>)new Some((Object)context.taskMetrics()));
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep2.shuffleHandle(), this.partitionId(), context);
            writer.write(rdd2.iterator(this.partition, context));
            return (MapStatus)writer.stop(true).get();
        }
        catch (Exception exception2) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer == null ? BoxedUnit.UNIT : writer.stop(false);
                throw exception2;
            }
            catch (Exception exception3) {
                this.log().debug("Could not stop writer", (Throwable)exception3);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception2;
        }
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("ShuffleMapTask(%d, %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.stageId()), BoxesRunTime.boxToInteger((int)this.partitionId())}));
    }

    public ShuffleMapTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, Seq<Accumulator<Object>> internalAccumulators) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.locs = locs;
        super(stageId, stageAttemptId, partition.index(), internalAccumulators);
        Logging$class.$init$(this);
        this.preferredLocs = this.locs() == null ? Nil$.MODULE$ : this.locs().toSet().toSeq();
    }

    public ShuffleMapTask(int partitionId) {
        this(0, 0, null, new Partition(){

            public int hashCode() {
                return Partition$class.hashCode(this);
            }

            public int index() {
                return 0;
            }
            {
                Partition$class.$init$(this);
            }
        }, null, null);
    }
}

