/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.File;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.ExternalSorter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!B\u0001\u0003\u0001\u0019a!!E*peR\u001c\u0006.\u001e4gY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0005g>\u0014HO\u0003\u0002\u0006\r\u000591\u000f[;gM2,'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\t5!\"eM\n\u0004\u00019!\u0003\u0003B\b\u0011%\u0005j\u0011\u0001B\u0005\u0003#\u0011\u0011Qb\u00155vM\u001adWm\u0016:ji\u0016\u0014\bCA\n\u0015\u0019\u0001!Q!\u0006\u0001C\u0002]\u0011\u0011aS\u0002\u0001#\tAb\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0004O_RD\u0017N\\4\u0011\u0005ey\u0012B\u0001\u0011\u001b\u0005\r\te.\u001f\t\u0003'\t\"Qa\t\u0001C\u0002]\u0011\u0011A\u0016\t\u0003K\u0019j\u0011AB\u0005\u0003O\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003Q\u0019\b.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<feB\u0011qbK\u0005\u0003Y\u0011\u0011\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<fe\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\u0004iC:$G.\u001a\t\u0006\u001fA\u0012\u0012EM\u0005\u0003c\u0011\u0011\u0011CQ1tKNCWO\u001a4mK\"\u000bg\u000e\u001a7f!\t\u00192\u0007B\u00035\u0001\t\u0007qCA\u0001D\u0011!1\u0004A!A!\u0002\u00139\u0014!B7ba&#\u0007CA\r9\u0013\tI$DA\u0002J]RD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\bG>tG/\u001a=u!\t)S(\u0003\u0002?\r\tYA+Y:l\u0007>tG/\u001a=u\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q)!\tR#G\u000fB)1\t\u0001\n\"e5\t!\u0001C\u0003*\u007f\u0001\u0007!\u0006C\u0003/\u007f\u0001\u0007q\u0006C\u00037\u007f\u0001\u0007q\u0007C\u0003<\u007f\u0001\u0007A\bC\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u0007\u0011,\u0007/F\u0001L!\u0015)CJE\u00113\u0013\tieAA\tTQV4g\r\\3EKB,g\u000eZ3oGfDaa\u0014\u0001!\u0002\u0013Y\u0015\u0001\u00023fa\u0002Bq!\u0015\u0001C\u0002\u0013%!+\u0001\u0007cY>\u001c7.T1oC\u001e,'/F\u0001T!\t!v+D\u0001V\u0015\t1f!A\u0004ti>\u0014\u0018mZ3\n\u0005a+&\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\bB\u0002.\u0001A\u0003%1+A\u0007cY>\u001c7.T1oC\u001e,'\u000f\t\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0003\u0019\u0019xN\u001d;feV\ta\f\r\u0002`QB)\u0001-\u001a\n\"O6\t\u0011M\u0003\u0002cG\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u00114\u0011\u0001B;uS2L!AZ1\u0003\u001d\u0015CH/\u001a:oC2\u001cvN\u001d;feB\u00111\u0003\u001b\u0003\nS*\f\t\u0011!A\u0003\u0002]\u00111a\u0018\u00132\u0011\u0019Y\u0007\u0001)Q\u0005Y\u000691o\u001c:uKJ\u0004\u0003GA7p!\u0015\u0001WME\u0011o!\t\u0019r\u000eB\u0005jU\u0006\u0005\t\u0011!B\u0001/!9\u0011\u000f\u0001a\u0001\n\u0013\u0011\u0018AC:peR,'o\u0018\u0013fcR\u00111O\u001e\t\u00033QL!!\u001e\u000e\u0003\tUs\u0017\u000e\u001e\u0005\boB\f\t\u00111\u0001y\u0003\rAH%\r\u0019\u0003sn\u0004R\u0001Y3\u0013Ci\u0004\"aE>\u0005\u0013%T\u0017\u0011!A\u0001\u0006\u00039\u0002bB?\u0001\u0001\u0004%IA`\u0001\tgR|\u0007\u000f]5oOV\tq\u0010E\u0002\u001a\u0003\u0003I1!a\u0001\u001b\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\u0002\u0019M$x\u000e\u001d9j]\u001e|F%Z9\u0015\u0007M\fY\u0001\u0003\u0005x\u0003\u000b\t\t\u00111\u0001\u0000\u0011\u001d\ty\u0001\u0001Q!\n}\f\u0011b\u001d;paBLgn\u001a\u0011\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0011!C7baN#\u0018\r^;t+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBB\u0001\ng\u000eDW\rZ;mKJLA!!\t\u0002\u001c\tIQ*\u00199Ti\u0006$Xo\u001d\u0005\n\u0003K\u0001\u0001\u0019!C\u0005\u0003O\tQ\"\\1q'R\fG/^:`I\u0015\fHcA:\u0002*!Iq/a\t\u0002\u0002\u0003\u0007\u0011q\u0003\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u0018\u0005QQ.\u00199Ti\u0006$Xo\u001d\u0011\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0012\u0001D<sSR,W*\u001a;sS\u000e\u001cXCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e\r\u0005AQ\r_3dkR|'/\u0003\u0003\u0002@\u0005e\"aE*ik\u001a4G.Z,sSR,W*\u001a;sS\u000e\u001c\b\u0002CA\"\u0001\u0001\u0006I!!\u000e\u0002\u001b]\u0014\u0018\u000e^3NKR\u0014\u0018nY:!\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\nQa\u001e:ji\u0016$2a]A&\u0011!\ti%!\u0012A\u0002\u0005=\u0013a\u0002:fG>\u0014Hm\u001d\t\u0007\u0003#\n\t'a\u001a\u000f\t\u0005M\u0013Q\f\b\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012bAA05\u00059\u0001/Y2lC\u001e,\u0017\u0002BA2\u0003K\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003?R\u0002#B\r\u0002jI\t\u0013bAA65\tA\u0001K]8ek\u000e$(\u0007C\u0004\u0002p\u0001!\t%!\u001d\u0002\tM$x\u000e\u001d\u000b\u0005\u0003g\nI\bE\u0003\u001a\u0003k\n9\"C\u0002\u0002xi\u0011aa\u00149uS>t\u0007bBA>\u0003[\u0002\ra`\u0001\bgV\u001c7-Z:t\u000f!\tyH\u0001E\u0001\r\u0005\u0005\u0015!E*peR\u001c\u0006.\u001e4gY\u0016<&/\u001b;feB\u00191)a!\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0004\u0002\u0006N!\u00111QAD!\rI\u0012\u0011R\u0005\u0004\u0003\u0017S\"AB!osJ+g\rC\u0004A\u0003\u0007#\t!a$\u0015\u0005\u0005\u0005\u0005\u0002CAJ\u0003\u0007#\t!!&\u0002+MDw.\u001e7e\u0005f\u0004\u0018m]:NKJ<WmU8siR)q0a&\u0002\"\"A\u0011\u0011TAI\u0001\u0004\tY*\u0001\u0003d_:4\u0007cA\u0013\u0002\u001e&\u0019\u0011q\u0014\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007bB%\u0002\u0012\u0002\u0007\u00111\u0015\u0019\t\u0003K\u000bI+a,\u00026BAQ\u0005TAT\u0003[\u000b\u0019\fE\u0002\u0014\u0003S#1\"a+\u0002\"\u0006\u0005\t\u0011!B\u0001/\t\u0019q\f\n\u001a\u0011\u0007M\ty\u000bB\u0006\u00022\u0006\u0005\u0016\u0011!A\u0001\u0006\u00039\"aA0%gA\u00191#!.\u0005\u0017\u0005]\u0016\u0011UA\u0001\u0002\u0003\u0015\ta\u0006\u0002\u0004?\u0012\"\u0004")
public class SortShuffleWriter<K, V, C>
extends ShuffleWriter<K, V>
implements Logging {
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private final int mapId;
    private final TaskContext context;
    private final ShuffleDependency<K, V, C> dep;
    private final BlockManager blockManager;
    private ExternalSorter<K, V, ?> sorter;
    private boolean stopping;
    private MapStatus mapStatus;
    private final ShuffleWriteMetrics writeMetrics;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean shouldBypassMergeSort(SparkConf sparkConf, ShuffleDependency<?, ?, ?> shuffleDependency) {
        return SortShuffleWriter$.MODULE$.shouldBypassMergeSort(sparkConf, shuffleDependency);
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private ShuffleDependency<K, V, C> dep() {
        return this.dep;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private ExternalSorter<K, V, ?> sorter() {
        return this.sorter;
    }

    private void sorter_$eq(ExternalSorter<K, V, ?> x$1) {
        this.sorter = x$1;
    }

    private boolean stopping() {
        return this.stopping;
    }

    private void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    private MapStatus mapStatus() {
        return this.mapStatus;
    }

    private void mapStatus_$eq(MapStatus x$1) {
        this.mapStatus = x$1;
    }

    private ShuffleWriteMetrics writeMetrics() {
        return this.writeMetrics;
    }

    @Override
    public void write(Iterator<Product2<K, V>> records) {
        ExternalSorter externalSorter;
        if (this.dep().mapSideCombine()) {
            Predef$.MODULE$.require(this.dep().aggregator().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Map-side combine without Aggregator specified!";
                }
            });
            externalSorter = new ExternalSorter<K, V, C>(this.context, this.dep().aggregator(), (Option<Partitioner>)new Some((Object)this.dep().partitioner()), this.dep().keyOrdering(), this.dep().serializer());
        } else {
            externalSorter = new ExternalSorter(this.context, None$.MODULE$, (Option<Partitioner>)new Some((Object)this.dep().partitioner()), None$.MODULE$, this.dep().serializer());
        }
        this.sorter_$eq(externalSorter);
        this.sorter().insertAll(records);
        File output = this.shuffleBlockResolver.getDataFile(this.dep().shuffleId(), this.mapId);
        File tmp = Utils$.MODULE$.tempFileWith(output);
        try {
            ShuffleBlockId blockId = new ShuffleBlockId(this.dep().shuffleId(), this.mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
            long[] partitionLengths = this.sorter().writePartitionedFile(blockId, tmp);
            this.shuffleBlockResolver.writeIndexFileAndCommit(this.dep().shuffleId(), this.mapId, partitionLengths, tmp);
            this.mapStatus_$eq(MapStatus$.MODULE$.apply(this.blockManager().shuffleServerId(), partitionLengths));
            if (tmp.exists() && !tmp.delete()) {
                this.logError((Function0<String>)new Serializable(this, tmp){
                    public static final long serialVersionUID = 0L;
                    private final File tmp$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while deleting temp file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1.getAbsolutePath()}));
                    }
                    {
                        this.tmp$1 = tmp$1;
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            if (tmp.exists() && !tmp.delete()) {
                this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */);
            }
            throw throwable;
        }
    }

    @Override
    public Option<MapStatus> stop(boolean success) {
        None$ none$;
        block9: {
            block7: {
                Option option;
                block8: {
                    block5: {
                        None$ none$2;
                        block6: {
                            try {
                                if (!this.stopping()) break block5;
                                none$2 = None$.MODULE$;
                                if (this.sorter() == null) break block6;
                            }
                            catch (Throwable throwable) {
                                if (this.sorter() != null) {
                                    long startTime = System.nanoTime();
                                    this.sorter().stop();
                                    this.context.taskMetrics().shuffleWriteMetrics().foreach((Function1)new Serializable(this, startTime){
                                        public static final long serialVersionUID = 0L;
                                        private final long startTime$1;

                                        public final void apply(ShuffleWriteMetrics x$1) {
                                            x$1.incShuffleWriteTime(System.nanoTime() - this.startTime$1);
                                        }
                                        {
                                            this.startTime$1 = startTime$1;
                                        }
                                    });
                                    this.sorter_$eq(null);
                                }
                                throw throwable;
                            }
                            long startTime = System.nanoTime();
                            this.sorter().stop();
                            this.context.taskMetrics().shuffleWriteMetrics().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                            this.sorter_$eq(null);
                        }
                        return none$2;
                    }
                    this.stopping_$eq(true);
                    if (!success) break block7;
                    option = Option$.MODULE$.apply((Object)this.mapStatus());
                    if (this.sorter() == null) break block8;
                    long startTime = System.nanoTime();
                    this.sorter().stop();
                    this.context.taskMetrics().shuffleWriteMetrics().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                    this.sorter_$eq(null);
                }
                return option;
            }
            this.shuffleBlockResolver.removeDataByMap(this.dep().shuffleId(), this.mapId);
            none$ = None$.MODULE$;
            if (this.sorter() == null) break block9;
            long startTime = System.nanoTime();
            this.sorter().stop();
            this.context.taskMetrics().shuffleWriteMetrics().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            this.sorter_$eq(null);
        }
        return none$;
    }

    public SortShuffleWriter(IndexShuffleBlockResolver shuffleBlockResolver, BaseShuffleHandle<K, V, C> handle, int mapId, TaskContext context) {
        this.shuffleBlockResolver = shuffleBlockResolver;
        this.mapId = mapId;
        this.context = context;
        Logging$class.$init$(this);
        this.dep = handle.dependency();
        this.blockManager = SparkEnv$.MODULE$.get().blockManager();
        this.sorter = null;
        this.stopping = false;
        this.mapStatus = null;
        this.writeMetrics = new ShuffleWriteMetrics();
        context.taskMetrics().shuffleWriteMetrics_$eq((Option<ShuffleWriteMetrics>)new Some((Object)this.writeMetrics()));
    }
}

