/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u0001\u0003\u0001\u0011Q!A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005!\u0011B\u0001\u000b\u0005\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0004%\t\u0001G\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0007\u0001)\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00039\u0011\t1A\u001d9d\u0013\tq2D\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\u0001\u0002!\u00111A\u0005\u0002\u0005\n!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0011!%\n\t\u0003\u0019\rJ!\u0001J\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bM}\t\t\u00111\u0001\u001a\u0003\rAH%\r\u0005\tQ\u0001\u0011\t\u0011)Q\u00053\u0005yAM]5wKJ,e\u000e\u001a9pS:$\b\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0011\u0019wN\u001c4\u0011\u0005Ia\u0013BA\u0017\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003!I7\u000f\u0012:jm\u0016\u0014\bC\u0001\u00072\u0013\t\u0011TBA\u0004C_>dW-\u00198\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111\u0004(\u000f\u001e\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000bY\u0019\u0004\u0019A\r\t\u000b)\u001a\u0004\u0019A\u0016\t\u000b=\u001a\u0004\u0019\u0001\u0019\t\u000fq\u0002!\u0019!C\u0001{\u00059A/[7f_V$X#\u0001 \u0011\u0005iy\u0014B\u0001!\u001c\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f\u001e\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002\u0011QLW.Z8vi\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000baB]3n_Z,W\t_3dkR|'\u000f\u0006\u0002#\r\")qi\u0011a\u0001\u0011\u00061Q\r_3d\u0013\u0012\u0004\"!\u0013'\u000f\u00051Q\u0015BA&\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-k\u0001\"\u0002)\u0001\t\u0003\t\u0016a\u0005:f[>4X-\u0012=fGV$xN]!ts:\u001cGC\u0001\u0012S\u0011\u00159u\n1\u0001I\u0011\u0015!\u0006\u0001\"\u0001V\u0003Q\u0011XmZ5ti\u0016\u0014(\t\\8dW6\u000bg.Y4feR!!EV.a\u0011\u001596\u000b1\u0001Y\u00039\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u0004\"aN-\n\u0005i\u0013!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\u00069N\u0003\r!X\u0001\u000b[\u0006DX*Z7TSj,\u0007C\u0001\u0007_\u0013\tyVB\u0001\u0003M_:<\u0007\"B1T\u0001\u0004I\u0012!D:mCZ,WI\u001c3q_&tG\u000fC\u0003d\u0001\u0011\u0005A-A\bva\u0012\fG/\u001a\"m_\u000e\\\u0017J\u001c4p)\u001d\u0001TMZ6qeRDQa\u00162A\u0002aCQa\u001a2A\u0002!\fqA\u00197pG.LE\r\u0005\u00028S&\u0011!N\u0001\u0002\b\u00052|7m[%e\u0011\u0015a'\r1\u0001n\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\t9d.\u0003\u0002p\u0005\ta1\u000b^8sC\u001e,G*\u001a<fY\")\u0011O\u0019a\u0001;\u00069Q.Z7TSj,\u0007\"B:c\u0001\u0004i\u0016\u0001\u00033jg.\u001c\u0016N_3\t\u000bU\u0014\u0007\u0019A/\u0002-\u0015DH/\u001a:oC2\u0014En\\2l'R|'/Z*ju\u0016DQa\u001e\u0001\u0005\u0002a\fAbZ3u\u0019>\u001c\u0017\r^5p]N$2!_A\u0006!\u0011Q\u0018Q\u0001-\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007f/\u00051AH]8pizJ\u0011AD\u0005\u0004\u0003\u0007i\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIAA\u0002TKFT1!a\u0001\u000e\u0011\u00159g\u000f1\u0001i\u0011\u00199\b\u0001\"\u0001\u0002\u0010Q!\u0011\u0011CA\f!\u0011Q\u00181C=\n\t\u0005U\u0011\u0011\u0002\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\u0002CA\r\u0003\u001b\u0001\r!a\u0007\u0002\u0011\tdwnY6JIN\u0004B\u0001DA\u000fQ&\u0019\u0011qD\u0007\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005A1m\u001c8uC&t7\u000fF\u00021\u0003OAaaZA\u0011\u0001\u0004A\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\tO\u0016$\b+Z3sgR\u0019\u00110a\f\t\r]\u000bI\u00031\u0001Y\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\tacZ3u\u000bb,7-\u001e;pe\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0005\u0003o\ti\u0004\u0005\u0003\r\u0003sI\u0012bAA\u001e\u001b\t1q\n\u001d;j_:Dq!a\u0010\u00022\u0001\u0007\u0001*\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Dq!a\u0011\u0001\t\u0003\t)%A\u0006sK6|g/\u001a\"m_\u000e\\Gc\u0001\u0012\u0002H!1q-!\u0011A\u0002!Dq!a\u0013\u0001\t\u0003\ti%A\u0005sK6|g/\u001a*eIR)!%a\u0014\u0002Z!A\u0011\u0011KA%\u0001\u0004\t\u0019&A\u0003sI\u0012LE\rE\u0002\r\u0003+J1!a\u0016\u000e\u0005\rIe\u000e\u001e\u0005\b\u00037\nI\u00051\u00011\u0003!\u0011Gn\\2lS:<\u0007bBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u000ee\u0016lwN^3TQV4g\r\\3\u0015\u000b\t\n\u0019'a\u001a\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003'\n\u0011b\u001d5vM\u001adW-\u00133\t\u000f\u0005m\u0013Q\fa\u0001a!9\u00111\u000e\u0001\u0005\u0002\u00055\u0014a\u0004:f[>4XM\u0011:pC\u0012\u001c\u0017m\u001d;\u0015\u000f\t\ny'a\u001d\u0002x!9\u0011\u0011OA5\u0001\u0004i\u0016a\u00032s_\u0006$7-Y:u\u0013\u0012Dq!!\u001e\u0002j\u0001\u0007\u0001'\u0001\tsK6|g/\u001a$s_6l\u0015m\u001d;fe\"9\u00111LA5\u0001\u0004\u0001\u0004bBA>\u0001\u0011\u0005\u0011QP\u0001\u0010O\u0016$X*Z7pef\u001cF/\u0019;vgV\u0011\u0011q\u0010\t\u0007\u0013\u0006\u0005\u0005,!\"\n\u0007\u0005\reJA\u0002NCB\u0004R\u0001DAD;vK1!!#\u000e\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015\u0001E4fiN#xN]1hKN#\u0018\r^;t+\t\t\t\nE\u0003\r\u0003;\t\u0019\nE\u00028\u0003+K1!a&\u0003\u00055\u0019Fo\u001c:bO\u0016\u001cF/\u0019;vg\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015AD4fi\ncwnY6Ti\u0006$Xo\u001d\u000b\u0007\u0003?\u000b9+!+\u0011\r%\u000b\t\tWAQ!\r9\u00141U\u0005\u0004\u0003K\u0013!a\u0003\"m_\u000e\\7\u000b^1ukNDaaZAM\u0001\u0004A\u0007\"CAV\u00033\u0003\n\u00111\u00011\u0003%\t7o[*mCZ,7\u000fC\u0004\u00020\u0002!\t!!-\u0002'\u001d,G/T1uG\"Lgn\u001a\"m_\u000e\\\u0017\nZ:\u0015\r\u0005M\u0016QWA`!\u0011Q\u0018Q\u00015\t\u0011\u0005]\u0016Q\u0016a\u0001\u0003s\u000baAZ5mi\u0016\u0014\b#\u0002\u0007\u0002<\"\u0004\u0014bAA_\u001b\tIa)\u001e8di&|g.\r\u0005\b\u0003W\u000bi\u000b1\u00011\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b\fq\u0002[1t\u0007\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d\u000b\u0004a\u0005\u001d\u0007bBA \u0003\u0003\u0004\r\u0001\u0013\u0005\b\u0003\u0017\u0004A\u0011AAg\u0003\u0011\u0019Ho\u001c9\u0015\u0003\tBq!!5\u0001\t\u0013\t\u0019.\u0001\u0003uK2dGc\u0001\u0012\u0002V\"A\u0011q[Ah\u0001\u0004\tI.A\u0004nKN\u001c\u0018mZ3\u0011\u00071\tY.C\u0002\u0002^6\u00111!\u00118z\u0011%\t\t\u000fAI\u0001\n\u0003\t\u0019/\u0001\rhKR\u0014En\\2l'R\fG/^:%I\u00164\u0017-\u001e7uII*\"!!:+\u0007A\n9o\u000b\u0002\u0002jB!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018!C;oG\",7m[3e\u0015\r\t\u00190D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA|\u0003[\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f!\tYP\u0001E\u0001\t\u0005u\u0018A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJ\u00042aNA\u0000\r\u001d\t!\u0001#\u0001\u0005\u0005\u0003\u00192!a@\f\u0011\u001d!\u0014q C\u0001\u0005\u000b!\"!!@\t\u0015\t%\u0011q b\u0001\n\u0003\u0011Y!\u0001\u000bE%&3VIU0F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0005\u001b\u0001BAa\u0004\u0003\u001a5\u0011!\u0011\u0003\u0006\u0005\u0005'\u0011)\"\u0001\u0003mC:<'B\u0001B\f\u0003\u0011Q\u0017M^1\n\u00075\u0013\t\u0002C\u0005\u0003\u001e\u0005}\b\u0015!\u0003\u0003\u000e\u0005)BIU%W\u000bJ{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u0003\u0003")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            private final String execId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Removed ").append((Object)this.execId$1).append((Object)" successfully in removeExecutor").toString();
            }
            {
                this.execId$1 = execId$1;
            }
        });
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            private final String execId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Removal of executor ").append((Object)this.execId$2).append((Object)" requested").toString();
            }
            {
                this.execId$2 = execId$2;
            }
        });
    }

    public void registerBlockManager(BlockManagerId blockManagerId, long maxMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Trying to register BlockManager";
            }
        });
        this.tell(new BlockManagerMessages.RegisterBlockManager(blockManagerId, maxMemSize, slaveEndpoint));
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registered BlockManager";
            }
        });
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize, long externalBlockStoreSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize, externalBlockStoreSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated info of block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, rddId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int rddId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeRdd$1 $outer;
                        private final Exception x2$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove RDD ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.rddId$1), this.x2$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, shuffleId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int shuffleId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeShuffle$1 $outer;
                        private final Exception x2$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove shuffle ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.shuffleId$1), this.x2$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$2 = x2$2;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shuffleId$1 = shuffleId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, broadcastId, removeFromMaster){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final long broadcastId$1;
            public final boolean removeFromMaster$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeBroadcast$1 $outer;
                        private final Exception x2$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove broadcast ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.broadcastId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with removeFromMaster = ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.removeFromMaster$1), this.x2$3.getMessage()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$3 = x2$3;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broadcastId$1 = broadcastId$1;
                this.removeFromMaster$1 = removeFromMaster$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        return (Map)this.driverEndpoint().askWithRetry(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        return (StorageStatus[])this.driverEndpoint().askWithRetry(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
            scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
            scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
            scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
            ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
            CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)scala.collection.Iterable$.MODULE$.canBuildFrom());
            Iterable blockStatus2 = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
            if (blockStatus2 == null) {
                throw new SparkException(new StringBuilder().append((Object)"BlockManager returned null for BlockStatus query: ").append((Object)blockId).toString());
            }
            return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus2, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<BlockManagerId, BlockStatus>> apply(Tuple2<BlockManagerId, Option<BlockStatus>> x0$1) {
                    Tuple2<BlockManagerId, Option<BlockStatus>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        Option status = (Option)tuple2._2();
                        Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1)new Serializable(this, blockManagerId){
                            public static final long serialVersionUID = 0L;
                            private final BlockManagerId blockManagerId$1;

                            public final Tuple2<BlockManagerId, BlockStatus> apply(BlockStatus s) {
                                return new Tuple2((Object)this.blockManagerId$1, (Object)s);
                            }
                            {
                                this.blockManagerId$1 = blockManagerId$1;
                            }
                        }));
                        return iterable;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter2, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter2, askSlaves);
        Future future = (Future)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public boolean hasCachedBlocks(String executorId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.HasCachedBlocks(executorId), ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        if (this.driverEndpoint() != null && this.isDriver) {
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "BlockManagerMaster stopped";
                }
            });
        }
    }

    private void tell(Object message) {
        if (BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(message, ClassTag$.MODULE$.Boolean()))) {
            return;
        }
        throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.isDriver = isDriver;
        Logging$class.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

