/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.spark-project.jetty.io.Buffer;
import org.spark-project.jetty.io.NetworkTrafficListener;
import org.spark-project.jetty.io.nio.SelectChannelEndPoint;
import org.spark-project.jetty.io.nio.SelectorManager;
import org.spark-project.jetty.util.log.Log;
import org.spark-project.jetty.util.log.Logger;

public class NetworkTrafficSelectChannelEndPoint
extends SelectChannelEndPoint {
    private static final Logger LOG = Log.getLogger(NetworkTrafficSelectChannelEndPoint.class);
    private final List<NetworkTrafficListener> listeners;

    public NetworkTrafficSelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, int maxIdleTime, List<NetworkTrafficListener> listeners) throws IOException {
        super(channel, selectSet, key, maxIdleTime);
        this.listeners = listeners;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        int read2 = super.fill(buffer);
        this.notifyIncoming(buffer, read2);
        return read2;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        int position = buffer.getIndex();
        int written = super.flush(buffer);
        this.notifyOutgoing(buffer, position, written);
        return written;
    }

    @Override
    protected int gatheringFlush(Buffer header, ByteBuffer bbuf0, Buffer buffer, ByteBuffer bbuf1) throws IOException {
        int headerPosition = header.getIndex();
        int headerLength = header.length();
        int bufferPosition = buffer.getIndex();
        int written = super.gatheringFlush(header, bbuf0, buffer, bbuf1);
        this.notifyOutgoing(header, headerPosition, written > headerLength ? headerLength : written);
        this.notifyOutgoing(buffer, bufferPosition, written > headerLength ? written - headerLength : 0);
        return written;
    }

    public void notifyOpened() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    listener.opened(this._socket);
                }
                catch (Exception x) {
                    LOG.warn(x);
                }
            }
        }
    }

    public void notifyIncoming(Buffer buffer, int read2) {
        if (this.listeners != null && !this.listeners.isEmpty() && read2 > 0) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    Buffer view = buffer.asReadOnlyBuffer();
                    listener.incoming(this._socket, view);
                }
                catch (Exception x) {
                    LOG.warn(x);
                }
            }
        }
    }

    public void notifyOutgoing(Buffer buffer, int position, int written) {
        if (this.listeners != null && !this.listeners.isEmpty() && written > 0) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    Buffer view = buffer.asReadOnlyBuffer();
                    view.setGetIndex(position);
                    view.setPutIndex(position + written);
                    listener.outgoing(this._socket, view);
                }
                catch (Exception x) {
                    LOG.warn(x);
                }
            }
        }
    }

    public void notifyClosed() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    listener.closed(this._socket);
                }
                catch (Exception x) {
                    LOG.warn(x);
                }
            }
        }
    }
}

