/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\t5\u0011!\u0003T8hSN$\u0018nY!hOJ,w-\u0019;pe*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qAc\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u0011y\u0001!\u0011!Q\u0001\n}\taBY2D_\u00164g-[2jK:$8\u000fE\u0002!G\u0015j\u0011!\t\u0006\u0003E\u0019\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005\u0011\n#!\u0003\"s_\u0006$7-Y:u!\t1\u0013&D\u0001(\u0015\tAC!\u0001\u0004mS:\fGnZ\u0005\u0003U\u001d\u0012aAV3di>\u0014\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001b\t\u001cg)Z1ukJ,7o\u0015;e!\r\u00013E\f\t\u0004\u001f=\n\u0014B\u0001\u0019\u0011\u0005\u0015\t%O]1z!\ty!'\u0003\u00024!\t1Ai\\;cY\u0016D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000b]Vl7\t\\1tg\u0016\u001c\bCA\b8\u0013\tA\u0004CA\u0002J]RD\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaO\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003\u001fqJ!!\u0010\t\u0003\u000f\t{w\u000e\\3b]\"Aq\b\u0001B\u0001B\u0003%1(A\u0006nk2$\u0018N\\8nS\u0006d\u0007\"B!\u0001\t\u0003\u0011\u0015A\u0002\u001fj]&$h\b\u0006\u0004D\u000b\u001a;\u0005*\u0013\t\u0003\t\u0002i\u0011A\u0001\u0005\u0006=\u0001\u0003\ra\b\u0005\u0006Y\u0001\u0003\r!\f\u0005\u0006k\u0001\u0003\rA\u000e\u0005\u0006u\u0001\u0003\ra\u000f\u0005\u0006\u007f\u0001\u0003\ra\u000f\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003YBaA\u0014\u0001!\u0002\u00131\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003b\u0002)\u0001\u0005\u0004%I\u0001T\u0001\u0019]Vlg)Z1ukJ,7\u000f\u00157vg&sG/\u001a:dKB$\bB\u0002*\u0001A\u0003%a'A\rok64U-\u0019;ve\u0016\u001c\b\u000b\\;t\u0013:$XM]2faR\u0004\u0003b\u0002+\u0001\u0005\u0004%I\u0001T\u0001\u0010G>,gMZ5dS\u0016tGoU5{K\"1a\u000b\u0001Q\u0001\nY\n\u0001cY8fM\u001aL7-[3oiNK'0\u001a\u0011\t\u000fa\u0003!\u0019!C\u0005\u0019\u0006\u0011b.^7D_\u00164g-[2jK:$8+\u001a;t\u0011\u0019Q\u0006\u0001)A\u0005m\u0005\u0019b.^7D_\u00164g-[2jK:$8+\u001a;tA!9A\f\u0001a\u0001\n\u0013i\u0016!C<fS\u001eDGoU;n+\u0005\t\u0004bB0\u0001\u0001\u0004%I\u0001Y\u0001\u000eo\u0016Lw\r\u001b;Tk6|F%Z9\u0015\u0005\u0005$\u0007CA\bc\u0013\t\u0019\u0007C\u0001\u0003V]&$\bbB3_\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0004BB4\u0001A\u0003&\u0011'\u0001\u0006xK&<\u0007\u000e^*v[\u0002Bq!\u001b\u0001A\u0002\u0013%Q,A\u0004m_N\u001c8+^7\t\u000f-\u0004\u0001\u0019!C\u0005Y\u0006YAn\\:t'Vlw\fJ3r)\t\tW\u000eC\u0004fU\u0006\u0005\t\u0019A\u0019\t\r=\u0004\u0001\u0015)\u00032\u0003!awn]:Tk6\u0004\u0003bB9\u0001\u0005\u0004%IA]\u0001\u0011OJ\fG-[3oiN+X.\u0011:sCf,\u0012A\f\u0005\u0007i\u0002\u0001\u000b\u0011\u0002\u0018\u0002#\u001d\u0014\u0018\rZ5f]R\u001cV/\\!se\u0006L\b\u0005C\u0003w\u0001\u0011%q/A\ncS:\f'/_+qI\u0006$X-\u00138QY\u0006\u001cW\r\u0006\u0003bqjd\b\"B=v\u0001\u0004)\u0013\u0001\u00034fCR,(/Z:\t\u000bm,\b\u0019A\u0019\u0002\r],\u0017n\u001a5u\u0011\u0015iX\u000f1\u00012\u0003\u0015a\u0017MY3m\u0011\u0019y\b\u0001\"\u0003\u0002\u0002\u0005AR.\u001e7uS:|W.[1m+B$\u0017\r^3J]Bc\u0017mY3\u0015\u000f\u0005\f\u0019!!\u0002\u0002\b!)\u0011P a\u0001K!)1P a\u0001c!)QP a\u0001c!9\u00111\u0002\u0001\u0005\u0002\u00055\u0011aA1eIR!\u0011qBA\t\u001b\u0005\u0001\u0001\u0002CA\n\u0003\u0013\u0001\r!!\u0006\u0002\u0011%t7\u000f^1oG\u0016\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037!\u0011a\u00024fCR,(/Z\u0005\u0005\u0003?\tIB\u0001\u0005J]N$\u0018M\\2f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tQ!\\3sO\u0016$B!a\u0004\u0002(!9\u0011\u0011FA\u0011\u0001\u0004\u0019\u0015!B8uQ\u0016\u0014\bBBA\u0017\u0001\u0011\u0005Q,\u0001\u0003m_N\u001c\bbBA\u0019\u0001\u0011\u0005\u00111G\u0001\tOJ\fG-[3oiV\u0011\u0011Q\u0007\t\u0004M\u0005]\u0012bAA\u001dO\t1Q*\u0019;sSb\u0004")
public class LogisticAggregator
implements Serializable,
Logging {
    private final Broadcast<Vector> bcCoefficients;
    private final Broadcast<double[]> bcFeaturesStd;
    public final int org$apache$spark$ml$classification$LogisticAggregator$$numClasses;
    private final boolean fitIntercept;
    private final boolean multinomial;
    private final int org$apache$spark$ml$classification$LogisticAggregator$$numFeatures;
    private final int org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept;
    private final int org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize;
    private final int numCoefficientSets;
    private double org$apache$spark$ml$classification$LogisticAggregator$$weightSum;
    private double lossSum;
    private final double[] gradientSumArray;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() {
        return this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures;
    }

    public int org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept() {
        return this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept;
    }

    public int org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize() {
        return this.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize;
    }

    private int numCoefficientSets() {
        return this.numCoefficientSets;
    }

    public double org$apache$spark$ml$classification$LogisticAggregator$$weightSum() {
        return this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum;
    }

    private void org$apache$spark$ml$classification$LogisticAggregator$$weightSum_$eq(double x$1) {
        this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray() {
        return this.gradientSumArray;
    }

    private void binaryUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        Vector localCoefficients = (Vector)this.bcCoefficients.value();
        double[] localGradientArray = this.gradientSumArray();
        DoubleRef sum = DoubleRef.create((double)0.0);
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, sum){
            public static final long serialVersionUID = 0L;
            private final double[] localFeaturesStd$1;
            private final Vector localCoefficients$1;
            private final DoubleRef sum$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    this.sum$1.elem += this.localCoefficients$1.apply(index2) * value / this.localFeaturesStd$1[index2];
                }
            }
            {
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.localCoefficients$1 = localCoefficients$1;
                this.sum$1 = sum$1;
            }
        });
        if (this.fitIntercept) {
            sum.elem += localCoefficients.apply(this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept() - 1);
        }
        double margin = -sum.elem;
        double multiplier = weight * (1.0 / (1.0 + package$.MODULE$.exp(margin)) - label);
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localGradientArray, multiplier){
            public static final long serialVersionUID = 0L;
            private final double[] localFeaturesStd$1;
            private final double[] localGradientArray$1;
            private final double multiplier$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    this.localGradientArray$1[index2] = this.localGradientArray$1[index2] + this.multiplier$1 * value / this.localFeaturesStd$1[index2];
                }
            }
            {
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.localGradientArray$1 = localGradientArray$1;
                this.multiplier$1 = multiplier$1;
            }
        });
        if (this.fitIntercept) {
            int n = this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept() - 1;
            localGradientArray[n] = localGradientArray[n] + multiplier;
        }
        if (label > 0.0) {
            this.lossSum_$eq(this.lossSum() + weight * MLUtils$.MODULE$.log1pExp(margin));
        } else {
            this.lossSum_$eq(this.lossSum() + weight * (MLUtils$.MODULE$.log1pExp(margin) - margin));
        }
    }

    private void multinomialUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        Vector localCoefficients = (Vector)this.bcCoefficients.value();
        double[] localGradientArray = this.gradientSumArray();
        double marginOfLabel = 0.0;
        double maxMargin = Double.NEGATIVE_INFINITY;
        double[] margins = new double[this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses];
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, margins){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;
            private final double[] localFeaturesStd$2;
            private final Vector localCoefficients$2;
            private final double[] margins$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                double stdValue = value / this.localFeaturesStd$2[index2];
                for (int j = 0; j < this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses; ++j) {
                    int n = j;
                    this.margins$1[n] = this.margins$1[n] + this.localCoefficients$2.apply(index2 * this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses + j) * stdValue;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.localFeaturesStd$2 = localFeaturesStd$2;
                this.localCoefficients$2 = localCoefficients$2;
                this.margins$1 = margins$1;
            }
        });
        for (int i = 0; i < this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses; ++i) {
            if (this.fitIntercept) {
                int n = i;
                margins[n] = margins[n] + localCoefficients.apply(this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses * this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() + i);
            }
            if (i == (int)label) {
                marginOfLabel = margins[i];
            }
            if (!(margins[i] > maxMargin)) continue;
            maxMargin = margins[i];
        }
        double[] multipliers = new double[this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses];
        double temp = 0.0;
        for (int i = 0; i < this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses; ++i) {
            if (maxMargin > 0.0) {
                int n = i;
                margins[n] = margins[n] - maxMargin;
            }
            double exp = package$.MODULE$.exp(margins[i]);
            temp += exp;
            multipliers[i] = exp;
        }
        double sum = temp;
        Predef$.MODULE$.doubleArrayOps(margins).indices().foreach$mVc$sp((Function1)new Serializable(this, label, multipliers, sum){
            public static final long serialVersionUID = 0L;
            private final double label$1;
            private final double[] multipliers$1;
            private final double sum$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.multipliers$1[i] = this.multipliers$1[i] / this.sum$2 - (this.label$1 == (double)i ? 1.0 : 0.0);
            }
            {
                this.label$1 = label$1;
                this.multipliers$1 = multipliers$1;
                this.sum$2 = sum$2;
            }
        });
        features.foreachActive((Function2)new Serializable(this, weight, localFeaturesStd, localGradientArray, multipliers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;
            private final double weight$2;
            private final double[] localFeaturesStd$2;
            private final double[] localGradientArray$2;
            private final double[] multipliers$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$2[index2] != 0.0 && value != 0.0) {
                    double stdValue = value / this.localFeaturesStd$2[index2];
                    for (int j = 0; j < this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses; ++j) {
                        int n = index2 * this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses + j;
                        this.localGradientArray$2[n] = this.localGradientArray$2[n] + this.weight$2 * this.multipliers$1[j] * stdValue;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.weight$2 = weight$2;
                this.localFeaturesStd$2 = localFeaturesStd$2;
                this.localGradientArray$2 = localGradientArray$2;
                this.multipliers$1 = multipliers$1;
            }
        });
        if (this.fitIntercept) {
            for (int i = 0; i < this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses; ++i) {
                int n = this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() * this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses + i;
                localGradientArray[n] = localGradientArray[n] + weight * multipliers[i];
            }
        }
        double loss2 = maxMargin > 0.0 ? package$.MODULE$.log(sum) - marginOfLabel + maxMargin : package$.MODULE$.log(sum) - marginOfLabel;
        this.lossSum_$eq(this.lossSum() + weight * loss2);
    }

    public LogisticAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() == features.size(), (Function0)new Serializable(this, features){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;
                private final Vector features$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when adding new instance."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures()), BoxesRunTime.boxToInteger((int)this.features$1.size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.features$1 = features$1;
                }
            });
            Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
                public static final long serialVersionUID = 0L;
                private final double weight$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instance weight, ", " has to be >= 0.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$3)}));
                }
                {
                    this.weight$3 = weight$3;
                }
            });
            if (weight == 0.0) {
                return this;
            }
            if (this.multinomial) {
                this.multinomialUpdateInPlace(features, weight, label);
            } else {
                this.binaryUpdateInPlace(features, weight, label);
            }
            this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum_$eq(this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum() + weight);
            LogisticAggregator logisticAggregator = this;
            return logisticAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public LogisticAggregator merge(LogisticAggregator other) {
        Predef$.MODULE$.require(this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() == other.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;
            private final LogisticAggregator other$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when merging with another "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeastSquaresAggregator. Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures()), BoxesRunTime.boxToInteger((int)this.other$1.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        if (other.org$apache$spark$ml$classification$LogisticAggregator$$weightSum() != 0.0) {
            this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum_$eq(this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum() + other.org$apache$spark$ml$classification$LogisticAggregator$$weightSum());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            double[] localThisGradientSumArray = this.gradientSumArray();
            double[] localOtherGradientSumArray = other.gradientSumArray();
            int len = localThisGradientSumArray.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                localThisGradientSumArray[n] = localThisGradientSumArray[n] + localOtherGradientSumArray[i];
            }
        }
        return this;
    }

    public double loss() {
        Predef$.MODULE$.require(this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The effective number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$weightSum())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.lossSum() / this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum();
    }

    public Matrix gradient() {
        Predef$.MODULE$.require(this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The effective number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$weightSum())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Vector result = Vectors$.MODULE$.dense((double[])this.gradientSumArray().clone());
        BLAS$.MODULE$.scal(1.0 / this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum(), result);
        return new DenseMatrix(this.numCoefficientSets(), this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept(), result.toArray());
    }

    public LogisticAggregator(Broadcast<Vector> bcCoefficients, Broadcast<double[]> bcFeaturesStd, int numClasses, boolean fitIntercept, boolean multinomial) {
        this.bcCoefficients = bcCoefficients;
        this.bcFeaturesStd = bcFeaturesStd;
        this.org$apache$spark$ml$classification$LogisticAggregator$$numClasses = numClasses;
        this.fitIntercept = fitIntercept;
        this.multinomial = multinomial;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept = fitIntercept ? this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures() + 1 : this.org$apache$spark$ml$classification$LogisticAggregator$$numFeatures();
        this.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize = ((Vector)bcCoefficients.value()).size();
        int n = this.numCoefficientSets = multinomial ? numClasses : 1;
        if (multinomial) {
            Predef$.MODULE$.require(numClasses == this.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize() / this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients should be ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses * this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept())), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize() == this.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numFeaturesPlusIntercept())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Binary logistic aggregator requires numClasses "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in {1, 2} but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$LogisticAggregator$$numClasses)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$ml$classification$LogisticAggregator$$weightSum = 0.0;
        this.lossSum = 0.0;
        this.gradientSumArray = (double[])Array$.MODULE$.ofDim(this.org$apache$spark$ml$classification$LogisticAggregator$$coefficientSize(), ClassTag$.MODULE$.Double());
        if (multinomial && numClasses <= 2) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multinomial logistic regression for binary classification yields separate "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients for positive and negative classes. When no regularization is applied, the"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result will be effectively the same as binary logistic regression. When regularization"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is applied, multinomial loss will produce a result different from binary loss."})).s((Seq)Nil$.MODULE$)).toString();
                }
            });
        }
    }
}

