/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.KMeansWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;

public final class KMeansWrapper$
implements MLReadable<KMeansWrapper> {
    public static final KMeansWrapper$ MODULE$;

    static {
        new KMeansWrapper$();
    }

    public KMeansWrapper fit(Dataset<Row> data, String formula, int k, int maxIter, String initMode) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$2) {
                return (String)x$2.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        KMeans kMeans2 = new KMeans().setK(k).setMaxIter(maxIter).setInitMode(initMode).setFeaturesCol(rFormula.getFeaturesCol());
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, kMeans2})).fit((Dataset)data);
        KMeansModel kMeansModel = (KMeansModel)((PipelineModel)pipeline).stages()[1];
        long[] size = kMeansModel.summary().clusterSizes();
        return new KMeansWrapper((PipelineModel)pipeline, features, size, this.$lessinit$greater$default$4());
    }

    @Override
    public MLReader<KMeansWrapper> read() {
        return new KMeansWrapper.KMeansWrapperReader();
    }

    @Override
    public KMeansWrapper load(String path) {
        return (KMeansWrapper)MLReadable$class.load(this, path);
    }

    private boolean $lessinit$greater$default$4() {
        return false;
    }

    private KMeansWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

