/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Random;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.BisectingKMeans$$anonfun$org$apache$spark$mllib$clustering$BisectingKMeans$;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class BisectingKMeans$
implements Serializable {
    public static final BisectingKMeans$ MODULE$;
    private final long org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX;
    private final long MAX_DIVISIBLE_CLUSTER_INDEX;
    private final double org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT;

    static {
        new BisectingKMeans$();
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX() {
        return this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX;
    }

    private long MAX_DIVISIBLE_CLUSTER_INDEX() {
        return this.MAX_DIVISIBLE_CLUSTER_INDEX;
    }

    public double org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT() {
        return this.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(long index2) {
        Predef$.MODULE$.require(index2 <= this.MAX_DIVISIBLE_CLUSTER_INDEX(), (Function0)new Serializable(index2){
            public static final long serialVersionUID = 0L;
            private final long index$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Child index out of bound: 2 * ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.index$1)}));
            }
            {
                this.index$1 = index$1;
            }
        });
        return 2L * index2;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(long index2) {
        Predef$.MODULE$.require(index2 <= this.MAX_DIVISIBLE_CLUSTER_INDEX(), (Function0)new Serializable(index2){
            public static final long serialVersionUID = 0L;
            private final long index$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Child index out of bound: 2 * ", " + 1."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.index$2)}));
            }
            {
                this.index$2 = index$2;
            }
        });
        return 2L * index2 + 1L;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(long index2) {
        return index2 / 2L;
    }

    public Map<Object, BisectingKMeans.ClusterSummary> org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(int d, RDD<Tuple2<Object, VectorWithNorm>> assignments) {
        return Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(assignments, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).aggregateByKey((Object)new BisectingKMeans.ClusterSummaryAggregator(d), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BisectingKMeans.ClusterSummaryAggregator apply(BisectingKMeans.ClusterSummaryAggregator agg, VectorWithNorm v) {
                return agg.add(v);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BisectingKMeans.ClusterSummaryAggregator apply(BisectingKMeans.ClusterSummaryAggregator agg1, BisectingKMeans.ClusterSummaryAggregator agg2) {
                return agg1.merge(agg2);
            }
        }, ClassTag$.MODULE$.apply(BisectingKMeans.ClusterSummaryAggregator.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(BisectingKMeans.ClusterSummaryAggregator.class), (Ordering)Ordering.Long$.MODULE$).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BisectingKMeans.ClusterSummary apply(BisectingKMeans.ClusterSummaryAggregator x$4) {
                return x$4.summary();
            }
        }).collect()).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(VectorWithNorm center, Random random) {
        int d = center.vector().size();
        double norm2 = center.norm();
        double level = 1.0E-4 * norm2;
        Vector noise = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(d, (Function0)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.random$2.nextDouble();
            }
            {
                this.random$2 = random$2;
            }
        }, ClassTag$.MODULE$.Double()));
        Vector left = center.vector().copy();
        BLAS$.MODULE$.axpy(-level, noise, left);
        Vector right = center.vector().copy();
        BLAS$.MODULE$.axpy(level, noise, right);
        return new Tuple2((Object)new VectorWithNorm(left), (Object)new VectorWithNorm(right));
    }

    public RDD<Tuple2<Object, VectorWithNorm>> org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments(RDD<Tuple2<Object, VectorWithNorm>> assignments, Set<Object> divisibleIndices, Map<Object, VectorWithNorm> newClusterCenters) {
        return assignments.map((Function1)new Serializable(divisibleIndices, newClusterCenters){
            public static final long serialVersionUID = 0L;
            private final Set divisibleIndices$2;
            public final Map newClusterCenters$2;

            public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x0$6) {
                Tuple2<Object, VectorWithNorm> tuple2 = x0$6;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    long index2 = tuple2._1$mcJ$sp();
                    VectorWithNorm v = (VectorWithNorm)tuple2._2();
                    if (this.divisibleIndices$2.contains((Object)BoxesRunTime.boxToLong((long)index2))) {
                        Seq children = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index2), BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index2)}));
                        long selected = BoxesRunTime.unboxToLong((Object)children.minBy((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments$1 $outer;
                            private final VectorWithNorm v$1;

                            public final double apply(long child) {
                                return this.apply$mcDJ$sp(child);
                            }

                            public double apply$mcDJ$sp(long child) {
                                return KMeans$.MODULE$.fastSquaredDistance((VectorWithNorm)this.$outer.newClusterCenters$2.apply((Object)BoxesRunTime.boxToLong((long)child)), this.v$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        }, (Ordering)Ordering.Double$.MODULE$));
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)selected), (Object)v);
                    } else {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)index2), (Object)v);
                    }
                    Tuple2 tuple23 = tuple22;
                    return tuple23;
                }
                throw new MatchError(tuple2);
            }
            {
                this.divisibleIndices$2 = divisibleIndices$2;
                this.newClusterCenters$2 = newClusterCenters$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public ClusteringTreeNode org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree(Map<Object, BisectingKMeans.ClusterSummary> clusters) {
        IntRef leafIndex = IntRef.create((int)0);
        IntRef internalIndex = IntRef.create((int)-1);
        return this.buildSubTree$1(this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX(), clusters, leafIndex, internalIndex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final ClusteringTreeNode buildSubTree$1(long rawIndex, Map clusters$1, IntRef leafIndex$1, IntRef internalIndex$1) {
        ClusteringTreeNode clusteringTreeNode;
        BisectingKMeans.ClusterSummary cluster = (BisectingKMeans.ClusterSummary)clusters$1.apply((Object)BoxesRunTime.boxToLong((long)rawIndex));
        long size = cluster.size();
        VectorWithNorm center = cluster.center();
        double cost = cluster.cost();
        boolean isInternal = clusters$1.contains((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(rawIndex)));
        if (isInternal) {
            int index2 = internalIndex$1.elem--;
            long leftIndex = this.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(rawIndex);
            long rightIndex = this.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(rawIndex);
            double height = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{leftIndex, rightIndex}))).map((Function1)new Serializable(clusters$1, center){
                public static final long serialVersionUID = 0L;
                private final Map clusters$1;
                private final VectorWithNorm center$1;

                public final double apply(long childIndex) {
                    return this.apply$mcDJ$sp(childIndex);
                }

                public double apply$mcDJ$sp(long childIndex) {
                    return KMeans$.MODULE$.fastSquaredDistance(this.center$1, ((BisectingKMeans.ClusterSummary)this.clusters$1.apply((Object)BoxesRunTime.boxToLong((long)childIndex))).center());
                }
                {
                    this.clusters$1 = clusters$1;
                    this.center$1 = center$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
            ClusteringTreeNode left = this.buildSubTree$1(leftIndex, clusters$1, leafIndex$1, internalIndex$1);
            ClusteringTreeNode right = this.buildSubTree$1(rightIndex, clusters$1, leafIndex$1, internalIndex$1);
            clusteringTreeNode = new ClusteringTreeNode(index2, size, center, cost, height, (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{left, right}));
        } else {
            int index3 = leafIndex$1.elem++;
            double height = 0.0;
            clusteringTreeNode = new ClusteringTreeNode(index3, size, center, cost, height, (ClusteringTreeNode[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
        }
        return clusteringTreeNode;
    }

    private BisectingKMeans$() {
        MODULE$ = this;
        this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX = 1L;
        this.MAX_DIVISIBLE_CLUSTER_INDEX = 0x3FFFFFFFFFFFFFFFL;
        this.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT = package$.MODULE$.log10(9.223372036854776E18) / package$.MODULE$.log10(2.0);
    }
}

