/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011\u0011CU3he\u0016\u001c8/[8o\u001b\u0016$(/[2t\u0015\t\u0019A!\u0001\u0006fm\u0006dW/\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\r\u0017\u0005\u001daunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u001aaJ,G-[2uS>t\u0017I\u001c3PEN,'O^1uS>t7\u000fE\u0002\u001eA\tj\u0011A\b\u0006\u0003?\u0019\t1A\u001d3e\u0013\t\tcDA\u0002S\t\u0012\u0003BaD\u0012&K%\u0011A\u0005\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005=1\u0013BA\u0014\u0011\u0005\u0019!u.\u001e2mK\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0007uQJ|Wo\u001a5Pe&<\u0017N\u001c\t\u0003\u001f-J!\u0001\f\t\u0003\u000f\t{w\u000e\\3b]\")a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"2\u0001\r\u001a4!\t\t\u0004!D\u0001\u0003\u0011\u0015YR\u00061\u0001\u001d\u0011\u0015IS\u00061\u0001+Q\riSg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q\u0019\t!\"\u00198o_R\fG/[8o\u0013\tQtGA\u0003TS:\u001cW-I\u0001=\u0003\u0015\u0011d\u0006\r\u00181\u0011\u0015q\u0003\u0001\"\u0001?)\t\u0001t\bC\u0003\u001c{\u0001\u0007A\u0004K\u0002>k\u0005\u000b\u0013AQ\u0001\u0006c9\u0012d\u0006\r\u0005\u0007]\u0001!\t\u0001\u0002#\u0015\u0005A*\u0005\"B\u000eD\u0001\u00041\u0005CA$X\u001d\tAEK\u0004\u0002J%:\u0011!*\u0015\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!A\u0014\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002T\r\u0005\u00191/\u001d7\n\u0005U3\u0016a\u00029bG.\fw-\u001a\u0006\u0003'\u001aI!\u0001W-\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA+W\u0011!Y\u0006\u0001#b\u0001\n\u0013a\u0016aB:v[6\f'/_\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rB\u0001\u0005gR\fG/\u0003\u0002c?\nqR*\u001e7uSZ\f'/[1uKN#\u0018\r^5ti&\u001c\u0017\r\\*v[6\f'/\u001f\u0005\tI\u0002A\t\u0011)Q\u0005;\u0006A1/^7nCJL\b\u0005\u0003\u0005g\u0001!\u0015\r\u0011\"\u0003h\u0003\r\u00196+_\u000b\u0002K!A\u0011\u000e\u0001E\u0001B\u0003&Q%\u0001\u0003T'f\u0004\u0003\u0002C6\u0001\u0011\u000b\u0007I\u0011B4\u0002\u000bM\u001bVM\u001d:\t\u00115\u0004\u0001\u0012!Q!\n\u0015\naaU*feJ\u0004\u0003\u0002C8\u0001\u0011\u000b\u0007I\u0011B4\u0002\u000bM\u001bFo\u001c;\t\u0011E\u0004\u0001\u0012!Q!\n\u0015\naaU*u_R\u0004\u0003\u0002C:\u0001\u0011\u000b\u0007I\u0011B4\u0002\u000bM\u001b&/Z4\t\u0011U\u0004\u0001\u0012!Q!\n\u0015\naaU*sK\u001e\u0004\u0003\"B<\u0001\t\u00039\u0017!E3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dK\"\u001aa/N!\t\u000bi\u0004A\u0011A4\u0002#5,\u0017M\\!cg>dW\u000f^3FeJ|'\u000fK\u0002zk\u0005CQ! \u0001\u0005\u0002\u001d\f\u0001#\\3b]N\u000bX/\u0019:fI\u0016\u0013(o\u001c:)\u0007q,\u0014\t\u0003\u0004\u0002\u0002\u0001!\taZ\u0001\u0015e>|G/T3b]N\u000bX/\u0019:fI\u0016\u0013(o\u001c:)\u0007},\u0014\t\u0003\u0004\u0002\b\u0001!\taZ\u0001\u0003eJBC!!\u00026\u0003\"\u001a\u0001!N!")
public class RegressionMetrics
implements Logging {
    private final RDD<Tuple2<Object, Object>> predictionAndObservations;
    private final boolean throughOrigin;
    private MultivariateStatisticalSummary summary;
    private double SSy;
    private double SSerr;
    private double SStot;
    private double SSreg;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    private MultivariateStatisticalSummary summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                MultivariateStatisticalSummary summary2 = (MultivariateStatisticalSummary)this.predictionAndObservations.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double prediction = tuple2._1$mcD$sp();
                            double observation = tuple2._2$mcD$sp();
                            Vector vector = Vectors$.MODULE$.dense(observation, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{observation - prediction}));
                            return vector;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary2, Vector v) {
                        return summary2.add(v);
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                        return sum1.merge(sum2);
                    }
                }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
                this.summary = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.summary;
        }
    }

    private double SSy$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.SSy = package$.MODULE$.pow(this.summary().normL2().apply(0), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.SSy;
        }
    }

    private double SSerr$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SSerr = package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.SSerr;
        }
    }

    private double SStot$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SStot = this.summary().variance().apply(0) * (double)(this.summary().count() - 1L);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.SStot;
        }
    }

    private double SSreg$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                double yMean = this.summary().mean().apply(0);
                this.SSreg = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndObservations.map((Function1)new Serializable(this, yMean){
                    public static final long serialVersionUID = 0L;
                    private final double yMean$1;

                    public final double apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            double prediction = tuple2._1$mcD$sp();
                            double d = package$.MODULE$.pow(prediction - this.yMean$1, 2.0);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.yMean$1 = yMean$1;
                    }
                }, ClassTag$.MODULE$.Double())).sum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.SSreg;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private MultivariateStatisticalSummary summary() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.summary$lzycompute() : this.summary;
    }

    private double SSy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.SSy$lzycompute() : this.SSy;
    }

    private double SSerr() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SSerr$lzycompute() : this.SSerr;
    }

    private double SStot() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SStot$lzycompute() : this.SStot;
    }

    private double SSreg() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.SSreg$lzycompute() : this.SSreg;
    }

    public double explainedVariance() {
        return this.SSreg() / (double)this.summary().count();
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / (double)this.summary().count();
    }

    public double meanSquaredError() {
        return this.SSerr() / (double)this.summary().count();
    }

    public double rootMeanSquaredError() {
        return package$.MODULE$.sqrt(this.meanSquaredError());
    }

    public double r2() {
        return this.throughOrigin ? 1.0 - this.SSerr() / this.SSy() : 1.0 - this.SSerr() / this.SStot();
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations, boolean throughOrigin) {
        this.predictionAndObservations = predictionAndObservations;
        this.throughOrigin = throughOrigin;
        Logging.class.$init$((Logging)this);
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations) {
        this(predictionAndObservations, false);
    }

    public RegressionMetrics(Dataset<Row> predictionAndObservations) {
        this((RDD<Tuple2<Object, Object>>)predictionAndObservations.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

