/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import com.twitter.chill.MeatLocker;
import com.twitter.chill.MeatLocker$;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.stat.test.StreamingTestMethod;
import org.apache.spark.mllib.stat.test.StreamingTestMethod$class;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.StatCounter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ClassTag$;

public final class WelchTTest$
implements StreamingTestMethod,
Logging {
    public static final WelchTTest$ MODULE$;
    private final String methodName;
    private final String nullHypothesis;
    private final MeatLocker<TTest> tTester;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new WelchTTest$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StatisticalSummaryValues toApacheCommonsStats(StatCounter summaryStats) {
        return StreamingTestMethod$class.toApacheCommonsStats(this, summaryStats);
    }

    @Override
    public final String methodName() {
        return "Welch's 2-sample t-test";
    }

    @Override
    public final String nullHypothesis() {
        return "Both groups have same mean";
    }

    private final MeatLocker<TTest> tTester() {
        return this.tTester;
    }

    @Override
    public DStream<StreamingTestResult> doTest(DStream<Tuple2<StatCounter, StatCounter>> data) {
        return data.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StreamingTestResult apply(StatCounter statsA, StatCounter statsB) {
                return WelchTTest$.MODULE$.org$apache$spark$mllib$stat$test$WelchTTest$$test(statsA, statsB);
            }
        }.tupled(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
    }

    public StreamingTestResult org$apache$spark$mllib$stat$test$WelchTTest$$test(StatCounter statsA, StatCounter statsB) {
        return new StreamingTestResult(((TTest)this.tTester().get()).tTest((StatisticalSummary)this.toApacheCommonsStats(statsA), (StatisticalSummary)this.toApacheCommonsStats(statsB)), this.welchDF$1(this.toApacheCommonsStats(statsA), this.toApacheCommonsStats(statsB)), ((TTest)this.tTester().get()).t((StatisticalSummary)this.toApacheCommonsStats(statsA), (StatisticalSummary)this.toApacheCommonsStats(statsB)), "Welch's 2-sample t-test", "Both groups have same mean");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final double welchDF$1(StatisticalSummaryValues sample1, StatisticalSummaryValues sample2) {
        double s1 = sample1.getVariance();
        long n1 = sample1.getN();
        double s2 = sample2.getVariance();
        long n2 = sample2.getN();
        double a = package$.MODULE$.pow(s1, 2.0) / (double)n1;
        double b = package$.MODULE$.pow(s2, 2.0) / (double)n2;
        return package$.MODULE$.pow(a + b, 2.0) / (package$.MODULE$.pow(a, 2.0) / (double)(n1 - 1L) + package$.MODULE$.pow(b, 2.0) / (double)(n2 - 1L));
    }

    private WelchTTest$() {
        MODULE$ = this;
        StreamingTestMethod$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.tTester = MeatLocker$.MODULE$.apply((Object)new TTest());
    }
}

