/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.spark-project.guava.base.Objects;

public final class StreamFailure
extends AbstractMessage
implements ResponseMessage {
    public final String streamId;
    public final String error;

    public StreamFailure(String streamId, String error) {
        this.streamId = streamId;
        this.error = error;
    }

    @Override
    public Message.Type type() {
        return Message.Type.StreamFailure;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.streamId) + Encoders.Strings.encodedLength(this.error);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.streamId);
        Encoders.Strings.encode(buf, this.error);
    }

    public static StreamFailure decode(ByteBuf buf) {
        String streamId = Encoders.Strings.decode(buf);
        String error = Encoders.Strings.decode(buf);
        return new StreamFailure(streamId, error);
    }

    public int hashCode() {
        return Objects.hashCode(this.streamId, this.error);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamFailure) {
            StreamFailure o = (StreamFailure)other;
            return this.streamId.equals(o.streamId) && this.error.equals(o.error);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamId", this.streamId).add("error", this.error).toString();
    }
}

