/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.util.sketch.BitArray;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.apache.spark.util.sketch.Murmur3_x86_32;
import org.apache.spark.util.sketch.Platform;
import org.apache.spark.util.sketch.Utils;

class BloomFilterImpl
extends BloomFilter
implements Serializable {
    private int numHashFunctions;
    private BitArray bits;

    BloomFilterImpl(int numHashFunctions, long numBits) {
        this(new BitArray(numBits), numHashFunctions);
    }

    private BloomFilterImpl(BitArray bits, int numHashFunctions) {
        this.bits = bits;
        this.numHashFunctions = numHashFunctions;
    }

    private BloomFilterImpl() {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BloomFilterImpl)) {
            return false;
        }
        BloomFilterImpl that = (BloomFilterImpl)other;
        return this.numHashFunctions == that.numHashFunctions && this.bits.equals(that.bits);
    }

    public int hashCode() {
        return this.bits.hashCode() * 31 + this.numHashFunctions;
    }

    @Override
    public double expectedFpp() {
        return Math.pow((double)this.bits.cardinality() / (double)this.bits.bitSize(), this.numHashFunctions);
    }

    @Override
    public long bitSize() {
        return this.bits.bitSize();
    }

    @Override
    public boolean put(Object item) {
        if (item instanceof String) {
            return this.putString((String)item);
        }
        if (item instanceof byte[]) {
            return this.putBinary((byte[])item);
        }
        return this.putLong(Utils.integralToLong(item));
    }

    @Override
    public boolean putString(String item) {
        return this.putBinary(Utils.getBytesFromUTF8String(item));
    }

    @Override
    public boolean putBinary(byte[] item) {
        int h1 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, 0);
        int h2 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, h1);
        long bitSize = this.bits.bitSize();
        boolean bitsChanged = false;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set((long)combinedHash % bitSize);
        }
        return bitsChanged;
    }

    @Override
    public boolean mightContainString(String item) {
        return this.mightContainBinary(Utils.getBytesFromUTF8String(item));
    }

    @Override
    public boolean mightContainBinary(byte[] item) {
        int h1 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, 0);
        int h2 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, h1);
        long bitSize = this.bits.bitSize();
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bits.get((long)combinedHash % bitSize)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean putLong(long item) {
        int h1 = Murmur3_x86_32.hashLong(item, 0);
        int h2 = Murmur3_x86_32.hashLong(item, h1);
        long bitSize = this.bits.bitSize();
        boolean bitsChanged = false;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set((long)combinedHash % bitSize);
        }
        return bitsChanged;
    }

    @Override
    public boolean mightContainLong(long item) {
        int h1 = Murmur3_x86_32.hashLong(item, 0);
        int h2 = Murmur3_x86_32.hashLong(item, h1);
        long bitSize = this.bits.bitSize();
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bits.get((long)combinedHash % bitSize)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mightContain(Object item) {
        if (item instanceof String) {
            return this.mightContainString((String)item);
        }
        if (item instanceof byte[]) {
            return this.mightContainBinary((byte[])item);
        }
        return this.mightContainLong(Utils.integralToLong(item));
    }

    @Override
    public boolean isCompatible(BloomFilter other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof BloomFilterImpl)) {
            return false;
        }
        BloomFilterImpl that = (BloomFilterImpl)other;
        return this.bitSize() == that.bitSize() && this.numHashFunctions == that.numHashFunctions;
    }

    @Override
    public BloomFilter mergeInPlace(BloomFilter other) throws IncompatibleMergeException {
        BloomFilterImpl otherImplInstance = this.checkCompatibilityForMerge(other);
        this.bits.putAll(otherImplInstance.bits);
        return this;
    }

    @Override
    public BloomFilter intersectInPlace(BloomFilter other) throws IncompatibleMergeException {
        BloomFilterImpl otherImplInstance = this.checkCompatibilityForMerge(other);
        this.bits.and(otherImplInstance.bits);
        return this;
    }

    @Override
    public long cardinality() {
        return this.bits.cardinality();
    }

    private BloomFilterImpl checkCompatibilityForMerge(BloomFilter other) throws IncompatibleMergeException {
        if (other == null) {
            throw new IncompatibleMergeException("Cannot merge null bloom filter");
        }
        if (!(other instanceof BloomFilterImpl)) {
            throw new IncompatibleMergeException("Cannot merge bloom filter of class " + other.getClass().getName());
        }
        BloomFilterImpl that = (BloomFilterImpl)other;
        if (this.bitSize() != that.bitSize()) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different bit size");
        }
        if (this.numHashFunctions != that.numHashFunctions) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different number of hash functions");
        }
        return that;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(BloomFilter.Version.V1.getVersionNumber());
        dos.writeInt(this.numHashFunctions);
        this.bits.writeTo(dos);
    }

    private void readFrom0(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        int version = dis.readInt();
        if (version != BloomFilter.Version.V1.getVersionNumber()) {
            throw new IOException("Unexpected Bloom filter version number (" + version + ")");
        }
        this.numHashFunctions = dis.readInt();
        this.bits = BitArray.readFrom(dis);
    }

    public static BloomFilterImpl readFrom(InputStream in) throws IOException {
        BloomFilterImpl filter = new BloomFilterImpl();
        filter.readFrom0(in);
        return filter;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readFrom0(in);
    }
}

