/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.command.PathFilterIgnoreNonData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class CommandUtils$
implements Logging {
    public static CommandUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CommandUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void updateTableStats(SparkSession sparkSession, CatalogTable table) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (sparkSession.sessionState().conf().autoSizeUpdateEnabled()) {
            CatalogTable newTable = catalog.getTableMetadata(table.identifier());
            BigInt newSize = this.calculateTotalSize(sparkSession, newTable);
            boolean isNewStats = BoxesRunTime.unboxToBoolean((Object)newTable.stats().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CommandUtils$.$anonfun$updateTableStats$1(newSize, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            if (isNewStats) {
                CatalogStatistics newStats = new CatalogStatistics(newSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
            }
        } else if (table.stats().nonEmpty()) {
            catalog.alterTableStats(table.identifier(), (Option)None$.MODULE$);
        } else {
            catalog.refreshTable(table.identifier());
        }
    }

    public BigInt calculateTotalSize(SparkSession spark, CatalogTable catalogTable) {
        long l;
        SessionState sessionState = spark.sessionState();
        long startTime = System.nanoTime();
        if (catalogTable.partitionColumnNames().isEmpty()) {
            l = this.calculateSingleLocationSize(sessionState, catalogTable.identifier(), (Option<URI>)catalogTable.storage().locationUri());
        } else {
            Seq partitions = sessionState.catalog().listPartitions(catalogTable.identifier(), sessionState.catalog().listPartitions$default$2());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Starting to calculate sizes for ").append(partitions.length()).append(" partitions.").toString());
            Seq paths = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.storage().locationUri(), Seq$.MODULE$.canBuildFrom());
            l = BoxesRunTime.unboxToLong((Object)this.calculateMultipleLocationSizes(spark, catalogTable.identifier(), (Seq<Option<URI>>)paths).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        long totalSize = l;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to calculate").append(" the total size for table ").append(catalogTable.identifier()).append(".").toString());
        return BigInt$.MODULE$.long2bigInt(totalSize);
    }

    public long calculateSingleLocationSize(SessionState sessionState, TableIdentifier identifier, Option<URI> locationUri) {
        String stagingDir = sessionState.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        long startTime = System.nanoTime();
        long size = BoxesRunTime.unboxToLong((Object)locationUri.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateSingleLocationSize$2(sessionState, identifier, stagingDir, p))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("It took ").append(durationInMs).append(" ms to calculate the total file size under path ").append(locationUri).append(".").toString());
        return size;
    }

    public Seq<Object> calculateMultipleLocationSizes(SparkSession sparkSession, TableIdentifier tid, Seq<Option<URI>> paths) {
        return sparkSession.sessionState().conf().parallelFileListingInStatsComputation() ? this.calculateMultipleLocationSizesInParallel(sparkSession, (Seq<Option<Path>>)((Seq)paths.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> new Path(x$4)), Seq$.MODULE$.canBuildFrom()))) : (Seq<Object>)paths.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.MODULE$.calculateSingleLocationSize(sparkSession.sessionState(), tid, (Option<URI>)p)), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Object> calculateMultipleLocationSizesInParallel(SparkSession sparkSession, Seq<Option<Path>> paths) {
        String stagingDir = sparkSession.sessionState().conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        PathFilterIgnoreNonData filter = new PathFilterIgnoreNonData(stagingDir);
        Seq sizes = (Seq)InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)((Seq)paths.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))), sparkSession.sessionState().newHadoopConf(), filter, sparkSession).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$2(x0$1)), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)paths.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$4(sizes, x0$2)), Seq$.MODULE$.canBuildFrom());
    }

    public Option<CatalogStatistics> compareAndGetNewStats(Option<CatalogStatistics> oldStats, BigInt newTotalSize, Option<BigInt> newRowCount) {
        None$ newStats;
        block2: {
            BigInt oldTotalSize = (BigInt)oldStats.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.sizeInBytes()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            BigInt oldRowCount = (BigInt)oldStats.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.rowCount()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            newStats = None$.MODULE$;
            if (newTotalSize.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0))) {
                BigInt bigInt = newTotalSize;
                BigInt bigInt2 = oldTotalSize;
                if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
                    newStats = new Some((Object)new CatalogStatistics(newTotalSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
                }
            }
            if (!newRowCount.isDefined() || !((Ordered)newRowCount.get()).$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)) || BoxesRunTime.equals((Object)newRowCount.get(), (Object)oldRowCount)) break block2;
            newStats = newStats.isDefined() ? newStats.map((Function1 & Serializable & scala.Serializable)x$9 -> {
                Option x$1 = newRowCount;
                BigInt x$2 = x$9.copy$default$1();
                Map x$3 = x$9.copy$default$3();
                return x$9.copy(x$2, x$1, x$3);
            }) : new Some((Object)new CatalogStatistics(oldTotalSize, newRowCount, CatalogStatistics$.MODULE$.apply$default$3()));
        }
        return newStats;
    }

    public void analyzeTable(SparkSession sparkSession, TableIdentifier tableIdent, boolean noScan) {
        block2: {
            CatalogTable tableMeta;
            TableIdentifier tableIdentWithDB;
            SessionState sessionState;
            block0: {
                block1: {
                    sessionState = sparkSession.sessionState();
                    String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase());
                    tableIdentWithDB = new TableIdentifier(tableIdent.table(), (Option)new Some((Object)db));
                    tableMeta = sessionState.catalog().getTableMetadata(tableIdentWithDB);
                    CatalogTableType catalogTableType = tableMeta.tableType();
                    CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                    if (catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) break block0;
                    Dataset<Row> table = sparkSession.table(tableIdent.quotedString());
                    CacheManager cacheManager = sparkSession.sharedState().cacheManager();
                    if (!cacheManager.lookupCachedData(table.logicalPlan()).isDefined()) break block1;
                    if (noScan) break block2;
                    table.count();
                    break block2;
                }
                throw QueryCompilationErrors$.MODULE$.analyzeTableNotSupportedOnViewsError();
            }
            BigInt newTotalSize = this.calculateTotalSize(sparkSession, tableMeta);
            None$ newRowCount = noScan ? None$.MODULE$ : new Some((Object)package$.MODULE$.BigInt().apply(sparkSession.table(tableIdentWithDB).count()));
            Option<CatalogStatistics> newStats = this.compareAndGetNewStats((Option<CatalogStatistics>)tableMeta.stats(), newTotalSize, (Option<BigInt>)newRowCount);
            if (!newStats.isDefined()) break block2;
            sessionState.catalog().alterTableStats(tableIdentWithDB, newStats);
        }
    }

    public Tuple2<Object, Map<Attribute, ColumnStat>> computeColumnStats(SparkSession sparkSession, LogicalPlan relation, Seq<Attribute> columns) {
        SQLConf conf = sparkSession.sessionState().conf();
        AttributeMap<ArrayData> attributePercentiles = this.computePercentiles(columns, sparkSession, relation);
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqLike)columns.map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.statExprs((Attribute)x$10, conf, attributePercentiles), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)aggregateExpression, Seq$.MODULE$.canBuildFrom());
        Seq namedExpressions = (Seq)expressions.map((Function1 & Serializable & scala.Serializable)e -> {
            Expression x$1 = e;
            String x$2 = e.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Seq$.MODULE$.canBuildFrom());
        InternalRow statsRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4()).executedPlan().executeTake(1))).head();
        long rowCount = statsRow.getLong(0);
        Map columnStats = ((TraversableOnce)((TraversableLike)columns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)attr, (Object)MODULE$.rowToColumnStat(statsRow.getStruct(i + 1, 7), attr, rowCount, (Option<ArrayData>)attributePercentiles.get(attr)));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    private AttributeMap<ArrayData> computePercentiles(Seq<Attribute> attributesToAnalyze, SparkSession sparkSession, LogicalPlan relation) {
        HashMap attributePercentiles;
        block0: {
            SQLConf conf = sparkSession.sessionState().conf();
            Nil$ attrsToGenHistogram = conf.histogramEnabled() ? (Seq)attributesToAnalyze.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)CommandUtils$.MODULE$.supportsHistogram(a.dataType()))) : Nil$.MODULE$;
            attributePercentiles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (!attrsToGenHistogram.nonEmpty()) break block0;
            double[] percentiles = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), conf.histogramNumBins()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> (double)i / (double)conf.histogramNumBins(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Seq namedExprs = (Seq)attrsToGenHistogram.map((Function1 & Serializable & scala.Serializable)attr -> {
                AggregateExpression expr;
                ApproximatePercentile aggFunc = new ApproximatePercentile((Expression)attr, (Expression)new Literal((Object)new GenericArrayData(percentiles), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)conf.percentileAccuracy())));
                AggregateExpression x$1 = expr = aggFunc.toAggregateExpression();
                String x$2 = expr.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
            }, Seq$.MODULE$.canBuildFrom());
            InternalRow percentilesRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExprs, relation), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4()).executedPlan().executeTake(1))).head();
            ((IterableLike)attrsToGenHistogram.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ArrayData percentiles = percentilesRow.getArray(i);
                BoxedUnit boxedUnit = percentiles != null ? attributePercentiles.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)percentiles)) : BoxedUnit.UNIT;
                return boxedUnit;
            });
        }
        return AttributeMap$.MODULE$.apply(attributePercentiles.toSeq());
    }

    private boolean supportsHistogram(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        return bl2;
    }

    private CreateNamedStruct statExprs(Attribute col, SQLConf conf, AttributeMap<ArrayData> colPercentiles) {
        CreateNamedStruct createNamedStruct;
        Literal one = new Literal((Object)BoxesRunTime.boxToLong((long)1), (DataType)LongType$.MODULE$);
        Count numNonNulls = col.nullable() ? Count$.MODULE$.apply((Expression)col) : Count$.MODULE$.apply((Expression)one);
        Least ndv = new Least((Seq)new .colon.colon((Object)new HyperLogLogPlusPlus((Expression)col, conf.ndvMaxError(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)numNonNulls, (List)Nil$.MODULE$)));
        Subtract numNulls = new Subtract((Expression)Count$.MODULE$.apply((Expression)one), (Expression)numNonNulls, Subtract$.MODULE$.apply$default$3());
        Literal defaultSize = new Literal((Object)BoxesRunTime.boxToLong((long)col.dataType().defaultSize()), (DataType)LongType$.MODULE$);
        Literal nullArray = new Literal(null, (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
        DataType dataType = col.dataType();
        if (dataType instanceof IntegralType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        } else if (dataType instanceof DecimalType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
        } else {
            boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
            if (bl) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (BooleanType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (DateType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, colPercentiles, conf, nullArray, ndv, numNulls, defaultSize);
            } else {
                boolean bl2 = BinaryType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType);
                if (bl2) {
                    Literal nullLit = new Literal(null, col.dataType());
                    createNamedStruct = CommandUtils$.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv, nullLit, nullLit, numNulls, new Coalesce((Seq)new .colon.colon((Object)new Ceil((Expression)new Average((Expression)new Length((Expression)col), Average$.MODULE$.apply$default$2())), (List)new .colon.colon((Object)defaultSize, (List)Nil$.MODULE$))), new Coalesce((Seq)new .colon.colon((Object)new Cast((Expression)new Max((Expression)new Length((Expression)col)), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)defaultSize, (List)Nil$.MODULE$))), nullArray}));
                } else {
                    throw QueryCompilationErrors$.MODULE$.analyzingColumnStatisticsNotSupportedForColumnTypeError(col.name(), col.dataType());
                }
            }
        }
        return createNamedStruct;
    }

    private ColumnStat rowToColumnStat(InternalRow row, Attribute attr, long rowCount, Option<ArrayData> percentiles) {
        ColumnStat columnStat;
        ColumnStat cs = new ColumnStat(Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(0))), Option$.MODULE$.apply(row.get(1, attr.dataType())), Option$.MODULE$.apply(row.get(2, attr.dataType())), Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(3))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(4))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(5))), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
        if (row.isNullAt(6) || cs.nullCount().isEmpty()) {
            columnStat = cs;
        } else {
            long[] ndvs = row.getArray(6).toLongArray();
            Predef$.MODULE$.assert(((ArrayData)percentiles.get()).numElements() == ndvs.length + 1);
            double[] endpoints = (double[])Predef$.MODULE$.genericArrayOps(((ArrayData)percentiles.get()).toArray(attr.dataType(), ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)CommandUtils$.$anonfun$rowToColumnStat$1(x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            HistogramBin[] bins = (HistogramBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ndvs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long ndv = tuple2._1$mcJ$sp();
                int i = tuple2._2$mcI$sp();
                HistogramBin histogramBin = new HistogramBin(endpoints[i], endpoints[i + 1], ndv);
                return histogramBin;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HistogramBin.class)));
            BigInt nonNullRows = BigInt$.MODULE$.long2bigInt(rowCount).$minus((BigInt)cs.nullCount().get());
            Histogram histogram = new Histogram(nonNullRows.toDouble() / (double)ndvs.length, bins);
            Some x$1 = new Some((Object)histogram);
            Option x$2 = cs.copy$default$1();
            Option x$3 = cs.copy$default$2();
            Option x$4 = cs.copy$default$3();
            Option x$5 = cs.copy$default$4();
            Option x$6 = cs.copy$default$5();
            Option x$7 = cs.copy$default$6();
            int x$8 = cs.copy$default$8();
            columnStat = cs.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option)x$1, x$8);
        }
        return columnStat;
    }

    private boolean isDataPath(Path path, String stagingDir) {
        return !path.getName().startsWith(stagingDir) && DataSourceUtils$.MODULE$.isDataPath(path);
    }

    public void uncacheTableOrView(SparkSession sparkSession, String name) {
        try {
            sparkSession.catalog().uncacheTable(name);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Exception when attempting to uncache ").append(name).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateTableStats$1(BigInt newSize$1, CatalogStatistics x$1) {
        BigInt bigInt = newSize$1;
        BigInt bigInt2 = x$1.sizeInBytes();
        return bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2);
    }

    public static final /* synthetic */ long $anonfun$calculateSingleLocationSize$1(String stagingDir$1, FileSystem fs$1, FileStatus status) {
        return MODULE$.isDataPath(status.getPath(), stagingDir$1) ? CommandUtils$.getPathSize$1(fs$1, status.getPath(), stagingDir$1) : 0L;
    }

    private static final long getPathSize$1(FileSystem fs, Path path, String stagingDir$1) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDirectory() ? BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).map((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateSingleLocationSize$1(stagingDir$1, fs, status)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    public static final /* synthetic */ long $anonfun$calculateSingleLocationSize$2(SessionState sessionState$1, TableIdentifier identifier$1, String stagingDir$1, URI p) {
        long l;
        Path path = new Path(p);
        try {
            FileSystem fs = path.getFileSystem(sessionState$1.newHadoopConf());
            l = CommandUtils$.getPathSize$1(fs, path, stagingDir$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Failed to get the size of table ").append(identifier$1.table()).append(" in the ").append("database ").append(identifier$1.database()).append(" because of ").append(e.toString()).toString(), e);
            long l2 = 0L;
            l = l2;
        }
        return l;
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq files = (Seq)tuple2._2();
        long l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return l;
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$5(Seq sizes$1, int idx$1, Path x$6) {
        return BoxesRunTime.unboxToLong((Object)sizes$1.apply(idx$1));
    }

    public static final /* synthetic */ long $anonfun$calculateMultipleLocationSizesInParallel$4(Seq sizes$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option p = (Option)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        long l = BoxesRunTime.unboxToLong((Object)p.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateMultipleLocationSizesInParallel$5(sizes$1, idx, x$6))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        return l;
    }

    private static final CreateNamedStruct struct$1(Seq exprs) {
        return CreateStruct$.MODULE$.apply((Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> (Expression)expr.transformUp((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AggregateFunction) {
                    AggregateFunction aggregateFunction = (AggregateFunction)A1;
                    object = aggregateFunction.toAggregateExpression();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AggregateFunction;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom()));
    }

    private final CreateNamedStruct fixedLenTypeStruct$1(Attribute col$1, AttributeMap colPercentiles$1, SQLConf conf$3, Literal nullArray$1, Least ndv$1, Subtract numNulls$1, Literal defaultSize$1) {
        boolean genHistogram = this.supportsHistogram(col$1.dataType()) && colPercentiles$1.contains(col$1);
        Literal intervalNdvsExpr = genHistogram ? new ApproxCountDistinctForIntervals((Expression)col$1, (Expression)new Literal(colPercentiles$1.apply((Object)col$1), (DataType)ArrayType$.MODULE$.apply(col$1.dataType())), conf$3.ndvMaxError(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5()) : nullArray$1;
        return CommandUtils$.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv$1, new Cast((Expression)new Min((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), new Cast((Expression)new Max((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), numNulls$1, defaultSize$1, defaultSize$1, intervalNdvsExpr}));
    }

    public static final /* synthetic */ double $anonfun$rowToColumnStat$1(Object x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12.toString())).toDouble();
    }

    private CommandUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

