/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ConfigurationUtil;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.entities.UnknownHandlerConfig;
import com.opensymphony.xwork2.config.impl.LocatableFactory;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.config.providers.XmlHelper;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ClassPathFinder;
import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigurationProvider.class);
    private List<Document> documents;
    private Set<String> includedFileNames;
    private String configFileName;
    private ObjectFactory objectFactory;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean errorIfMissing;
    private Map<String, String> dtdMappings;
    private Configuration configuration;
    private boolean throwExceptionOnDuplicateBeans = true;

    public XmlConfigurationProvider() {
        this("xwork.xml", true);
    }

    public XmlConfigurationProvider(String filename) {
        this(filename, true);
    }

    public XmlConfigurationProvider(String filename, boolean errorIfMissing) {
        this.configFileName = filename;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//Apache Struts//XWork 2.3//EN", "xwork-2.3.dtd");
        mappings.put("-//Apache Struts//XWork 2.1.3//EN", "xwork-2.1.3.dtd");
        mappings.put("-//Apache Struts//XWork 2.1//EN", "xwork-2.1.dtd");
        mappings.put("-//Apache Struts//XWork 2.0//EN", "xwork-2.0.dtd");
        mappings.put("-//Apache Struts//XWork 1.1.1//EN", "xwork-1.1.1.dtd");
        mappings.put("-//Apache Struts//XWork 1.1//EN", "xwork-1.1.dtd");
        mappings.put("-//Apache Struts//XWork 1.0//EN", "xwork-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setThrowExceptionOnDuplicateBeans(boolean val) {
        this.throwExceptionOnDuplicateBeans = val;
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames = configuration.getLoadedFileNames();
        this.loadDocuments(this.configFileName);
    }

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    private void loadDocuments(String configFileName) {
        try {
            this.loadedFileUrls.clear();
            this.documents = this.loadConfigurationFiles(configFileName, null);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration file " + configFileName, e);
        }
    }

    @Override
    public void register(ContainerBuilder containerBuilder, LocatableProperties props) throws ConfigurationException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Parsing configuration file [" + this.configFileName + "]", new String[0]);
        }
        HashMap<String, Element> loadedBeans = new HashMap<String, Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if ("bean".equals(nodeName)) {
                    String type = child.getAttribute("type");
                    String name = child.getAttribute("name");
                    String impl = child.getAttribute("class");
                    String onlyStatic = child.getAttribute("static");
                    String scopeStr = child.getAttribute("scope");
                    boolean optional = "true".equals(child.getAttribute("optional"));
                    Scope scope = Scope.SINGLETON;
                    if ("default".equals(scopeStr)) {
                        scope = Scope.DEFAULT;
                    } else if ("request".equals(scopeStr)) {
                        scope = Scope.REQUEST;
                    } else if ("session".equals(scopeStr)) {
                        scope = Scope.SESSION;
                    } else if ("singleton".equals(scopeStr)) {
                        scope = Scope.SINGLETON;
                    } else if ("thread".equals(scopeStr)) {
                        scope = Scope.THREAD;
                    }
                    if (StringUtils.isEmpty((String)name)) {
                        name = "default";
                    }
                    try {
                        Class cimpl;
                        Class ctype = cimpl = ClassLoaderUtil.loadClass(impl, this.getClass());
                        if (StringUtils.isNotEmpty((String)type)) {
                            ctype = ClassLoaderUtil.loadClass(type, this.getClass());
                        }
                        if ("true".equals(onlyStatic)) {
                            cimpl.getDeclaredClasses();
                            containerBuilder.injectStatics(cimpl);
                        } else {
                            if (containerBuilder.contains(ctype, name)) {
                                Location loc = LocationUtils.getLocation(loadedBeans.get(ctype.getName() + name));
                                if (this.throwExceptionOnDuplicateBeans) {
                                    throw new ConfigurationException("Bean type " + ctype + " with the name " + name + " has already been loaded by " + loc, (Object)child);
                                }
                            }
                            cimpl.getDeclaredConstructors();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loaded type:" + type + " name:" + name + " impl:" + impl, new String[0]);
                            }
                            containerBuilder.factory(ctype, name, new LocatableFactory(name, ctype, cimpl, scope, childNode), scope);
                        }
                        loadedBeans.put(ctype.getName() + name, child);
                    }
                    catch (Throwable ex) {
                        if (!optional) {
                            throw new ConfigurationException("Unable to load bean: type:" + type + " class:" + impl, ex, childNode);
                        }
                        LOG.debug("Unable to load optional class: " + ex, new String[0]);
                    }
                    continue;
                }
                if ("constant".equals(nodeName)) {
                    String name = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    props.setProperty(name, value, childNode);
                    continue;
                }
                if (!nodeName.equals("unknown-handler-stack")) continue;
                ArrayList<UnknownHandlerConfig> unknownHandlerStack = new ArrayList<UnknownHandlerConfig>();
                NodeList unknownHandlers = child.getElementsByTagName("unknown-handler-ref");
                int unknownHandlersSize = unknownHandlers.getLength();
                for (int k = 0; k < unknownHandlersSize; ++k) {
                    Element unknownHandler = (Element)unknownHandlers.item(k);
                    unknownHandlerStack.add(new UnknownHandlerConfig(unknownHandler.getAttribute("name")));
                }
                if (unknownHandlerStack.isEmpty()) continue;
                this.configuration.setUnknownHandlerStack(unknownHandlerStack);
            }
        }
    }

    @Override
    public void loadPackages() throws ConfigurationException {
        ArrayList<Element> reloads = new ArrayList<Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                PackageConfig cfg;
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !"package".equals(nodeName = (child = (Element)childNode).getNodeName()) || !(cfg = this.addPackage(child)).isNeedsRefresh()) continue;
                reloads.add(child);
            }
            this.loadExtraConfiguration(doc);
        }
        if (reloads.size() > 0) {
            this.reloadRequiredPackages(reloads);
        }
        for (Document doc : this.documents) {
            this.loadExtraConfiguration(doc);
        }
        this.documents.clear();
        this.configuration = null;
    }

    private void reloadRequiredPackages(List<Element> reloads) {
        if (reloads.size() > 0) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element pkg : reloads) {
                PackageConfig cfg = this.addPackage(pkg);
                if (!cfg.isNeedsRefresh()) continue;
                result.add(pkg);
            }
            if (result.size() > 0 && result.size() != reloads.size()) {
                this.reloadRequiredPackages(result);
                return;
            }
            if (result.size() > 0) {
                for (Element rp : result) {
                    List<PackageConfig> parents;
                    String parent = rp.getAttribute("extends");
                    if (parent == null || (parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent)) == null || parents.size() > 0) continue;
                    LOG.error("Unable to find parent packages " + parent, new String[0]);
                }
            }
        }
    }

    @Override
    public boolean needsReload() {
        for (String url : this.loadedFileUrls) {
            if (!FileManager.fileNeedsReloading(url)) continue;
            return true;
        }
        return false;
    }

    protected void addAction(Element actionElement, PackageConfig.Builder packageContext) throws ConfigurationException {
        Map<String, ResultConfig> results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        Location location = DomHelper.getLocationObject(actionElement);
        if (location == null && LOG.isWarnEnabled()) {
            LOG.warn("location null for " + className, new String[0]);
        }
        String string = methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        if (!StringUtils.isEmpty((String)className) && !this.verifyAction(className, name, location)) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to verify action [#0] with class [#1], from [#2]", name, className, location.toString());
            }
            return;
        }
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e, actionElement);
        }
        List<InterceptorMapping> interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List<ExceptionMappingConfig> exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        Set<String> allowedMethods = this.buildAllowedMethods(actionElement, packageContext);
        ActionConfig actionConfig = ((ActionConfig.Builder)new ActionConfig.Builder(packageContext.getName(), name, className).methodName(methodName).addResultConfigs(results).addInterceptors((List)interceptorList)).addExceptionMappings(exceptionMappings).addParams(XmlHelper.getParams(actionElement)).addAllowedMethod(allowedMethods).location(location).build();
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + (StringUtils.isNotEmpty((String)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig, new String[0]);
        }
    }

    protected boolean verifyAction(String className, String name, Location loc) {
        if (className.indexOf(123) > -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action class [" + className + "] contains a wildcard " + "replacement value, so it can't be verified", new String[0]);
            }
            return true;
        }
        try {
            if (this.objectFactory.isNoArgConstructorRequired()) {
                Class clazz = this.objectFactory.getClassInstance(className);
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new ConfigurationException("Action class [" + className + "] is not public", (Object)loc);
                }
                clazz.getConstructor(new Class[0]);
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class not found for action [" + className + "]", e, new String[0]);
            }
            throw new ConfigurationException("Action class [" + className + "] not found", (Object)loc);
        }
        catch (NoSuchMethodException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No constructor found for action [" + className + "]", e, new String[0]);
            }
            throw new ConfigurationException("Action class [" + className + "] does not have a public no-arg constructor", e, loc);
        }
        catch (RuntimeException ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Unable to verify action class [" + className + "] exists at initialization", new String[0]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action verification cause", ex, new String[0]);
            }
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to verify action class [" + className + "]", ex, new String[0]);
            }
            throw new ConfigurationException(ex, (Object)loc);
        }
        return true;
    }

    protected PackageConfig addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig.Builder newPackage = this.buildPackageContext(packageElement);
        if (newPackage.isNeedsRefresh()) {
            return newPackage.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + newPackage, new String[0]);
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadDefaultClassRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        PackageConfig cfg = newPackage.build();
        this.configuration.addPackageConfig(cfg.getName(), cfg);
        return cfg;
    }

    protected void addResultTypes(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Location loc = DomHelper.getLocationObject(resultTypeElement);
            Class clazz = this.verifyResultType(className, loc);
            if (clazz == null) continue;
            String paramName = null;
            try {
                paramName = (String)clazz.getField("DEFAULT_PARAM").get(null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ResultTypeConfig.Builder resultType = new ResultTypeConfig.Builder(name, className).defaultResultParam(paramName).location(DomHelper.getLocationObject(resultTypeElement));
            Map<String, String> params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.addParams(params);
            }
            packageContext.addResultTypeConfig(resultType.build());
            if (!"true".equals(def)) continue;
            packageContext.defaultResultType(name);
        }
    }

    protected Class verifyResultType(String className, Location loc) {
        block4: {
            try {
                return this.objectFactory.getClassInstance(className);
            }
            catch (ClassNotFoundException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Result class [" + className + "] doesn't exist (ClassNotFoundException) at " + loc.toString() + ", ignoring", e, new String[0]);
                }
            }
            catch (NoClassDefFoundError e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("Result class [" + className + "] doesn't exist (NoClassDefFoundError) at " + loc.toString() + ", ignoring", e, new String[0]);
            }
        }
        return null;
    }

    protected List<InterceptorMapping> buildInterceptorList(Element element, PackageConfig.Builder context) throws ConfigurationException {
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element) && !interceptorRefElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            List<InterceptorMapping> interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig.Builder buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.parseBoolean(abstractVal);
        String name = StringUtils.defaultString((String)packageElement.getAttribute("name"));
        String namespace = StringUtils.defaultString((String)packageElement.getAttribute("namespace"));
        String strictDMIVal = StringUtils.defaultString((String)packageElement.getAttribute("strict-method-invocation"));
        boolean strictDMI = Boolean.parseBoolean(strictDMIVal);
        if (StringUtils.isNotEmpty((String)packageElement.getAttribute("externalReferenceResolver"))) {
            throw new ConfigurationException("The 'externalReferenceResolver' attribute has been removed.  Please use a custom ObjectFactory or Interceptor.", (Object)packageElement);
        }
        PackageConfig.Builder cfg = new PackageConfig.Builder(name).namespace(namespace).isAbstract(isAbstract).strictMethodInvocation(strictDMI).location(DomHelper.getLocationObject(packageElement));
        if (StringUtils.isNotEmpty((String)StringUtils.defaultString((String)parent))) {
            List<PackageConfig> parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
            if (parents.size() <= 0) {
                cfg.needsRefresh(true);
            } else {
                cfg.addParents(parents);
            }
        }
        return cfg;
    }

    protected Map<String, ResultConfig> buildResults(Element element, PackageConfig.Builder packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element) && !resultElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (StringUtils.isEmpty((String)resultName)) {
                resultName = "success";
            }
            if (StringUtils.isEmpty((String)resultType) && StringUtils.isEmpty((String)(resultType = packageContext.getFullDefaultResultType()))) {
                throw new ConfigurationException("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?", (Object)resultElement);
            }
            ResultTypeConfig config = packageContext.getResultType(resultType);
            if (config == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'." + "  Did you mean '" + this.guessResultType(resultType) + "'?", (Object)resultElement);
            }
            String resultClass = config.getClazz();
            if (resultClass == null) {
                throw new ConfigurationException("Result type '" + resultType + "' is invalid");
            }
            Map<String, String> resultParams = XmlHelper.getParams(resultElement);
            if (resultParams.size() == 0 && resultElement.getChildNodes().getLength() >= 1) {
                resultParams = new LinkedHashMap<String, String>();
                String paramName = config.getDefaultResultParam();
                if (paramName != null) {
                    StringBuilder paramValue = new StringBuilder();
                    for (int j = 0; j < resultElement.getChildNodes().getLength(); ++j) {
                        String val;
                        if (resultElement.getChildNodes().item(j).getNodeType() != 3 || (val = resultElement.getChildNodes().item(j).getNodeValue()) == null) continue;
                        paramValue.append(val);
                    }
                    String val = paramValue.toString().trim();
                    if (val.length() > 0) {
                        resultParams.put(paramName, val);
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("no default parameter defined for result of type " + config.getName(), new String[0]);
                }
            }
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            Map<String, String> configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            ResultConfig resultConfig = new ResultConfig.Builder(resultName, resultClass).addParams(params).location(DomHelper.getLocationObject(element)).build();
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected String guessResultType(String type) {
        StringBuilder sb = null;
        if (type != null) {
            sb = new StringBuilder();
            boolean capNext = false;
            for (int x = 0; x < type.length(); ++x) {
                char c = type.charAt(x);
                if (c == '-') {
                    capNext = true;
                    continue;
                }
                if (Character.isLowerCase(c) && capNext) {
                    c = Character.toUpperCase(c);
                    capNext = false;
                }
                sb.append(c);
            }
        }
        return sb != null ? sb.toString() : null;
    }

    protected List<ExceptionMappingConfig> buildExceptionMappings(Element element, PackageConfig.Builder packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element) && !ehElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map<String, String> params = XmlHelper.getParams(ehElement);
            if (StringUtils.isEmpty((String)emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig.Builder(emName, exceptionClassName, exceptionResult).addParams(params).location(DomHelper.getLocationObject(ehElement)).build();
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected Set<String> buildAllowedMethods(Element element, PackageConfig.Builder packageContext) {
        NodeList allowedMethodsEls = element.getElementsByTagName("allowed-methods");
        Set<String> allowedMethods = null;
        if (allowedMethodsEls.getLength() > 0) {
            String s;
            allowedMethods = new HashSet<String>();
            Node n = allowedMethodsEls.item(0).getFirstChild();
            if (n != null && (s = n.getNodeValue().trim()).length() > 0) {
                allowedMethods = TextParseUtil.commaDelimitedStringToSet(s);
            }
        } else if (packageContext.isStrictMethodInvocation()) {
            allowedMethods = new HashSet();
        }
        return allowedMethods;
    }

    protected void loadDefaultInterceptorRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map<String, ResultConfig> results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadDefaultClassRef(PackageConfig.Builder packageContext, Element element) {
        NodeList defaultClassRefList = element.getElementsByTagName("default-class-ref");
        if (defaultClassRefList.getLength() > 0) {
            Element defaultClassRefElement = (Element)defaultClassRefList.item(0);
            packageContext.defaultClassRef(defaultClassRefElement.getAttribute("class"));
        }
    }

    protected void loadGobalExceptionMappings(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List<ExceptionMappingConfig> exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig.Builder context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig.Builder config = new InterceptorStackConfig.Builder(name).location(DomHelper.getLocationObject(element));
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List<InterceptorMapping> interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors((List)interceptors);
        }
        return config.build();
    }

    protected void loadInterceptorStacks(Element element, PackageConfig.Builder context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig.Builder context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map<String, String> params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig.Builder(name, className).addParams(params).location(DomHelper.getLocationObject(interceptorElement)).build();
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private List<Document> loadConfigurationFiles(String fileName, Element includeElement) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Document> finalDocs = new ArrayList<Document>();
        if (!this.includedFileNames.contains(fileName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading action configurations from: " + fileName, new String[0]);
            }
            this.includedFileNames.add(fileName);
            Iterator<URL> urls = null;
            InputStream is = null;
            IOException ioException = null;
            try {
                urls = this.getConfigurationUrls(fileName);
            }
            catch (IOException ex) {
                ioException = ex;
            }
            if (urls == null || !urls.hasNext()) {
                if (this.errorIfMissing) {
                    throw new ConfigurationException("Could not open files of the name " + fileName, ioException);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("Unable to locate configuration files of the name " + fileName + ", skipping", new String[0]);
                }
                return docs;
            }
            URL url = null;
            while (urls.hasNext()) {
                try {
                    url = urls.next();
                    is = FileManager.loadFile(url);
                    InputSource in = new InputSource(is);
                    in.setSystemId(url.toString());
                    docs.add(DomHelper.parse(in, this.dtdMappings));
                }
                catch (XWorkException e) {
                    if (includeElement != null) {
                        throw new ConfigurationException("Unable to load " + url, e, includeElement);
                    }
                    throw new ConfigurationException("Unable to load " + url, e);
                }
                catch (Exception e) {
                    String s = "Caught exception while loading file " + fileName;
                    throw new ConfigurationException(s, e, includeElement);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error("Unable to close input stream", e, new String[0]);
                    }
                }
            }
            Collections.sort(docs, new Comparator<Document>(){

                @Override
                public int compare(Document doc1, Document doc2) {
                    return XmlHelper.getLoadOrder(doc1).compareTo(XmlHelper.getLoadOrder(doc2));
                }
            });
            for (Document doc : docs) {
                Element rootElement = doc.getDocumentElement();
                NodeList children = rootElement.getChildNodes();
                int childSize = children.getLength();
                for (int i = 0; i < childSize; ++i) {
                    Element child;
                    String nodeName;
                    Node childNode = children.item(i);
                    if (!(childNode instanceof Element) || !"include".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
                    String includeFileName = child.getAttribute("file");
                    if (includeFileName.indexOf(42) != -1) {
                        ClassPathFinder wildcardFinder = new ClassPathFinder();
                        wildcardFinder.setPattern(includeFileName);
                        Vector<String> wildcardMatches = wildcardFinder.findMatches();
                        for (String match : wildcardMatches) {
                            finalDocs.addAll(this.loadConfigurationFiles(match, child));
                        }
                        continue;
                    }
                    finalDocs.addAll(this.loadConfigurationFiles(includeFileName, child));
                }
                finalDocs.add(doc);
                this.loadedFileUrls.add(url.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded action configuration from: " + fileName, new String[0]);
            }
        }
        return finalDocs;
    }

    protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
        return ClassLoaderUtil.getResources(fileName, XmlConfigurationProvider.class, false);
    }

    protected void loadExtraConfiguration(Document doc) {
    }

    private List<InterceptorMapping> lookupInterceptorReference(PackageConfig.Builder context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map<String, String> refParams = XmlHelper.getParams(interceptorRefElement);
        Location loc = LocationUtils.getLocation(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams, loc, this.objectFactory);
    }

    List<Document> getDocuments() {
        return this.documents;
    }
}

