/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.views.xslt.AbstractAdapterElement;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.apache.struts2.views.xslt.SimpleTextNode;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAdapter
extends AbstractAdapterElement {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    boolean parseStringAsXML;

    public StringAdapter() {
    }

    public StringAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, String value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    protected String getStringValue() {
        return this.getPropertyValue().toString();
    }

    @Override
    protected List<Node> buildChildAdapters() {
        Node node;
        if (this.getParseStringAsXML()) {
            this.log.debug("parsing string as xml: " + this.getStringValue(), new String[0]);
            node = DomHelper.parse((InputSource)new InputSource(new StringReader(this.getStringValue())));
            node = this.getAdapterFactory().proxyNode(this, node);
        } else {
            this.log.debug("using string as is: " + this.getStringValue(), new String[0]);
            node = new SimpleTextNode(this.getAdapterFactory(), this, "text", this.getStringValue());
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(node);
        return children;
    }

    public boolean getParseStringAsXML() {
        return this.parseStringAsXML;
    }

    public void setParseStringAsXML(boolean parseStringAsXML) {
        this.parseStringAsXML = parseStringAsXML;
    }
}

