/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.logging;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.commons.CommonsLoggerFactory;
import com.opensymphony.xwork2.util.logging.jdk.JdkLoggerFactory;
import com.opensymphony.xwork2.util.logging.log4j2.Log4j2LoggerFactory;
import com.opensymphony.xwork2.util.logging.slf4j.Slf4jLoggerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Deprecated
public abstract class LoggerFactory {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static LoggerFactory factory;
    private static final List<LoggerClass> loggers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerFactory(LoggerFactory factory) {
        lock.writeLock().lock();
        try {
            LoggerFactory.factory = factory;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static Logger getLogger(Class<?> cls) {
        return LoggerFactory.getLoggerFactory().getLoggerImpl(cls);
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLoggerFactory().getLoggerImpl(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LoggerFactory getLoggerFactory() {
        lock.readLock().lock();
        try {
            if (factory != null) {
                LoggerFactory loggerFactory = factory;
                return loggerFactory;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            if (factory == null) {
                LoggerFactory.createLoggerFactory();
            }
            LoggerFactory loggerFactory = factory;
            return loggerFactory;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static void createLoggerFactory() {
        String userLoggerFactory = System.getProperty("xwork.loggerFactory");
        if (userLoggerFactory != null) {
            try {
                Class<?> clazz = Class.forName(userLoggerFactory);
                factory = (LoggerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new XWorkException("System property [xwork.loggerFactory] was defined as [" + userLoggerFactory + "] but there is a problem to use that LoggerFactory!", e);
            }
        } else {
            factory = new JdkLoggerFactory();
            for (LoggerClass logger : loggers) {
                if (!logger.isSupported()) continue;
                factory = logger.createInstance();
                break;
            }
        }
    }

    protected abstract Logger getLoggerImpl(Class<?> var1);

    protected abstract Logger getLoggerImpl(String var1);

    static {
        loggers = new LinkedList<LoggerClass>(){
            {
                this.add(new LoggerClass<CommonsLoggerFactory>("org.apache.commons.logging.LogFactory", CommonsLoggerFactory.class));
                this.add(new LoggerClass<Slf4jLoggerFactory>("org.slf4j.LoggerFactory", Slf4jLoggerFactory.class));
                this.add(new LoggerClass<Log4j2LoggerFactory>("org.apache.logging.log4j.LogManager", Log4j2LoggerFactory.class));
            }
        };
    }

    private static class LoggerClass<T extends LoggerFactory> {
        private final String loggerClazzName;
        private final Class<T> loggerImplClazz;

        public LoggerClass(String loggerClazzName, Class<T> loggerImplClazz) {
            this.loggerClazzName = loggerClazzName;
            this.loggerImplClazz = loggerImplClazz;
        }

        public boolean isSupported() {
            try {
                Class.forName(this.loggerClazzName);
                return true;
            }
            catch (ClassNotFoundException ignore) {
                return false;
            }
        }

        public LoggerFactory createInstance() {
            try {
                return (LoggerFactory)this.loggerImplClazz.newInstance();
            }
            catch (Exception e) {
                throw new XWorkException(e);
            }
        }
    }
}

