/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class SerializationParams {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private final HttpServletResponse response;
    private final String encoding;
    private final boolean wrapWithComments;
    private final String serializedJSON;
    private final boolean smd;
    private final boolean gzip;
    private final boolean noCache;
    private final int statusCode;
    private final int errorCode;
    private final boolean prefix;
    private String contentType = "application/json";
    private String wrapPrefix;
    private String wrapSuffix;

    public SerializationParams(HttpServletResponse response, String encoding, boolean wrapWithComments, String serializedJSON, boolean smd, boolean gzip, boolean noCache, int statusCode, int errorCode, boolean prefix, String contentType, String wrapPrefix, String wrapSuffix) {
        this.response = response;
        this.encoding = encoding;
        this.wrapWithComments = wrapWithComments;
        this.serializedJSON = serializedJSON;
        this.smd = smd;
        this.gzip = gzip;
        this.noCache = noCache;
        this.statusCode = statusCode;
        this.errorCode = errorCode;
        this.prefix = prefix;
        this.contentType = StringUtils.defaultString((String)contentType, (String)DEFAULT_CONTENT_TYPE);
        this.wrapPrefix = wrapPrefix;
        this.wrapSuffix = wrapSuffix;
    }

    public SerializationParams(HttpServletResponse response, String defaultEncoding, boolean wrapWithComments, String json, boolean b, boolean b1, boolean noCache, int i, int i1, boolean prefix, String contentType) {
        this(response, defaultEncoding, wrapWithComments, json, b, b1, noCache, i, i1, prefix, contentType, null, null);
    }

    public String getWrapSuffix() {
        return this.wrapSuffix;
    }

    public String getWrapPrefix() {
        return this.wrapPrefix;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isWrapWithComments() {
        return this.wrapWithComments;
    }

    public String getSerializedJSON() {
        return this.serializedJSON;
    }

    public boolean isSmd() {
        return this.smd;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public String getContentType() {
        return this.contentType;
    }
}

