/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TxConstants;

public abstract class AbstractTransactionAwareTable
implements TransactionAware {
    protected final TransactionCodec txCodec;
    protected final Map<Long, Set<ActionChange>> changeSets;
    protected final TxConstants.ConflictDetection conflictLevel;
    protected Transaction tx;
    protected boolean allowNonTransactional;

    public AbstractTransactionAwareTable(TxConstants.ConflictDetection conflictLevel, boolean allowNonTransactional) {
        this.conflictLevel = conflictLevel;
        this.allowNonTransactional = allowNonTransactional;
        this.txCodec = new TransactionCodec();
        this.changeSets = Maps.newHashMap();
    }

    public boolean getAllowNonTransactional() {
        return this.allowNonTransactional;
    }

    public void setAllowNonTransactional(boolean allowNonTransactional) {
        this.allowNonTransactional = allowNonTransactional;
    }

    public void startTx(Transaction tx) {
        this.tx = tx;
    }

    public void updateTx(Transaction tx) {
        this.tx = tx;
    }

    public Collection<byte[]> getTxChanges() {
        if (this.conflictLevel == TxConstants.ConflictDetection.NONE) {
            return Collections.emptyList();
        }
        TreeSet<byte[]> txChanges = new TreeSet<byte[]>(UnsignedBytes.lexicographicalComparator());
        for (Set<ActionChange> changeSet : this.changeSets.values()) {
            for (ActionChange change : changeSet) {
                txChanges.add(this.getChangeKey(change.getRow(), change.getFamily(), change.getQualifier()));
            }
        }
        return txChanges;
    }

    public byte[] getChangeKey(byte[] row, byte[] family, byte[] qualifier) {
        byte[] key;
        switch (this.conflictLevel) {
            case ROW: {
                key = Bytes.concat((byte[][])new byte[][]{this.getTableKey(), row});
                break;
            }
            case COLUMN: {
                key = Bytes.concat((byte[][])new byte[][]{this.getTableKey(), row, family, qualifier});
                break;
            }
            case NONE: {
                throw new IllegalStateException("NONE conflict detection does not support change keys");
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
        return key;
    }

    public boolean commitTx() throws Exception {
        return this.doCommit();
    }

    protected abstract boolean doCommit() throws IOException;

    public void postTxCommit() {
        this.tx = null;
        this.changeSets.clear();
    }

    public String getTransactionAwareName() {
        return new String(this.getTableKey(), Charsets.UTF_8);
    }

    protected abstract byte[] getTableKey();

    public boolean rollbackTx() throws Exception {
        return this.doRollback();
    }

    protected abstract boolean doRollback() throws Exception;

    protected void addToChangeSet(byte[] row, byte[] family, byte[] qualifier) {
        long currentWritePointer = this.tx.getWritePointer();
        HashSet changeSet = this.changeSets.get(currentWritePointer);
        if (changeSet == null) {
            changeSet = Sets.newHashSet();
            this.changeSets.put(currentWritePointer, changeSet);
        }
        switch (this.conflictLevel) {
            case ROW: 
            case NONE: {
                changeSet.add(new ActionChange(row, family));
                break;
            }
            case COLUMN: {
                changeSet.add(new ActionChange(row, family, qualifier));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
    }

    protected class ActionChange {
        private final byte[] row;
        private final byte[] family;
        private final byte[] qualifier;

        public ActionChange(byte[] row, byte[] family) {
            this(row, family, null);
        }

        public ActionChange(byte[] row, byte[] family, byte[] qualifier) {
            this.row = row;
            this.family = family;
            this.qualifier = qualifier;
        }

        public byte[] getRow() {
            return this.row;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ActionChange other = (ActionChange)o;
            return Objects.equal((Object)this.row, (Object)other.row) && Objects.equal((Object)this.family, (Object)other.family) && Objects.equal((Object)this.qualifier, (Object)other.qualifier);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.row);
            result = 31 * result + (this.family != null ? Arrays.hashCode(this.family) : 0);
            result = 31 * result + (this.qualifier != null ? Arrays.hashCode(this.qualifier) : 0);
            return result;
        }
    }
}

