/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticPool<T, E extends Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticPool.class);
    private final ConcurrentLinkedQueue<T> elements = new ConcurrentLinkedQueue();
    private final Semaphore semaphore;

    protected abstract T create() throws E;

    protected boolean recycle(T element) {
        return true;
    }

    public ElasticPool(int sizeLimit) {
        this.semaphore = new Semaphore(sizeLimit, true);
    }

    public T obtain() throws E, InterruptedException {
        this.semaphore.acquire();
        return this.getOrCreate();
    }

    public T obtain(long timeout, TimeUnit unit) throws E, TimeoutException, InterruptedException {
        if (!this.semaphore.tryAcquire(1, timeout, unit)) {
            throw new TimeoutException(String.format("Failed to obtain client within %d %s.", new Object[]{timeout, unit}));
        }
        return this.getOrCreate();
    }

    private T getOrCreate() throws E {
        try {
            T client = this.elements.poll();
            if (client != null) {
                return client;
            }
            return this.create();
        }
        catch (Exception e) {
            this.semaphore.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T element) {
        try {
            if (this.recycle(element)) {
                this.elements.add(element);
            }
        }
        finally {
            this.semaphore.release();
        }
    }
}

