/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.AbstractClientProvider;
import org.apache.tephra.distributed.CloseableThriftClient;
import org.apache.tephra.distributed.TransactionServiceThriftClient;
import org.apache.thrift.TException;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalClientProvider.class);
    ThreadLocal<TransactionServiceThriftClient> clients = new ThreadLocal();

    public ThreadLocalClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient) {
        super(conf, discoveryServiceClient);
    }

    @Override
    public CloseableThriftClient getCloseableClient() throws TException, TimeoutException, InterruptedException {
        TransactionServiceThriftClient client = this.clients.get();
        if (client == null) {
            try {
                client = this.newClient();
                this.clients.set(client);
            }
            catch (TException e) {
                LOG.error("Unable to create new tx client for thread: " + e.getMessage());
                throw e;
            }
        }
        return new CloseableThriftClient(this, client);
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        if (!client.isValid()) {
            client.close();
            this.clients.remove();
        }
    }

    public String toString() {
        return "Thread-local";
    }
}

