/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.InvalidTruncateTimeException;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionCouldNotTakeSnapshotException;
import org.apache.tephra.TransactionNotInProgressException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.distributed.CloseableThriftClient;
import org.apache.tephra.distributed.RetryNTimes;
import org.apache.tephra.distributed.RetryStrategy;
import org.apache.tephra.distributed.RetryStrategyProvider;
import org.apache.tephra.distributed.RetryWithBackoff;
import org.apache.tephra.distributed.ThriftClientProvider;
import org.apache.tephra.distributed.TransactionServiceThriftClient;
import org.apache.tephra.runtime.ConfigModule;
import org.apache.tephra.runtime.DiscoveryModules;
import org.apache.tephra.runtime.TransactionClientModule;
import org.apache.tephra.runtime.TransactionModules;
import org.apache.tephra.runtime.ZKModule;
import org.apache.tephra.util.ConfigurationFactory;
import org.apache.thrift.TException;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionServiceClient
implements TransactionSystemClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionServiceClient.class);
    private ThriftClientProvider clientProvider;
    private final RetryStrategyProvider retryStrategyProvider;
    private final String clientId;

    public static void main(String[] args) throws Exception {
        if (args.length > 1 || args.length == 1 && !"-v".equals(args[0])) {
            System.out.println("USAGE: TransactionServiceClient [-v]");
        }
        boolean verbose = false;
        if (args.length == 1 && "-v".equals(args[0])) {
            verbose = true;
        }
        TransactionServiceClient.doMain(verbose, new ConfigurationFactory().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void doMain(boolean verbose, Configuration conf) throws Exception {
        LOG.info("Starting tx server client test.");
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), new TransactionModules().getDistributedModules(), new TransactionClientModule()});
        ZKClientService zkClient = (ZKClientService)injector.getInstance(ZKClientService.class);
        zkClient.startAndWait();
        try {
            TransactionServiceClient client = (TransactionServiceClient)injector.getInstance(TransactionServiceClient.class);
            LOG.info("Starting tx...");
            Transaction tx = client.startShort();
            if (verbose) {
                LOG.info("Started tx details: " + tx.toString());
            } else {
                LOG.info("Started tx: " + tx.getTransactionId() + ", readPointer: " + tx.getReadPointer() + ", invalids: " + tx.getInvalids().length + ", inProgress: " + tx.getInProgress().length);
            }
            LOG.info("Checking if canCommit tx...");
            boolean canCommit = client.canCommit(tx, Collections.emptyList());
            LOG.info("canCommit: " + canCommit);
            if (canCommit) {
                LOG.info("Committing tx...");
                boolean committed = client.commit(tx);
                LOG.info("Committed tx: " + committed);
                if (!committed) {
                    LOG.info("Aborting tx...");
                    client.abort(tx);
                    LOG.info("Aborted tx...");
                }
            } else {
                LOG.info("Aborting tx...");
                client.abort(tx);
                LOG.info("Aborted tx...");
            }
        }
        finally {
            zkClient.stopAndWait();
        }
    }

    public TransactionServiceClient(Configuration config, ThriftClientProvider clientProvider) {
        this(config, clientProvider, ManagementFactory.getRuntimeMXBean().getName());
    }

    @Inject
    public TransactionServiceClient(Configuration config, ThriftClientProvider clientProvider, @Named(value="tephra.client.id") String clientId) {
        String retryStrat = config.get("data.tx.client.retry.strategy", "backoff");
        if ("backoff".equals(retryStrat)) {
            this.retryStrategyProvider = new RetryWithBackoff.Provider();
        } else if ("n-times".equals(retryStrat)) {
            this.retryStrategyProvider = new RetryNTimes.Provider();
        } else {
            try {
                this.retryStrategyProvider = (RetryStrategyProvider)Class.forName(retryStrat).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(String.format("Unable to instantiate RetryStrategyProvider '%s'", retryStrat), e);
            }
        }
        this.retryStrategyProvider.configure(config);
        LOG.debug("Retry strategy is " + this.retryStrategyProvider);
        this.clientProvider = clientProvider;
        this.clientId = clientId;
    }

    private <T> T execute(Operation<T> operation) throws Exception {
        return this.execute(operation, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Operation<T> operation, ThriftClientProvider provider) throws Exception {
        RetryStrategy retryStrategy = this.retryStrategyProvider.newRetryStrategy();
        while (true) {
            if (provider == null) {
                provider = this.clientProvider;
            }
            try (CloseableThriftClient closeable = provider.getCloseableClient();){
                T t = operation.execute(closeable.getThriftClient());
                return t;
            }
            catch (TException te) {
                boolean retry = retryStrategy.failOnce();
                if (!retry) {
                    String message = "Thrift error for " + operation + ": " + te.getMessage();
                    LOG.error(message);
                    LOG.debug(message, (Throwable)te);
                    throw te;
                }
                retryStrategy.beforeRetry();
                String msg = "Retrying " + operation.getName() + " after Thrift error: " + te.getMessage();
                LOG.info(msg);
                LOG.debug(msg, (Throwable)te);
                continue;
            }
            break;
        }
    }

    @Override
    public Transaction startLong() {
        try {
            return this.execute(new Operation<Transaction>("startLong"){

                @Override
                public Transaction execute(TransactionServiceThriftClient client) throws TException {
                    return client.startLong(TransactionServiceClient.this.clientId);
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Transaction startShort() {
        try {
            return this.execute(new Operation<Transaction>("startShort"){

                @Override
                public Transaction execute(TransactionServiceThriftClient client) throws TException {
                    return client.startShort(TransactionServiceClient.this.clientId);
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Transaction startShort(final int timeout) {
        try {
            return this.execute(new Operation<Transaction>("startShort"){

                @Override
                public Transaction execute(TransactionServiceThriftClient client) throws TException {
                    return client.startShort(TransactionServiceClient.this.clientId, timeout);
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean canCommit(final Transaction tx, final Collection<byte[]> changeIds) throws TransactionNotInProgressException {
        try {
            return this.execute(new Operation<Boolean>("canCommit"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws Exception {
                    return client.canCommit(tx, changeIds);
                }
            });
        }
        catch (TransactionNotInProgressException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean commit(final Transaction tx) throws TransactionNotInProgressException {
        try {
            return this.execute(new Operation<Boolean>("commit"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws Exception {
                    return client.commit(tx);
                }
            });
        }
        catch (TransactionNotInProgressException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void abort(final Transaction tx) {
        try {
            this.execute(new Operation<Boolean>("abort"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws TException {
                    client.abort(tx);
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean invalidate(final long tx) {
        try {
            return this.execute(new Operation<Boolean>("invalidate"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws TException {
                    return client.invalidate(tx);
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Transaction checkpoint(final Transaction tx) throws TransactionNotInProgressException {
        try {
            return this.execute(new Operation<Transaction>("checkpoint"){

                @Override
                Transaction execute(TransactionServiceThriftClient client) throws Exception {
                    return client.checkpoint(tx);
                }
            });
        }
        catch (TransactionNotInProgressException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public InputStream getSnapshotInputStream() throws TransactionCouldNotTakeSnapshotException {
        try {
            return this.execute(new Operation<InputStream>("takeSnapshot"){

                @Override
                public InputStream execute(TransactionServiceThriftClient client) throws Exception {
                    return client.getSnapshotStream();
                }
            });
        }
        catch (TransactionCouldNotTakeSnapshotException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String status() {
        try {
            return this.execute(new Operation<String>("status"){

                @Override
                public String execute(TransactionServiceThriftClient client) throws Exception {
                    return client.status();
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void resetState() {
        try {
            this.execute(new Operation<Boolean>("resetState"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws TException {
                    client.resetState();
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean truncateInvalidTx(final Set<Long> invalidTxIds) {
        try {
            return this.execute(new Operation<Boolean>("truncateInvalidTx"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws TException {
                    return client.truncateInvalidTx(invalidTxIds);
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean truncateInvalidTxBefore(final long time) throws InvalidTruncateTimeException {
        try {
            return this.execute(new Operation<Boolean>("truncateInvalidTxBefore"){

                @Override
                public Boolean execute(TransactionServiceThriftClient client) throws Exception {
                    return client.truncateInvalidTxBefore(time);
                }
            });
        }
        catch (InvalidTruncateTimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public int getInvalidSize() {
        try {
            return this.execute(new Operation<Integer>("getInvalidSize"){

                @Override
                public Integer execute(TransactionServiceThriftClient client) throws TException {
                    return client.getInvalidSize();
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static abstract class Operation<T> {
        String name;

        Operation(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        abstract T execute(TransactionServiceThriftClient var1) throws Exception;
    }
}

