/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tephra.InvalidTruncateTimeException;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionCouldNotTakeSnapshotException;
import org.apache.tephra.TransactionNotInProgressException;
import org.apache.tephra.distributed.TransactionConverterUtils;
import org.apache.tephra.distributed.thrift.TGenericException;
import org.apache.tephra.distributed.thrift.TInvalidTruncateTimeException;
import org.apache.tephra.distributed.thrift.TTransactionCouldNotTakeSnapshotException;
import org.apache.tephra.distributed.thrift.TTransactionNotInProgressException;
import org.apache.tephra.distributed.thrift.TTransactionServer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionServiceThriftClient {
    private static final Function<byte[], ByteBuffer> BYTES_WRAPPER = new Function<byte[], ByteBuffer>(){

        public ByteBuffer apply(byte[] input) {
            return ByteBuffer.wrap(input);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(TransactionServiceThriftClient.class);
    TTransport transport;
    TTransactionServer.Client client;
    private final AtomicBoolean isValid = new AtomicBoolean(true);

    public TransactionServiceThriftClient(TTransport transport) {
        this.transport = transport;
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        this.client = new TTransactionServer.Client((TProtocol)protocol);
    }

    public void close() {
        if (this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public Transaction startLong() throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startLong());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction startLong(String clientId) throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startLongClientId(clientId));
        }
        catch (TGenericException e) {
            if (!IllegalArgumentException.class.getName().equals(e.getOriginalExceptionClass())) {
                LOG.trace("Expecting only {} as the original exception class but found {}", (Object)IllegalArgumentException.class.getName(), (Object)e.getOriginalExceptionClass());
                throw e;
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction startShort() throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startShort());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction startShort(int timeout) throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startShortWithTimeout(timeout));
        }
        catch (TGenericException e) {
            if (!IllegalArgumentException.class.getName().equals(e.getOriginalExceptionClass())) {
                LOG.trace("Expecting only {} as the original exception class but found {}", (Object)IllegalArgumentException.class.getName(), (Object)e.getOriginalExceptionClass());
                throw e;
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction startShort(String clientId) throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startShortClientId(clientId));
        }
        catch (TGenericException e) {
            if (!IllegalArgumentException.class.getName().equals(e.getOriginalExceptionClass())) {
                LOG.trace("Expecting only {} as the original exception class but found {}", (Object)IllegalArgumentException.class.getName(), (Object)e.getOriginalExceptionClass());
                throw e;
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction startShort(String clientId, int timeout) throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.startShortWithClientIdAndTimeOut(clientId, timeout));
        }
        catch (TGenericException e) {
            if (!IllegalArgumentException.class.getName().equals(e.getOriginalExceptionClass())) {
                LOG.trace("Expecting only {} as the original exception class but found {}", (Object)IllegalArgumentException.class.getName(), (Object)e.getOriginalExceptionClass());
                throw e;
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean canCommit(Transaction tx, Collection<byte[]> changeIds) throws TException, TransactionNotInProgressException {
        try {
            return this.client.canCommitTx(TransactionConverterUtils.wrap(tx), (Set<ByteBuffer>)ImmutableSet.copyOf((Iterable)Iterables.transform(changeIds, BYTES_WRAPPER))).isValue();
        }
        catch (TTransactionNotInProgressException e) {
            throw new TransactionNotInProgressException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean commit(Transaction tx) throws TException, TransactionNotInProgressException {
        try {
            return this.client.commitTx(TransactionConverterUtils.wrap(tx)).isValue();
        }
        catch (TTransactionNotInProgressException e) {
            throw new TransactionNotInProgressException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public void abort(Transaction tx) throws TException {
        try {
            this.client.abortTx(TransactionConverterUtils.wrap(tx));
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean invalidate(long tx) throws TException {
        try {
            return this.client.invalidateTx(tx);
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public Transaction checkpoint(Transaction tx) throws TException {
        try {
            return TransactionConverterUtils.unwrap(this.client.checkpoint(TransactionConverterUtils.wrap(tx)));
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public InputStream getSnapshotStream() throws TException, TransactionCouldNotTakeSnapshotException {
        try {
            ByteBuffer buffer = this.client.getSnapshot();
            if (buffer.hasArray()) {
                return new ByteArrayInputStream(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
            byte[] snapshot = new byte[buffer.remaining()];
            buffer.get(snapshot);
            return new ByteArrayInputStream(snapshot);
        }
        catch (TTransactionCouldNotTakeSnapshotException e) {
            throw new TransactionCouldNotTakeSnapshotException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public String status() throws TException {
        try {
            return this.client.status();
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public void resetState() throws TException {
        try {
            this.client.resetState();
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean truncateInvalidTx(Set<Long> invalidTxIds) throws TException {
        try {
            return this.client.truncateInvalidTx(invalidTxIds).isValue();
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean truncateInvalidTxBefore(long time) throws TException, InvalidTruncateTimeException {
        try {
            return this.client.truncateInvalidTxBefore(time).isValue();
        }
        catch (TInvalidTruncateTimeException e) {
            throw new InvalidTruncateTimeException(e.getMessage());
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public int getInvalidSize() throws TException {
        try {
            return this.client.invalidTxSize();
        }
        catch (TException e) {
            this.isValid.set(false);
            throw e;
        }
    }

    public boolean isValid() {
        return this.isValid.get();
    }
}

