/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tiles.CompareUtil;
import org.apache.tiles.Expression;
import org.apache.tiles.request.Request;

public class Attribute
implements Serializable,
Cloneable {
    private static final String TEMPLATE_RENDERER = "template";
    protected Set<String> roles = null;
    protected Object value = null;
    protected Expression expressionObject = null;
    private String renderer = null;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.roles = attribute.roles;
        this.value = attribute.getValue();
        this.expressionObject = attribute.expressionObject != null ? new Expression(attribute.expressionObject) : null;
        this.renderer = attribute.renderer;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.setRole(role);
    }

    public Attribute(Object value, Expression expression, String role, String rendererName) {
        this.value = value;
        this.expressionObject = expression;
        this.renderer = rendererName;
        this.setRole(role);
    }

    public static Attribute createTemplateAttribute(String template) {
        Attribute attribute = new Attribute();
        attribute.setValue(template);
        attribute.setRenderer(TEMPLATE_RENDERER);
        return attribute;
    }

    public static Attribute createTemplateAttribute(String template, String templateExpression, String templateType, String role) {
        Attribute templateAttribute = Attribute.createTemplateAttribute(template);
        templateAttribute.setRole(role);
        if (templateType != null) {
            templateAttribute.setRenderer(templateType);
        }
        templateAttribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(templateExpression));
        return templateAttribute;
    }

    public static Attribute createTemplateAttributeWithExpression(String templateExpression) {
        Attribute attribute = new Attribute();
        attribute.setExpressionObject(new Expression(templateExpression));
        attribute.setRenderer(TEMPLATE_RENDERER);
        return attribute;
    }

    public String getRole() {
        String retValue = null;
        if (this.roles != null && !this.roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> roleIt = this.roles.iterator();
            if (roleIt.hasNext()) {
                builder.append(roleIt.next());
                while (roleIt.hasNext()) {
                    builder.append(",");
                    builder.append(roleIt.next());
                }
                retValue = builder.toString();
            }
        }
        return retValue;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRole(String role) {
        if (role != null && role.trim().length() > 0) {
            String[] rolesStrings = role.split("\\s*,\\s*");
            this.roles = new HashSet<String>();
            for (int i = 0; i < rolesStrings.length; ++i) {
                this.roles.add(rolesStrings[i]);
            }
        } else {
            this.roles = null;
        }
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Expression getExpressionObject() {
        return this.expressionObject;
    }

    public void setExpressionObject(Expression expressionObject) {
        this.expressionObject = expressionObject;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String rendererName) {
        this.renderer = rendererName;
    }

    public void inherit(Attribute attribute) {
        Expression targetExpressionObject;
        if (this.value == null) {
            this.value = attribute.getValue();
        }
        if ((targetExpressionObject = attribute.getExpressionObject()) != null && (this.expressionObject == null || this.expressionObject.getExpression() == null)) {
            this.expressionObject = new Expression(targetExpressionObject);
        }
        if (this.roles == null || this.roles.isEmpty()) {
            this.roles = attribute.getRoles();
        }
        if (this.renderer == null) {
            this.renderer = attribute.getRenderer();
        }
    }

    public boolean equals(Object obj) {
        Attribute attribute = (Attribute)obj;
        return CompareUtil.nullSafeEquals(this.value, attribute.value) && CompareUtil.nullSafeEquals(this.renderer, attribute.renderer) && CompareUtil.nullSafeEquals(this.roles, attribute.roles) && CompareUtil.nullSafeEquals(this.expressionObject, attribute.expressionObject);
    }

    public boolean isPermitted(Request request) {
        if (this.roles == null || this.roles.isEmpty()) {
            return true;
        }
        boolean retValue = false;
        Iterator<String> roleIt = this.roles.iterator();
        while (roleIt.hasNext() && !retValue) {
            retValue = request.isUserInRole(roleIt.next());
        }
        return retValue;
    }

    public int hashCode() {
        return CompareUtil.nullSafeHashCode(this.value) + CompareUtil.nullSafeHashCode(this.renderer) + CompareUtil.nullSafeHashCode(this.roles) + CompareUtil.nullSafeHashCode(this.expressionObject);
    }

    public Attribute clone() {
        return new Attribute(this);
    }
}

