/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.evaluator;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.Expression;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;

public class BasicAttributeEvaluatorFactory
implements AttributeEvaluatorFactory {
    private AttributeEvaluator defaultEvaluator;
    private Map<String, AttributeEvaluator> language2evaluator;

    public BasicAttributeEvaluatorFactory(AttributeEvaluator defaultEvaluator) {
        this.defaultEvaluator = defaultEvaluator;
        this.language2evaluator = new HashMap<String, AttributeEvaluator>();
    }

    public void registerAttributeEvaluator(String language, AttributeEvaluator evaluator) {
        this.language2evaluator.put(language, evaluator);
    }

    @Override
    public AttributeEvaluator getAttributeEvaluator(String language) {
        AttributeEvaluator retValue = this.language2evaluator.get(language);
        if (retValue == null) {
            retValue = this.defaultEvaluator;
        }
        return retValue;
    }

    @Override
    public AttributeEvaluator getAttributeEvaluator(Attribute attribute) {
        Expression expression = attribute.getExpressionObject();
        if (expression != null) {
            return this.getAttributeEvaluator(expression.getLanguage());
        }
        return this.defaultEvaluator;
    }
}

