/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.panel.Fragment;

final class MarkupFragmentFinder {
    final MarkupStream find(Component component) {
        MarkupContainer parentWithAssociatedMarkup = component.findParentWithAssociatedMarkup();
        MarkupStream markupStream = null;
        while (true) {
            String relativePath;
            int index;
            markupStream = parentWithAssociatedMarkup.getAssociatedMarkupStream(true);
            if (component.markupIndex != -1) {
                try {
                    ComponentTag tag;
                    String id;
                    markupStream.setCurrentIndex(component.markupIndex);
                    MarkupElement elem = markupStream.get();
                    if (elem instanceof ComponentTag && (id = (tag = (ComponentTag)elem).getId()) != null && id.equals(component.getId())) {
                        return markupStream;
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    // empty catch block
                }
            }
            if ((index = markupStream.findComponentIndex(relativePath = this.getComponentRelativePath(component, parentWithAssociatedMarkup), component.getId())) != -1) {
                markupStream.setCurrentIndex(index);
                return markupStream;
            }
            if (parentWithAssociatedMarkup instanceof Fragment) {
                markupStream = ((Fragment)parentWithAssociatedMarkup).findComponentIndex(component.getId());
                return markupStream;
            }
            if (!(parentWithAssociatedMarkup instanceof Border)) {
                throw new WicketRuntimeException("Unable to find the markup for the component. That may be due to transparent containers or components implementing IComponentResolver: " + component.toString());
            }
            parentWithAssociatedMarkup = parentWithAssociatedMarkup.findParentWithAssociatedMarkup();
            markupStream = null;
        }
    }

    private String getComponentRelativePath(Component component, MarkupContainer parentWithAssociatedMarkup) {
        String parentWithAssociatedMarkupPath;
        String componentPath = component.getParent().getPageRelativePath();
        String relativePath = componentPath.substring((parentWithAssociatedMarkupPath = parentWithAssociatedMarkup.getPageRelativePath()).length());
        if (relativePath.startsWith(":")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }
}

