/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.IClusterable;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public abstract class AjaxEventBehavior
extends AbstractDefaultAjaxBehavior {
    private static long sequence = 0L;
    private static final long serialVersionUID = 1L;
    private final String event;
    private ThrottlingSettings throttlingSettings;

    public AjaxEventBehavior(String event) {
        if (Strings.isEmpty(event)) {
            throw new IllegalArgumentException("argument [event] cannot be null or empty");
        }
        this.onCheckEvent(event);
        this.event = event;
    }

    public final AjaxEventBehavior setThrottleDelay(Duration throttleDelay) {
        this.throttlingSettings = new ThrottlingSettings("th" + ++sequence, throttleDelay);
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.getComponent().isEnabled()) {
            tag.put(this.event, this.getEventHandler());
        }
    }

    protected CharSequence getEventHandler() {
        CharSequence handler = this.getCallbackScript();
        if (this.event.equalsIgnoreCase("href")) {
            handler = "javascript:" + handler;
        }
        return handler;
    }

    protected CharSequence generateCallbackScript(CharSequence partialCall) {
        CharSequence script = super.generateCallbackScript(partialCall);
        ThrottlingSettings ts = this.throttlingSettings;
        if (ts != null) {
            script = AbstractDefaultAjaxBehavior.throttleScript(script, ts.getId(), ts.getDelay());
        }
        return script;
    }

    protected void onCheckEvent(String event) {
    }

    public final String getEvent() {
        return this.event;
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected abstract void onEvent(AjaxRequestTarget var1);

    private static class ThrottlingSettings
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final Duration delay;
        private final String id;

        public ThrottlingSettings(String id, Duration delay) {
            this.id = id;
            this.delay = delay;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public String getId() {
            return this.id;
        }
    }
}

