/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enclosure
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)Enclosure.class);
    private Component childComponent;
    private final CharSequence childId;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$border$Border;

    public Enclosure(String id, CharSequence childId) {
        super(id);
        this.childId = childId;
    }

    public boolean isTransparentResolver() {
        return true;
    }

    private Component getChildComponent(CharSequence childId) {
        MarkupContainer parent = this.getParent();
        while (parent != null) {
            if (parent.isTransparentResolver()) {
                parent = parent.getParent();
                continue;
            }
            if (!(parent instanceof Border.BorderBodyContainer)) break;
            parent = ((Border.BorderBodyContainer)parent).findParent(class$org$apache$wicket$markup$html$border$Border == null ? Enclosure.class$("org.apache.wicket.markup.html.border.Border") : class$org$apache$wicket$markup$html$border$Border);
        }
        if (parent == null) {
            throw new WicketRuntimeException("Unable to find parent component which is not a transparent resolver");
        }
        if (childId == null) {
            throw new MarkupException("You most likely forgot to register the EnclosureHandler with the MarkupParserFactory");
        }
        Component child = parent.get(((Object)childId).toString());
        if (child == null) {
            throw new MarkupException("Didn't find child component of <wicket:enclosure> with id='" + childId + "'. Component: " + this.toString());
        }
        return child;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.childComponent == null) {
            this.childComponent = this.getChildComponent(this.childId);
        }
        if (this.childComponent == this) {
            throw new WicketRuntimeException("Programming error: childComponent == enclose component; endless loop");
        }
        if (this.childComponent != null) {
            this.setVisible(this.childComponent.isVisible() && this.childComponent.isRenderAllowed());
        }
        if (this.isVisible()) {
            super.onComponentTagBody(markupStream, openTag);
        } else {
            markupStream.skipToMatchingCloseTag(openTag);
        }
    }
}

