/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.markup.html.tree.DefaultTreeState;
import org.apache.wicket.markup.html.tree.ITreeState;
import org.apache.wicket.markup.html.tree.ITreeStateListener;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AbstractTree
extends Panel
implements ITreeStateListener,
TreeModelListener {
    private static final long serialVersionUID = 1L;
    private boolean attached = false;
    private final AppendingStringBuffer deleteIds = new AppendingStringBuffer();
    private boolean dirtyAll = false;
    private final List dirtyItems = new ArrayList();
    private final List dirtyItemsCreateDOM = new ArrayList();
    private int idCounter = 0;
    private TreeItemContainer itemContainer;
    private final Map nodeToItemMap = new HashMap();
    private TreeModel previousModel = null;
    private TreeItem rootItem = null;
    private boolean rootLess = false;
    private ITreeState state;
    private static final ResourceReference JAVASCRIPT = new JavascriptResourceReference(AbstractTree.class, "res/tree.js");

    private static final Iterator toIterator(final Enumeration enumeration) {
        return new Iterator(){
            private final Enumeration e;
            {
                this.e = enumeration;
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object next() {
                return this.e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported on enumeration.");
            }
        };
    }

    public AbstractTree(String id) {
        super(id);
        this.init();
    }

    public AbstractTree(String id, IModel model) {
        super(id, model);
        this.init();
    }

    public final void allNodesCollapsed() {
        this.invalidateAll();
    }

    public final void allNodesExpanded() {
        this.invalidateAll();
    }

    public ITreeState getTreeState() {
        if (this.state == null) {
            this.state = this.newTreeState();
            this.state.addTreeStateListener(this);
        }
        return this.state;
    }

    protected void onBeforeAttach() {
    }

    private void onBeforeRenderInternal() {
        if (!this.attached) {
            TreeNode rootNode;
            this.onBeforeAttach();
            this.checkModel();
            if (this.dirtyAll && this.rootItem != null) {
                this.clearAllItem();
            } else {
                this.rebuildDirty();
            }
            if (this.rootItem == null && (rootNode = (TreeNode)((TreeModel)this.getModelObject()).getRoot()) != null) {
                this.rootItem = this.isRootLess() ? this.newTreeItem(rootNode, -1) : this.newTreeItem(rootNode, 0);
                this.itemContainer.add(this.rootItem);
                this.buildItemChildren(this.rootItem);
            }
            this.attached = true;
        }
    }

    public void onBeforeRender() {
        this.onBeforeRenderInternal();
        super.onBeforeRender();
    }

    public void onDetach() {
        this.attached = false;
        super.onDetach();
    }

    public final void invalidateAll() {
        this.updated();
        this.dirtyAll = true;
    }

    public final boolean isRootLess() {
        return this.rootLess;
    }

    public final void nodeCollapsed(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void nodeExpanded(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void nodeSelected(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, this.isForceRebuildOnSelectionChange());
        }
    }

    public final void nodeUnselected(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, this.isForceRebuildOnSelectionChange());
        }
    }

    protected boolean isForceRebuildOnSelectionChange() {
        return true;
    }

    public void setRootLess(boolean rootLess) {
        if (this.rootLess != rootLess) {
            this.rootLess = rootLess;
            this.invalidateAll();
            if (rootLess && this.getModelObject() != null) {
                this.getTreeState().expandNode((TreeNode)((TreeModel)this.getModelObject()).getRoot());
            }
        }
    }

    public final void treeNodesChanged(TreeModelEvent e) {
        if (e.getChildren() == null) {
            if (this.rootItem != null) {
                this.invalidateNode((TreeNode)this.rootItem.getModelObject(), true);
            }
        } else {
            Object[] children = e.getChildren();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    TreeNode node = (TreeNode)children[i];
                    if (!this.isNodeVisible(node)) continue;
                    this.invalidateNode(node, true);
                }
            }
        }
    }

    private void markTheLastButOneChildDirty(TreeItem parent, TreeItem child) {
        if (parent.getChildren().indexOf(child) == parent.getChildren().size() - 1) {
            for (int i = parent.getChildren().size() - 2; i >= 0; --i) {
                TreeItem item = (TreeItem)parent.getChildren().get(i);
                this.invalidateNodeWithChildren((TreeNode)item.getModelObject());
            }
        }
    }

    public final void treeNodesInserted(TreeModelEvent e) {
        TreeNode parent = (TreeNode)e.getTreePath().getLastPathComponent();
        if (this.isNodeVisible(parent) && this.isNodeExpanded(parent)) {
            TreeItem parentItem = (TreeItem)this.nodeToItemMap.get(parent);
            for (int i = 0; i < e.getChildren().length; ++i) {
                TreeNode node = (TreeNode)e.getChildren()[i];
                int index = e.getChildIndices()[i];
                TreeItem item = this.newTreeItem(node, parentItem.getLevel() + 1);
                this.itemContainer.add(item);
                parentItem.getChildren().add(index, item);
                this.markTheLastButOneChildDirty(parentItem, item);
                this.dirtyItems.add(item);
                this.dirtyItemsCreateDOM.add(item);
            }
        }
    }

    public final void treeNodesRemoved(TreeModelEvent e) {
        TreeNode parent = (TreeNode)e.getTreePath().getLastPathComponent();
        TreeItem parentItem = (TreeItem)this.nodeToItemMap.get(parent);
        if (this.isNodeVisible(parent) && this.isNodeExpanded(parent)) {
            for (int i = 0; i < e.getChildren().length; ++i) {
                TreeNode node = (TreeNode)e.getChildren()[i];
                TreeItem item = (TreeItem)this.nodeToItemMap.get(node);
                if (item == null) continue;
                this.markTheLastButOneChildDirty(parentItem, item);
                parentItem.getChildren().remove(item);
                this.visitItemChildren(item, new IItemCallback(){

                    public void visitItem(TreeItem item) {
                        AbstractTree.this.removeItem(item);
                        AbstractTree.this.getTreeState().selectNode((TreeNode)item.getModelObject(), false);
                    }
                });
                this.removeItem(item);
            }
        }
    }

    public final void treeStructureChanged(TreeModelEvent e) {
        TreeNode node = (TreeNode)e.getTreePath().getLastPathComponent();
        if (e.getTreePath().getPathCount() == 1) {
            this.invalidateAll();
        } else {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void updateTree() {
        IRequestTarget target = this.getRequestCycle().getRequestTarget();
        if (target instanceof AjaxRequestTarget) {
            this.updateTree((AjaxRequestTarget)target);
        }
    }

    protected void addComponent(AjaxRequestTarget target, Component component) {
        target.addComponent(component);
    }

    public final void updateTree(AjaxRequestTarget target) {
        if (target == null) {
            return;
        }
        this.checkModel();
        if (this.dirtyAll) {
            this.addComponent(target, this);
        } else {
            TreeItem item;
            Iterator i;
            if (this.deleteIds.length() != 0) {
                String js = this.getElementsDeleteJavascript();
                target.prependJavascript(js);
            }
            while (!this.dirtyItemsCreateDOM.isEmpty()) {
                i = this.dirtyItemsCreateDOM.iterator();
                while (i.hasNext()) {
                    TreeItem previous;
                    item = (TreeItem)i.next();
                    TreeItem parent = item.getParentItem();
                    int index = parent.getChildren().indexOf(item);
                    if (index == 0) {
                        previous = parent;
                    } else {
                        previous = (TreeItem)parent.getChildren().get(index - 1);
                        while (previous.getChildren() != null && previous.getChildren().size() > 0) {
                            previous = (TreeItem)previous.getChildren().get(previous.getChildren().size() - 1);
                        }
                    }
                    if (this.dirtyItemsCreateDOM.contains(previous)) continue;
                    target.prependJavascript("Wicket.Tree.createElement(\"" + item.getMarkupId() + "\"," + "\"" + previous.getMarkupId() + "\")");
                    i.remove();
                }
            }
            i = this.dirtyItems.iterator();
            while (i.hasNext()) {
                item = (TreeItem)i.next();
                if (item.getChildren() == null) {
                    this.buildItemChildren(item);
                    item.setRenderChildren(true);
                }
                this.addComponent(target, item);
            }
            this.updated();
        }
    }

    protected final boolean isNodeExpanded(TreeNode node) {
        if (this.isRootLess() && this.rootItem != null && this.rootItem.getModelObject().equals(node)) {
            return true;
        }
        return this.getTreeState().isNodeExpanded(node);
    }

    protected ITreeState newTreeState() {
        return new DefaultTreeState();
    }

    protected void onAfterRender() {
        super.onAfterRender();
        this.updated();
    }

    protected abstract void populateTreeItem(WebMarkupContainer var1, int var2);

    private final void buildItemChildren(TreeItem item) {
        List items = this.isNodeExpanded((TreeNode)item.getModelObject()) ? this.buildTreeItems(this.nodeChildren((TreeNode)item.getModelObject()), item.getLevel() + 1) : new ArrayList(0);
        item.setChildren(items);
    }

    private final List buildTreeItems(Iterator nodes, int level) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            TreeItem item = this.newTreeItem(node, level);
            this.itemContainer.add(item);
            this.buildItemChildren(item);
            result.add(item);
        }
        return result;
    }

    private final void checkModel() {
        TreeModel model = (TreeModel)this.getModelObject();
        if (model != this.previousModel) {
            if (this.previousModel != null) {
                this.previousModel.removeTreeModelListener(this);
            }
            this.previousModel = model;
            if (model != null) {
                model.addTreeModelListener(this);
            }
            this.invalidateAll();
        }
    }

    private final void clearAllItem() {
        this.visitItemAndChildren(this.rootItem, new IItemCallback(){

            public void visitItem(TreeItem item) {
                item.remove();
            }
        });
        this.rootItem = null;
    }

    private String getElementsDeleteJavascript() {
        AppendingStringBuffer buffer = new AppendingStringBuffer(100);
        buffer.append("Wicket.Tree.removeNodes(\"");
        buffer.append(this.getMarkupId() + "_\",[");
        buffer.append(this.deleteIds);
        if (buffer.endsWith(",")) {
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append("]);");
        return buffer.toString();
    }

    private String getShortItemId(TreeItem item) {
        int skip = this.getMarkupId().length() + 1;
        return item.getMarkupId().substring(skip);
    }

    private final void init() {
        this.setVersioned(false);
        this.setOutputMarkupId(true);
        this.itemContainer = new TreeItemContainer("i");
        this.add(this.itemContainer);
        this.add(HeaderContributor.forJavaScript(JAVASCRIPT));
        this.checkModel();
    }

    public final void markNodeDirty(TreeNode node) {
        this.invalidateNode(node, false);
    }

    private final void invalidateNode(TreeNode node, boolean forceRebuild) {
        TreeItem item;
        if (!this.dirtyAll && (item = (TreeItem)this.nodeToItemMap.get(node)) != null) {
            boolean createDOM = false;
            if (forceRebuild) {
                int level = item.getLevel();
                List children = item.getChildren();
                String id = item.getId();
                TreeItem parent = item.getParentItem();
                int index = parent != null ? parent.getChildren().indexOf(item) : -1;
                createDOM = this.dirtyItemsCreateDOM.contains(item);
                this.dirtyItems.remove(item);
                this.dirtyItemsCreateDOM.remove(item);
                item.remove();
                item = this.newTreeItem(node, level, id);
                this.itemContainer.add(item);
                item.setChildren(children);
                if (parent == null) {
                    this.rootItem = item;
                } else {
                    parent.getChildren().set(index, item);
                }
            }
            this.dirtyItems.add(item);
            if (createDOM) {
                this.dirtyItemsCreateDOM.add(item);
            }
        }
    }

    private final void invalidateNodeWithChildren(TreeNode node) {
        TreeItem item;
        if (!this.dirtyAll && (item = (TreeItem)this.nodeToItemMap.get(node)) != null) {
            this.visitItemChildren(item, new IItemCallback(){

                public void visitItem(TreeItem item) {
                    AbstractTree.this.removeItem(item);
                }
            });
            item.setChildren(null);
            this.dirtyItems.add(item);
        }
    }

    private final boolean isNodeVisible(TreeNode node) {
        while (node.getParent() != null) {
            if (!this.isNodeExpanded(node.getParent())) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    private final TreeItem newTreeItem(TreeNode node, int level) {
        return new TreeItem("" + this.idCounter++, node, level);
    }

    private final TreeItem newTreeItem(TreeNode node, int level, String id) {
        return new TreeItem(id, node, level);
    }

    private final Iterator nodeChildren(TreeNode node) {
        return AbstractTree.toIterator(node.children());
    }

    private final void rebuildDirty() {
        Iterator i = this.dirtyItems.iterator();
        while (i.hasNext()) {
            TreeItem item = (TreeItem)i.next();
            if (item.getChildren() != null) continue;
            this.buildItemChildren(item);
        }
    }

    private void removeItem(TreeItem item) {
        this.dirtyItems.remove(item);
        if (this.dirtyItemsCreateDOM.contains(item)) {
            this.dirtyItemsCreateDOM.remove(item);
        } else {
            this.deleteIds.append(this.getShortItemId(item));
            this.deleteIds.append(",");
        }
        item.remove();
    }

    private final void updated() {
        this.dirtyAll = false;
        this.dirtyItems.clear();
        this.dirtyItemsCreateDOM.clear();
        this.deleteIds.clear();
    }

    private final void visitItemAndChildren(TreeItem item, IItemCallback callback) {
        callback.visitItem(item);
        this.visitItemChildren(item, callback);
    }

    private final void visitItemChildren(TreeItem item, IItemCallback callback) {
        if (item.getChildren() != null) {
            Iterator i = item.getChildren().iterator();
            while (i.hasNext()) {
                TreeItem child = (TreeItem)i.next();
                this.visitItemAndChildren(child, callback);
            }
        }
    }

    public Component getNodeComponent(TreeNode node) {
        return (Component)this.nodeToItemMap.get(node);
    }

    private class TreeItemContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public TreeItemContainer(String id) {
            super(id);
        }

        public void remove(Component component) {
            if (component instanceof TreeItem) {
                AbstractTree.this.nodeToItemMap.remove(((TreeItem)component).getModelObject());
            }
            super.remove(component);
        }

        protected void onRender(MarkupStream markupStream) {
            int markupStart = markupStream.getCurrentIndex();
            final class Rendered {
                boolean rendered;
                private final /* synthetic */ TreeItemContainer this$1;

                Rendered(TreeItemContainer this$1) {
                    this.this$1 = this$1;
                    this.rendered = false;
                }
            }
            Rendered rendered = new Rendered(this);
            if (AbstractTree.this.rootItem != null) {
                IItemCallback callback = new IItemCallback(this, markupStream, markupStart, rendered){
                    private final /* synthetic */ MarkupStream val$markupStream;
                    private final /* synthetic */ int val$markupStart;
                    private final /* synthetic */ Rendered val$rendered;
                    private final /* synthetic */ TreeItemContainer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$markupStream = val$markupStream;
                        this.val$markupStart = val$markupStart;
                        this.val$rendered = val$rendered;
                    }

                    public void visitItem(TreeItem item) {
                        this.val$markupStream.setCurrentIndex(this.val$markupStart);
                        item.render(this.val$markupStream);
                        this.val$rendered.rendered = true;
                    }
                };
                AbstractTree.this.visitItemAndChildren(AbstractTree.this.rootItem, callback);
            }
            if (!rendered.rendered) {
                markupStream.skipComponent();
            }
        }
    }

    private final class TreeItem
    extends WebMarkupContainer {
        private static final int FLAG_RENDER_CHILDREN = 524288;
        private static final long serialVersionUID = 1L;
        private List children;
        private final int level;

        public TreeItem(String id, TreeNode node, int level) {
            super(id, new Model((Serializable)((Object)node)));
            this.children = null;
            AbstractTree.this.nodeToItemMap.put(node, this);
            this.level = level;
            this.setOutputMarkupId(true);
            if (level != -1) {
                AbstractTree.this.populateTreeItem(this, level);
            }
        }

        public List getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public String getMarkupId() {
            return AbstractTree.this.getMarkupId() + "_" + this.getId();
        }

        public TreeItem getParentItem() {
            return (TreeItem)AbstractTree.this.nodeToItemMap.get(((TreeNode)this.getModelObject()).getParent());
        }

        public void setChildren(List children) {
            this.children = children;
        }

        protected final boolean isRenderChildren() {
            return this.getFlag(524288);
        }

        protected void onRender(MarkupStream markupStream) {
            if (this == AbstractTree.this.rootItem && AbstractTree.this.isRootLess()) {
                this.getResponse().write("<div style=\"display:none\" id=\"" + this.getMarkupId() + "\"></div>");
                markupStream.skipComponent();
            } else {
                int index = markupStream.getCurrentIndex();
                super.onRender(markupStream);
                if (this.isRenderChildren()) {
                    AbstractTree.this.visitItemChildren(this, new IItemCallback(this, markupStream, index){
                        private final /* synthetic */ MarkupStream val$markupStream;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ TreeItem this$1;
                        {
                            this.this$1 = this$1;
                            this.val$markupStream = val$markupStream;
                            this.val$index = val$index;
                        }

                        public void visitItem(TreeItem item) {
                            this.val$markupStream.setCurrentIndex(this.val$index);
                            item.onRender(this.val$markupStream);
                            List behaviors = item.getBehaviors();
                            Iterator<E> i = behaviors.iterator();
                            while (i.hasNext()) {
                                IBehavior behavior = (IBehavior)i.next();
                                behavior.afterRender(item);
                            }
                        }
                    });
                }
            }
        }

        public void renderHead(HtmlHeaderContainer container) {
            super.renderHead(container);
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(this, container){
                    private final /* synthetic */ HtmlHeaderContainer val$container;
                    private final /* synthetic */ TreeItem this$1;
                    {
                        this.this$1 = this$1;
                        this.val$container = val$container;
                    }

                    public void visitItem(TreeItem item) {
                        item.visitChildren(new Component.IVisitor(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object component(Component component) {
                                if (component.isVisible()) {
                                    component.renderHead(2.access$300(this.this$2));
                                    return CONTINUE_TRAVERSAL;
                                }
                                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                            }
                        });
                    }

                    static /* synthetic */ HtmlHeaderContainer access$300(2 x0) {
                        return x0.val$container;
                    }
                });
            }
        }

        protected final void setRenderChildren(boolean value) {
            this.setFlag(524288, value);
        }

        protected void onDetach() {
            super.onDetach();
            Object object = this.getModelObject();
            if (object instanceof IDetachable) {
                ((IDetachable)object).detach();
            }
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(this){
                    private final /* synthetic */ TreeItem this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void visitItem(TreeItem item) {
                        item.detach();
                    }
                });
            }
            this.setRenderChildren(false);
        }

        protected void onBeforeRender() {
            AbstractTree.this.onBeforeRenderInternal();
            super.onBeforeRender();
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(this){
                    private final /* synthetic */ TreeItem this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void visitItem(TreeItem item) {
                        item.prepareForRender();
                    }
                });
            }
        }

        protected void onAfterRender() {
            super.onAfterRender();
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(this){
                    private final /* synthetic */ TreeItem this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void visitItem(TreeItem item) {
                        item.afterRender();
                    }
                });
            }
        }
    }

    private static interface IItemCallback {
        public void visitItem(TreeItem var1);
    }
}

