/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;

public class HtmlHeaderResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag.getId().equals("_header_")) {
            HtmlHeaderContainer header = new HtmlHeaderContainer("_header_" + container.getPage().getAutoIndex());
            container.autoAdd(header, markupStream);
            return true;
        }
        if (tag instanceof WicketTag && ((WicketTag)tag).isHeadTag()) {
            if (container instanceof WebPage) {
                HtmlHeaderContainer header = new HtmlHeaderContainer("_header_" + container.getPage().getAutoIndex());
                WebMarkupContainer header2 = new WebMarkupContainer("_header_"){
                    private static final long serialVersionUID = 1L;

                    public boolean isTransparentResolver() {
                        return true;
                    }
                };
                header2.setRenderBodyOnly(true);
                header.add(header2);
                container.autoAdd(header, markupStream);
            } else if (container instanceof HtmlHeaderContainer) {
                WebMarkupContainer header = new WebMarkupContainer("_header_"){
                    private static final long serialVersionUID = 1L;

                    public boolean isTransparentResolver() {
                        return true;
                    }
                };
                header.setRenderBodyOnly(true);
                try {
                    container.autoAdd(header, markupStream);
                }
                catch (IllegalArgumentException ex) {
                    throw new WicketRuntimeException("If the root exception says something like \"A child with id '_header' already exists\" then you most likely forgot to override autoAdd() in your bordered page component.", ex);
                }
            } else {
                throw new MarkupException("Mis-placed <wicket:head>. <wicket:head> must be outside of <wicket:panel> and <wicket:border>");
            }
            return true;
        }
        return false;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("head");
    }
}

