/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadableDetachableModel
extends AbstractReadOnlyModel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)LoadableDetachableModel.class);
    private transient boolean attached = false;
    private transient Object transientModelObject;

    public LoadableDetachableModel() {
    }

    public LoadableDetachableModel(Object object) {
        this.transientModelObject = object;
        this.attached = true;
    }

    public void detach() {
        if (this.attached) {
            this.attached = false;
            this.transientModelObject = null;
            if (log.isDebugEnabled()) {
                log.debug("removed transient object for " + this + ", requestCycle " + RequestCycle.get());
            }
            this.onDetach();
        }
    }

    public Object getObject() {
        if (!this.attached) {
            this.attached = true;
            this.transientModelObject = this.load();
            if (log.isDebugEnabled()) {
                log.debug("loaded transient object " + this.transientModelObject + " for " + this + ", requestCycle " + RequestCycle.get());
            }
            this.onAttach();
        }
        return this.transientModelObject;
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(":attached=").append(this.attached).append(":tempModelObject=[").append(this.transientModelObject).append("]");
        return sb.toString();
    }

    protected abstract Object load();

    protected void onAttach() {
    }

    protected void onDetach() {
    }
}

