/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.MockHttpSession;
import org.apache.wicket.protocol.http.MockServletContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.request.WebErrorCodeResponseTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.file.WebApplicationPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockWebApplication {
    private static final Logger log = LoggerFactory.getLogger((Class)MockWebApplication.class);
    private Page lastRenderedPage;
    private Page previousRenderedPage;
    private final MockHttpServletRequest servletRequest;
    private final MockHttpServletResponse servletResponse;
    private final MockHttpSession servletSession;
    private WebRequest wicketRequest;
    private Map parametersForNextRequest = new HashMap();
    private WebResponse wicketResponse;
    private WebSession wicketSession;
    private final WebApplication application;
    private final ServletContext context;
    private final WicketFilter filter;

    public MockWebApplication(final WebApplication application, String path) {
        this.application = application;
        this.context = this.newServletContext(path);
        this.filter = new WicketFilter(){

            protected IWebApplicationFactory getApplicationFactory() {
                return new IWebApplicationFactory(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public WebApplication createApplication(WicketFilter filter) {
                        return 1.access$000(this.this$1);
                    }
                };
            }

            static /* synthetic */ WebApplication access$000(1 x0) {
                return x0.application;
            }
        };
        try {
            this.filter.init(new FilterConfig(){

                public ServletContext getServletContext() {
                    return MockWebApplication.this.context;
                }

                public Enumeration getInitParameterNames() {
                    return null;
                }

                public String getInitParameter(String name) {
                    if (name.equals("filterMappingUrlPattern")) {
                        return "<servlet>";
                    }
                    return null;
                }

                public String getFilterName() {
                    return "WicketMockServlet";
                }
            });
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        Application.set(this.application);
        this.servletSession = new MockHttpSession(this.context);
        this.servletRequest = new MockHttpServletRequest(this.application, this.servletSession, this.context);
        this.servletResponse = new MockHttpServletResponse(this.servletRequest);
        this.wicketRequest = this.application.newWebRequest(this.servletRequest);
        this.wicketResponse = this.application.newWebResponse(this.servletResponse);
        this.createRequestCycle();
        this.application.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.ONE_PASS_RENDER);
        this.application.getRequestCycleSettings().setBufferResponse(false);
        this.application.getResourceSettings().setResourceFinder(new WebApplicationPath(this.context));
        this.application.getPageSettings().setAutomaticMultiWindowSupport(false);
        this.application.getResourceSettings().setResourcePollFrequency(null);
    }

    public ServletContext newServletContext(String path) {
        return new MockServletContext(this.application, path);
    }

    public final WebApplication getApplication() {
        return this.application;
    }

    public Page getLastRenderedPage() {
        return this.lastRenderedPage;
    }

    public Page getPreviousRenderedPage() {
        return this.previousRenderedPage;
    }

    public MockHttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public MockHttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public MockHttpSession getServletSession() {
        return this.servletSession;
    }

    public WebRequest getWicketRequest() {
        return this.wicketRequest;
    }

    public WebResponse getWicketResponse() {
        return this.wicketResponse;
    }

    public WebSession getWicketSession() {
        return this.wicketSession;
    }

    public void processRequestCycle(Component component) {
        this.setupRequestAndResponse();
        WebRequestCycle cycle = this.createRequestCycle();
        cycle.request(component);
        if (component instanceof Page) {
            this.lastRenderedPage = (Page)component;
        }
        this.postProcessRequestCycle(cycle);
    }

    public void processRequestCycle(Class pageClass) {
        this.processRequestCycle(pageClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestCycle(Class pageClass, PageParameters params) {
        this.setupRequestAndResponse();
        WebRequestCycle cycle = this.createRequestCycle();
        try {
            cycle.request(new BookmarkablePageRequestTarget(pageClass, params));
        }
        finally {
            cycle.getResponse().close();
        }
        this.postProcessRequestCycle(cycle);
    }

    public void processRequestCycle() {
        this.processRequestCycle(this.createRequestCycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestCycle(WebRequestCycle cycle) {
        try {
            cycle.request();
            if (!cycle.wasHandled()) {
                cycle.setRequestTarget(new WebErrorCodeResponseTarget(404));
            }
            this.createRequestCycle();
        }
        finally {
            cycle.getResponse().close();
        }
        this.postProcessRequestCycle(cycle);
    }

    private void postProcessRequestCycle(WebRequestCycle cycle) {
        MockHttpServletResponse httpResponse;
        this.previousRenderedPage = this.lastRenderedPage;
        if (cycle.getResponse() instanceof WebResponse && (httpResponse = (MockHttpServletResponse)cycle.getWebResponse().getHttpServletResponse()).isRedirect()) {
            this.lastRenderedPage = this.generateLastRenderedPage(cycle);
            MockHttpServletRequest newHttpRequest = new MockHttpServletRequest(this.application, this.servletSession, this.application.getServletContext());
            newHttpRequest.setRequestToRedirectString(httpResponse.getRedirectLocation());
            this.wicketRequest = this.application.newWebRequest(newHttpRequest);
            cycle = this.createRequestCycle();
            cycle.request();
        }
        this.lastRenderedPage = this.generateLastRenderedPage(cycle);
        Session.set(this.getWicketSession());
        if (this.getLastRenderedPage() instanceof ExceptionErrorPage) {
            throw (RuntimeException)((ExceptionErrorPage)this.getLastRenderedPage()).getThrowable();
        }
    }

    private Page generateLastRenderedPage(WebRequestCycle cycle) {
        Class responseClass;
        Page newLastRenderedPage = cycle.getResponsePage();
        if (newLastRenderedPage == null && (responseClass = cycle.getResponsePageClass()) != null) {
            Session.set(cycle.getSession());
            IRequestTarget target = cycle.getRequestTarget();
            if (target instanceof IPageRequestTarget) {
                newLastRenderedPage = ((IPageRequestTarget)target).getPage();
            } else if (target instanceof IBookmarkablePageRequestTarget) {
                this.createRequestCycle();
                IBookmarkablePageRequestTarget pageClassRequestTarget = (IBookmarkablePageRequestTarget)target;
                Class pageClass = pageClassRequestTarget.getPageClass();
                PageParameters parameters = pageClassRequestTarget.getPageParameters();
                newLastRenderedPage = parameters == null || parameters.size() == 0 ? this.application.getSessionSettings().getPageFactory().newPage(pageClass) : this.application.getSessionSettings().getPageFactory().newPage(pageClass, parameters);
            }
        }
        if (newLastRenderedPage == null) {
            newLastRenderedPage = this.lastRenderedPage;
        }
        return newLastRenderedPage;
    }

    public WebRequestCycle createRequestCycle() {
        WebRequestCycle cycle = (WebRequestCycle)this.application.newRequestCycle(this.wicketRequest, this.wicketResponse);
        this.wicketSession = (WebSession)Session.findOrCreate();
        cycle.setAutomaticallyClearFeedbackMessages(false);
        return cycle;
    }

    public WebRequestCycle setupRequestAndResponse(boolean isAjax) {
        this.servletRequest.initialize();
        this.servletResponse.initialize();
        this.servletRequest.setParameters(this.parametersForNextRequest);
        if (isAjax) {
            this.servletRequest.addHeader("Wicket-Ajax", "Yes");
        }
        this.parametersForNextRequest.clear();
        this.wicketRequest = this.application.newWebRequest(this.servletRequest);
        this.wicketResponse = this.application.newWebResponse(this.servletResponse);
        WebRequestCycle requestCycle = this.createRequestCycle();
        this.application.getSessionStore().bind(this.wicketRequest, this.wicketSession);
        this.wicketResponse.setAjax(this.wicketRequest.isAjax());
        return requestCycle;
    }

    public WebRequestCycle setupRequestAndResponse() {
        return this.setupRequestAndResponse(false);
    }

    public Map getParametersForNextRequest() {
        return this.parametersForNextRequest;
    }

    public void setParametersForNextRequest(Map parametersForNextRequest) {
        this.parametersForNextRequest = parametersForNextRequest;
    }

    public void destroy() {
        this.filter.destroy();
        File dir = (File)this.context.getAttribute("javax.servlet.context.tempdir");
        this.deleteDir(dir);
    }

    private void deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File element = files[i];
                    if (element.isDirectory()) {
                        this.deleteDir(element);
                        continue;
                    }
                    element.delete();
                }
            }
            dir.delete();
        }
    }
}

