/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
implements IRequestLogger {
    protected static Logger log = LoggerFactory.getLogger((Class)RequestLogger.class);
    private int totalCreatedSessions;
    private int peakSessions;
    private final List requests;
    private final Map liveSessions;
    private final ThreadLocal currentRequest = new ThreadLocal();
    private int active;

    public RequestLogger() {
        this.requests = Collections.synchronizedList(new LinkedList(){
            private static final long serialVersionUID = 1L;

            public void add(int index, Object o) {
                super.add(index, o);
                if (this.size() > Application.get().getRequestLoggerSettings().getRequestsWindowSize()) {
                    this.removeLast();
                }
            }
        });
        this.liveSessions = new ConcurrentHashMap();
    }

    public int getTotalCreatedSessions() {
        return this.totalCreatedSessions;
    }

    public int getPeakSessions() {
        return this.peakSessions;
    }

    public int getCurrentActiveRequestCount() {
        return this.active;
    }

    public List getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    public SessionData[] getLiveSessions() {
        Object[] sessions = this.liveSessions.values().toArray(new SessionData[this.liveSessions.size()]);
        Arrays.sort(sessions);
        return sessions;
    }

    public void sessionDestroyed(String sessionId) {
        this.liveSessions.remove(sessionId);
    }

    public void sessionCreated(String sessionId) {
        this.liveSessions.put(sessionId, new SessionData(sessionId));
        if (this.liveSessions.size() > this.peakSessions) {
            this.peakSessions = this.liveSessions.size();
        }
        ++this.totalCreatedSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestData getCurrentRequest() {
        RequestData rd = (RequestData)this.currentRequest.get();
        if (rd == null) {
            rd = new RequestData();
            this.currentRequest.set(rd);
            RequestLogger requestLogger = this;
            synchronized (requestLogger) {
                ++this.active;
            }
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTime(long timeTaken) {
        RequestData rd = (RequestData)this.currentRequest.get();
        if (rd != null) {
            RequestLogger requestLogger = this;
            synchronized (requestLogger) {
                if (this.active > 0) {
                    rd.setActiveRequest(this.active--);
                }
            }
            Session session = Session.get();
            String sessionId = session.getId();
            rd.setSessionId(sessionId);
            Object sessionInfo = this.getSessionInfo(session);
            rd.setSessionInfo(sessionInfo);
            long sizeInBytes = -1L;
            if (Application.get().getRequestLoggerSettings().getRecordSessionSize()) {
                try {
                    sizeInBytes = session.getSizeInBytes();
                }
                catch (Exception e) {
                    log.error("Exception while determining the size of the session in the request logger: " + e.getMessage(), (Throwable)e);
                }
            }
            rd.setSessionSize(sizeInBytes);
            rd.setTimeTaken(timeTaken);
            this.requests.add(0, rd);
            this.currentRequest.set(null);
            if (sessionId != null) {
                SessionData sd = (SessionData)this.liveSessions.get(sessionId);
                if (sd == null) {
                    this.sessionCreated(sessionId);
                    sd = (SessionData)this.liveSessions.get(sessionId);
                }
                if (sd != null) {
                    sd.setSessionInfo(sessionInfo);
                    sd.setSessionSize(sizeInBytes);
                    sd.addTimeTaken(timeTaken);
                    this.log(rd, sd);
                } else {
                    this.log(rd, null);
                }
            } else {
                this.log(rd, null);
            }
        }
    }

    private void log(RequestData rd, SessionData sd) {
        if (log.isInfoEnabled()) {
            AppendingStringBuffer asb = new AppendingStringBuffer(150);
            asb.append("time=");
            asb.append(rd.getTimeTaken());
            asb.append(",event=");
            asb.append(rd.getEventTarget());
            asb.append(",response=");
            asb.append(rd.getResponseTarget());
            if (rd.getSessionInfo() != null && !rd.getSessionInfo().equals("")) {
                asb.append(",sessioninfo=");
                asb.append(rd.getSessionInfo());
            } else {
                asb.append(",sessionid=");
                asb.append(rd.getSessionId());
            }
            asb.append(",sessionsize=");
            asb.append(rd.getSessionSize());
            if (sd != null) {
                asb.append(",sessionstart=");
                asb.append(sd.getStartDate());
                asb.append(",requests=");
                asb.append(sd.getNumberOfRequests());
                asb.append(",totaltime=");
                asb.append(sd.getTotalTimeTaken());
            }
            asb.append(",activerequests=");
            asb.append(rd.getActiveRequest());
            Runtime runtime = Runtime.getRuntime();
            long max = runtime.maxMemory() / 1000000L;
            long total = runtime.totalMemory() / 1000000L;
            long used = total - runtime.freeMemory() / 1000000L;
            asb.append(",maxmem=");
            asb.append(max);
            asb.append("M,total=");
            asb.append(total);
            asb.append("M,used=");
            asb.append(used);
            asb.append("M");
            log.info(asb.toString());
        }
    }

    private Object getSessionInfo(Session session) {
        if (session instanceof ISessionLogInfo) {
            return ((ISessionLogInfo)((Object)session)).getSessionInfo();
        }
        return "";
    }

    public void objectRemoved(Object value) {
        RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page removed, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap removed, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else if (value instanceof WebSession) {
            rd.addEntry("Session removed");
        } else {
            rd.addEntry("Custom object removed: " + value);
        }
    }

    public void objectUpdated(Object value) {
        RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page updated, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap updated, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else if (value instanceof Session) {
            rd.addEntry("Session updated");
        } else {
            rd.addEntry("Custom object updated: " + value);
        }
    }

    public void objectCreated(Object value) {
        RequestData rd = this.getCurrentRequest();
        if (value instanceof Session) {
            rd.addEntry("Session created");
        } else if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page created, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof IPageMap) {
            IPageMap map = (IPageMap)value;
            rd.addEntry("PageMap created, name: " + (map.getName() == null ? "DEFAULT" : map.getName()));
        } else {
            rd.addEntry("Custom object created: " + value);
        }
    }

    public void logResponseTarget(IRequestTarget target) {
        this.getCurrentRequest().addResponseTarget(this.getRequestTargetString(target));
    }

    public void logEventTarget(IRequestTarget target) {
        this.getCurrentRequest().addEventTarget(this.getRequestTargetString(target));
    }

    private String getRequestTargetString(IRequestTarget target) {
        AppendingStringBuffer sb = new AppendingStringBuffer(128);
        if (target instanceof IListenerInterfaceRequestTarget) {
            IListenerInterfaceRequestTarget listener = (IListenerInterfaceRequestTarget)target;
            sb.append("Interface[target:");
            sb.append(Classes.simpleName(listener.getTarget().getClass()));
            sb.append("(");
            sb.append(listener.getTarget().getPageRelativePath());
            sb.append("), page: ");
            sb.append(listener.getPage().getClass().getName());
            sb.append("(");
            sb.append(listener.getPage().getId());
            sb.append("), interface: ");
            sb.append(listener.getRequestListenerInterface().getName());
            sb.append(".");
            sb.append(listener.getRequestListenerInterface().getMethod().getName());
            sb.append("]");
        } else if (target instanceof IPageRequestTarget) {
            IPageRequestTarget pageRequestTarget = (IPageRequestTarget)target;
            sb.append("PageRequest[");
            sb.append(pageRequestTarget.getPage().getClass().getName());
            sb.append("(");
            sb.append(pageRequestTarget.getPage().getId());
            sb.append(")]");
        } else if (target instanceof IBookmarkablePageRequestTarget) {
            IBookmarkablePageRequestTarget pageRequestTarget = (IBookmarkablePageRequestTarget)target;
            sb.append("BookmarkablePage[");
            sb.append(pageRequestTarget.getPageClass().getName());
            sb.append("]");
        } else if (target instanceof ISharedResourceRequestTarget) {
            ISharedResourceRequestTarget sharedResourceTarget = (ISharedResourceRequestTarget)target;
            sb.append("SharedResource[");
            sb.append(sharedResourceTarget.getResourceKey());
            sb.append("]");
        } else {
            sb.append(target.toString());
        }
        return sb.toString();
    }

    public static class RequestData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private long startDate;
        private long timeTaken;
        private final List entries = new ArrayList(5);
        private String eventTarget;
        private String responseTarget;
        private String sessionId;
        private long totalSessionSize;
        private Object sessionInfo;
        private int activeRequest;

        public Long getTimeTaken() {
            return new Long(this.timeTaken);
        }

        public void setActiveRequest(int activeRequest) {
            this.activeRequest = activeRequest;
        }

        public int getActiveRequest() {
            return this.activeRequest;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public void setSessionSize(long sizeInBytes) {
            this.totalSessionSize = sizeInBytes;
        }

        public void setSessionId(String id) {
            this.sessionId = id;
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public String getEventTarget() {
            return this.eventTarget;
        }

        public String getResponseTarget() {
            return this.responseTarget;
        }

        public void addResponseTarget(String target) {
            this.responseTarget = target;
        }

        public void addEventTarget(String target) {
            this.eventTarget = target;
        }

        public void setTimeTaken(long timeTaken) {
            this.timeTaken = timeTaken;
            this.startDate = System.currentTimeMillis() - timeTaken;
        }

        public void addEntry(String string) {
            this.entries.add(string);
        }

        public String getAlteredObjects() {
            AppendingStringBuffer sb = new AppendingStringBuffer();
            for (int i = 0; i < this.entries.size(); ++i) {
                String element = (String)this.entries.get(i);
                sb.append(element);
                if (this.entries.size() == i + 1) continue;
                sb.append("<br/>");
            }
            return sb.toString();
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Long getSessionSize() {
            return new Long(this.totalSessionSize);
        }

        public String toString() {
            return "Request[timetaken=" + this.getTimeTaken() + ",sessioninfo=" + this.sessionInfo + ",sessionid=" + this.sessionId + ",sessionsize=" + this.totalSessionSize + ",request=" + this.eventTarget + ",response=" + this.responseTarget + ",alteredobjects=" + this.getAlteredObjects() + ",activerequest=" + this.activeRequest + "]";
        }
    }

    public static class SessionData
    implements IClusterable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private final String sessionId;
        private final long startDate;
        private long lastActive;
        private long numberOfRequests;
        private long totalTimeTaken;
        private long sessionSize;
        private Object sessionInfo;

        public SessionData(String sessionId) {
            this.sessionId = sessionId;
            this.startDate = System.currentTimeMillis();
            this.numberOfRequests = 1L;
        }

        public Date getLastActive() {
            return new Date(this.lastActive);
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public long getNumberOfRequests() {
            return this.numberOfRequests;
        }

        public long getSessionSize() {
            return this.sessionSize;
        }

        public long getTotalTimeTaken() {
            return this.totalTimeTaken;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        void addTimeTaken(long time) {
            this.lastActive = System.currentTimeMillis();
            ++this.numberOfRequests;
            this.totalTimeTaken += time;
        }

        void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        void setSessionSize(long size) {
            this.sessionSize = size;
        }

        public int compareTo(Object sd) {
            return (int)(((SessionData)sd).lastActive - this.lastActive);
        }
    }

    public static interface ISessionLogInfo {
        public Object getSessionInfo();
    }
}

