/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.AbortException;
import org.apache.wicket.Application;
import org.apache.wicket.RequestContext;
import org.apache.wicket.Resource;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.protocol.http.ContextParamWebApplicationFactory;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebApplicationFactoryCreationException;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.portlet.FilterRequestContext;
import org.apache.wicket.protocol.http.portlet.WicketFilterPortletContext;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketFilter
implements Filter {
    public static final String APP_FACT_PARAM = "applicationFactoryClassName";
    public static final String FILTER_MAPPING_PARAM = "filterMappingUrlPattern";
    private static final Logger log = LoggerFactory.getLogger((Class)WicketFilter.class);
    static final String SERVLET_PATH_HOLDER = "<servlet>";
    private FilterConfig filterConfig;
    private String filterPath;
    private WebApplication webApplication;
    private boolean servletMode = false;
    private static final String PORTLET_ONLY_FILTER = "portletOnlyFilter";
    private static final String DETECT_PORTLET_CONTEXT = "detectPortletContext";
    private static final String DETECT_PORTLET_CONTEXT_FULL_NAME = "org.apache.wicket.detectPortletContext";
    private static final String WICKET_PORTLET_PROPERTIES = "org/apache/wicket/protocol/http/portlet/WicketPortlet.properties";
    private WicketFilterPortletContext filterPortletContext;
    private boolean portletOnlyFilter;

    public void destroy() {
        if (this.webApplication != null) {
            this.webApplication.internalDestroy();
            this.webApplication = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        boolean inPortletContext = false;
        if (this.filterPortletContext != null) {
            FilterRequestContext filterRequestContext = new FilterRequestContext((HttpServletRequest)request, (HttpServletResponse)response);
            inPortletContext = this.filterPortletContext.setupFilter(this.getFilterConfig(), filterRequestContext, this.getFilterPath((HttpServletRequest)request));
            httpServletRequest = filterRequestContext.getRequest();
            httpServletResponse = filterRequestContext.getResponse();
        } else {
            httpServletRequest = (HttpServletRequest)request;
            httpServletResponse = (HttpServletResponse)response;
        }
        if (this.portletOnlyFilter && !inPortletContext) {
            chain.doFilter(request, response);
            return;
        }
        String relativePath = this.getRelativePath(httpServletRequest);
        if (this.isWicketRequest(relativePath)) {
            try {
                long ifModifiedSince;
                Application.set(this.webApplication);
                long lastModified = this.getLastModified(httpServletRequest);
                if (lastModified == -1L) {
                    if (this.doGet(httpServletRequest, httpServletResponse)) return;
                    chain.doFilter(request, response);
                    return;
                }
                try {
                    ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since");
                }
                catch (IllegalArgumentException e) {
                    log.warn("Invalid If-Modified-Since header", (Throwable)e);
                    ifModifiedSince = -1L;
                }
                if (ifModifiedSince < lastModified / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, lastModified);
                    this.doGet(httpServletRequest, httpServletResponse);
                    return;
                }
                httpServletResponse.setStatus(304);
                return;
            }
            finally {
                Application.unset();
                RequestContext.unset();
            }
        }
        chain.doFilter(request, response);
    }

    /*
     * Exception decompiling
     */
    public boolean doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public String getRelativePath(HttpServletRequest request) {
        String path = Strings.stripJSessionId(request.getRequestURI());
        String contextPath = request.getContextPath();
        path = path.substring(contextPath.length());
        if (this.servletMode) {
            String servletPath = request.getServletPath();
            path = path.substring(servletPath.length());
        }
        this.filterPath = this.getFilterPath(request);
        if (path.length() > 0) {
            path = path.substring(1);
        }
        if (!path.startsWith(this.filterPath) && this.filterPath.equals(path + "/")) {
            path = path + "/";
        }
        if (path.startsWith(this.filterPath)) {
            path = path.substring(this.filterPath.length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String filterMapping = filterConfig.getInitParameter(FILTER_MAPPING_PARAM);
        if (SERVLET_PATH_HOLDER.equals(filterMapping)) {
            this.servletMode = true;
        }
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = this.getClassLoader();
        try {
            InputStream is;
            if (previousClassLoader != newClassLoader) {
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            if (filterMapping == null && (is = filterConfig.getServletContext().getResourceAsStream("/WEB-INF/web.xml")) != null) {
                try {
                    this.filterPath = this.getFilterPath(filterConfig.getFilterName(), is);
                }
                catch (ServletException e) {
                    log.error("Error reading servlet/filter path from web.xml", (Throwable)e);
                }
                catch (SecurityException e) {
                    log.info("Couldn't read web.xml to automatically pick up servlet/filter path: " + e.getMessage());
                }
                if (this.filterPath == null) {
                    log.info("Unable to parse filter mapping web.xml for " + filterConfig.getFilterName() + ". " + "Configure with init-param " + FILTER_MAPPING_PARAM + " if it is not \"/*\".");
                }
            }
            IWebApplicationFactory factory = this.getApplicationFactory();
            this.webApplication = factory.createApplication(this);
            this.webApplication.setWicketFilter(this);
            String contextKey = "wicket:" + filterConfig.getFilterName();
            filterConfig.getServletContext().setAttribute(contextKey, (Object)this.webApplication);
            Application.set(this.webApplication);
            this.webApplication.internalInit();
            this.webApplication.init();
            this.webApplication.initializeComponents();
            this.webApplication.logStarted();
            this.portletOnlyFilter = Boolean.valueOf(filterConfig.getInitParameter(PORTLET_ONLY_FILTER));
            if (this.isPortletContextAvailable(filterConfig)) {
                this.filterPortletContext = this.newWicketFilterPortletContext();
            }
            if (this.filterPortletContext != null) {
                this.filterPortletContext.initFilter(filterConfig, this.webApplication);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Application.unset();
            if (newClassLoader != previousClassLoader) {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
            throw throwable;
        }
        Application.unset();
        if (newClassLoader != previousClassLoader) {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    protected boolean isPortletContextAvailable(FilterConfig config) throws ServletException {
        boolean detectPortletContext = false;
        String parameter = config.getInitParameter(DETECT_PORTLET_CONTEXT);
        if (parameter != null) {
            detectPortletContext = Boolean.valueOf(parameter);
        } else {
            parameter = config.getServletContext().getInitParameter(DETECT_PORTLET_CONTEXT_FULL_NAME);
            if (parameter != null) {
                detectPortletContext = Boolean.valueOf(parameter);
            } else {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(WICKET_PORTLET_PROPERTIES);
                if (is != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(is);
                        detectPortletContext = Boolean.valueOf(properties.getProperty(DETECT_PORTLET_CONTEXT_FULL_NAME, "false"));
                    }
                    catch (IOException e) {
                        throw new ServletException("Failed to load WicketPortlet.properties from classpath", (Throwable)e);
                    }
                }
            }
        }
        if (detectPortletContext) {
            try {
                Class<?> portletClass = Class.forName("javax.portlet.PortletContext");
                return true;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected WicketFilterPortletContext newWicketFilterPortletContext() {
        return new WicketFilterPortletContext();
    }

    protected void createRequestContext(WebRequest request, WebResponse response) {
        if (this.filterPortletContext == null || !this.filterPortletContext.createPortletRequestContext(request, response)) {
            new RequestContext();
        }
    }

    private String getFilterPath(String filterName, InputStream is) throws ServletException {
        String prefix = this.servletMode ? "servlet" : "filter";
        String mapping = prefix + "-mapping";
        String name = prefix + "-name";
        try {
            ArrayList<String> urlPatterns = new ArrayList<String>();
            XmlPullParser parser = new XmlPullParser();
            parser.parse(is);
            while (true) {
                XmlTag elem;
                if (!((elem = (XmlTag)parser.nextTag()) == null || elem.getName().equals(mapping) && elem.isOpen())) {
                    continue;
                }
                if (elem == null) break;
                String encounteredFilterName = null;
                String urlPattern = null;
                do {
                    if ((elem = (XmlTag)parser.nextTag()).isOpen()) {
                        parser.setPositionMarker();
                        continue;
                    }
                    if (elem.isClose() && elem.getName().equals(name)) {
                        encounteredFilterName = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString().trim();
                        continue;
                    }
                    if (!elem.isClose() || !elem.getName().equals("url-pattern")) continue;
                    urlPattern = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString().trim();
                } while (urlPattern == null || encounteredFilterName == null);
                if (!filterName.equals(encounteredFilterName)) continue;
                urlPatterns.add(urlPattern);
            }
            String prefixUppered = Character.toUpperCase(prefix.charAt(0)) + prefix.substring(1);
            if (urlPatterns.size() == 0) {
                throw new IllegalArgumentException("Error initializing Wicket" + prefixUppered + " - you have no <" + mapping + "> element with a url-pattern that uses " + prefix + ": " + filterName);
            }
            String urlPattern = (String)urlPatterns.get(0);
            if (!urlPattern.startsWith("/") || !urlPattern.endsWith("*")) {
                throw new IllegalArgumentException("<" + mapping + "> for Wicket" + prefixUppered + " \"" + filterName + "\" must start with '/' and end with '*'.");
            }
            return this.stripWildcard(urlPattern);
        }
        catch (IOException e) {
            throw new ServletException("Error finding <" + prefix + "> " + filterName + " in web.xml", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ServletException("Error finding <" + prefix + "> " + filterName + " in web.xml", (Throwable)e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new ServletException("Error finding <" + prefix + "> " + filterName + " in web.xml", (Throwable)e);
        }
    }

    private boolean isWicketRequest(String relativePath) {
        if (relativePath.equals("")) {
            return true;
        }
        if (relativePath.startsWith("resources/")) {
            return true;
        }
        return this.webApplication.getRequestCycleProcessor().getRequestCodingStrategy().urlCodingStrategyForPath(relativePath) != null;
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader("Last-Modified")) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader("Last-Modified", lastModified);
        }
    }

    protected IWebApplicationFactory getApplicationFactory() {
        String appFactoryClassName = this.filterConfig.getInitParameter(APP_FACT_PARAM);
        if (appFactoryClassName == null) {
            return new ContextParamWebApplicationFactory();
        }
        try {
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(appFactoryClassName);
            return (IWebApplicationFactory)factoryClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new WicketRuntimeException("Application factory class " + appFactoryClassName + " must implement IWebApplicationFactory");
        }
        catch (ClassNotFoundException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (InstantiationException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (SecurityException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected String getFilterPath(HttpServletRequest request) {
        if (this.filterPath != null) {
            return this.filterPath;
        }
        if (this.servletMode) {
            this.filterPath = request.getServletPath();
            return this.filterPath;
        }
        if (this.filterConfig.getInitParameter("filterPath") != null) {
            throw new WicketRuntimeException("\nThe filterPath init-param for WicketFilter has been removed.\nPlease use a param called filterMappingUrlPattern with a value that exactly\nmatches that in the <url-pattern> element of your <filter-mapping> (e.g. \"/app/*\").");
        }
        String result = this.filterConfig.getInitParameter(FILTER_MAPPING_PARAM);
        if (result == null || result.equals("/*")) {
            return "";
        }
        if (!result.startsWith("/") || !result.endsWith("/*")) {
            throw new WicketRuntimeException("Your filterMappingUrlPattern must start with \"/\" and end with \"/*\". It is: " + result);
        }
        this.filterPath = this.stripWildcard(result);
        return this.filterPath;
    }

    private String stripWildcard(String result) {
        return result.substring(1, result.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getLastModified(HttpServletRequest servletRequest) {
        boolean externalCall;
        Resource resource;
        block15: {
            long l;
            block17: {
                String pathInfo = this.getRelativePath(servletRequest);
                if (!pathInfo.startsWith("resources/")) return -1L;
                String resourceReferenceKey = pathInfo.substring("resources/".length());
                resource = null;
                externalCall = !Application.exists();
                try {
                    block16: {
                        try {
                            if (externalCall) {
                                Application.set(this.webApplication);
                            }
                            if ((resource = this.webApplication.getSharedResources().get(resourceReferenceKey)) == null || !resource.isCacheable()) break block15;
                            WebRequest request = this.webApplication.newWebRequest(servletRequest);
                            Session.findOrCreate(request, new WebResponse());
                            resource.setParameters(request.getParameterMap());
                            IResourceStream stream = resource.getResourceStream();
                            Time time = stream.lastModifiedTime();
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            l = time != null ? time.getMilliseconds() : -1L;
                            Object var12_13 = null;
                            if (resource == null) break block16;
                        }
                        catch (AbortException e) {
                            long l2 = -1L;
                            Object var12_15 = null;
                            if (resource != null) {
                                resource.setParameters(null);
                            }
                            if (externalCall) {
                                Application.unset();
                                RequestContext.unset();
                            }
                            if (!Session.exists()) return l2;
                            Session.unset();
                            return l2;
                        }
                        resource.setParameters(null);
                    }
                    if (!externalCall) break block17;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (resource != null) {
                        resource.setParameters(null);
                    }
                    if (externalCall) {
                        Application.unset();
                        RequestContext.unset();
                    }
                    if (!Session.exists()) throw throwable;
                    Session.unset();
                    throw throwable;
                }
                Application.unset();
                RequestContext.unset();
            }
            if (!Session.exists()) return l;
            Session.unset();
            return l;
        }
        Object var12_14 = null;
        if (resource != null) {
            resource.setParameters(null);
        }
        if (externalCall) {
            Application.unset();
            RequestContext.unset();
        }
        if (!Session.exists()) return -1L;
        Session.unset();
        return -1L;
    }
}

