/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.RenderResponse;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.portals.bridges.util.ServletPortletSessionProxy;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.portlet.FilterRequestContext;
import org.apache.wicket.protocol.http.portlet.PortletActionServletResponseWrapper;
import org.apache.wicket.protocol.http.portlet.PortletInvalidMarkupFilter;
import org.apache.wicket.protocol.http.portlet.PortletRenderServletResponseWrapper;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.protocol.http.portlet.PortletServletRequestWrapper;
import org.apache.wicket.protocol.http.portlet.WicketPortlet;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.settings.IRequestCycleSettings;

public class WicketFilterPortletContext {
    private static final String SERVLET_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX = "/ps:";

    public void initFilter(FilterConfig filterConfig, WebApplication webApplication) throws ServletException {
        webApplication.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.REDIRECT_TO_RENDER);
        webApplication.getRequestCycleSettings().addResponseFilter(new PortletInvalidMarkupFilter());
    }

    public boolean setupFilter(FilterConfig config, FilterRequestContext filterRequestContext, String filterPath) throws IOException, ServletException {
        boolean inPortletContext = false;
        PortletConfig portletConfig = (PortletConfig)filterRequestContext.getRequest().getAttribute("javax.portlet.config");
        if (portletConfig != null) {
            inPortletContext = true;
            WicketResponseState responseState = (WicketResponseState)filterRequestContext.getRequest().getAttribute(WicketPortlet.RESPONSE_STATE_ATTR);
            filterRequestContext.setRequest((HttpServletRequest)new PortletServletRequestWrapper(config.getServletContext(), filterRequestContext.getRequest(), ServletPortletSessionProxy.createProxy((HttpServletRequest)filterRequestContext.getRequest()), filterPath));
            if ("ACTION".equals(filterRequestContext.getRequest().getAttribute(WicketPortlet.REQUEST_TYPE_ATTR))) {
                filterRequestContext.setResponse((HttpServletResponse)new PortletActionServletResponseWrapper(filterRequestContext.getResponse(), responseState));
            } else {
                filterRequestContext.setResponse((HttpServletResponse)new PortletRenderServletResponseWrapper(filterRequestContext.getResponse(), (RenderResponse)filterRequestContext.getRequest().getAttribute("javax.portlet.response"), responseState));
            }
        } else {
            ServletContext context = config.getServletContext();
            HttpServletRequest request = filterRequestContext.getRequest();
            String pathInfo = request.getRequestURI().substring(request.getContextPath().length() + filterPath.length());
            String portletWindowId = this.decodePortletWindowId(pathInfo);
            if (portletWindowId != null) {
                HttpSession proxiedSession = ServletPortletSessionProxy.createProxy((HttpServletRequest)request, (String)portletWindowId);
                pathInfo = this.stripWindowIdFromPathInfo(pathInfo);
                filterRequestContext.setRequest((HttpServletRequest)new PortletServletRequestWrapper(context, request, proxiedSession, filterPath, pathInfo));
            }
        }
        return inPortletContext;
    }

    public boolean createPortletRequestContext(WebRequest request, WebResponse response) {
        if (request.getHttpServletRequest().getAttribute("javax.portlet.config") != null) {
            this.newPortletRequestContext((ServletWebRequest)request, response);
            return true;
        }
        return false;
    }

    public String getServletResourceUrlPortletWindowIdPrefix() {
        return SERVLET_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX;
    }

    public String decodePortletWindowId(String pathInfo) {
        String portletWindowId = null;
        if (pathInfo != null && pathInfo.startsWith(this.getServletResourceUrlPortletWindowIdPrefix())) {
            int nextPath = pathInfo.indexOf(47, 1);
            portletWindowId = nextPath > -1 ? pathInfo.substring(this.getServletResourceUrlPortletWindowIdPrefix().length(), nextPath) : pathInfo.substring(this.getServletResourceUrlPortletWindowIdPrefix().length());
        }
        return portletWindowId;
    }

    public String stripWindowIdFromPathInfo(String pathInfo) {
        if (pathInfo != null && pathInfo.startsWith(this.getServletResourceUrlPortletWindowIdPrefix())) {
            int nextPath = pathInfo.indexOf(47, 1);
            pathInfo = nextPath > -1 ? pathInfo.substring(nextPath) : null;
        }
        return pathInfo;
    }

    public String encodeWindowIdInPath(String windowId, CharSequence path) {
        return this.getServletResourceUrlPortletWindowIdPrefix().substring(1) + windowId + "/" + path;
    }

    protected void newPortletRequestContext(ServletWebRequest request, WebResponse response) {
        new PortletRequestContext(this, request, response);
    }
}

