/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import java.io.OutputStream;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.StringBufferResourceStream;

public class StringRequestTarget
implements IRequestTarget {
    private final String string;

    public StringRequestTarget(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument string must be not null");
        }
        this.string = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond(RequestCycle requestCycle) {
        Response response = requestCycle.getResponse();
        StringBufferResourceStream stream = new StringBufferResourceStream();
        stream.append(this.string);
        try {
            OutputStream out = response.getOutputStream();
            try {
                Streams.copy(stream.getInputStream(), out);
            }
            finally {
                stream.close();
                out.flush();
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Unable to render resource stream " + stream, e);
        }
    }

    public void detach(RequestCycle requestCycle) {
    }

    public String getString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringRequestTarget) {
            StringRequestTarget that = (StringRequestTarget)obj;
            return this.string.equals(that.string);
        }
        return false;
    }

    public int hashCode() {
        int result = "StringRequestTarget".hashCode();
        return 17 * (result += this.string.hashCode());
    }

    public String toString() {
        return "[StringRequestTarget@" + this.hashCode() + " " + this.string + "]";
    }
}

