/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.protocol.http.UnitTestSettings;
import org.apache.wicket.request.target.coding.BookmarkablePageRequestTargetUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.ValueMap;

public class MixedParamUrlCodingStrategy
extends BookmarkablePageRequestTargetUrlCodingStrategy {
    private final String[] parameterNames;

    public MixedParamUrlCodingStrategy(String mountPath, Class bookmarkablePageClass, String pageMapName, String[] parameterNames) {
        super(mountPath, bookmarkablePageClass, pageMapName);
        this.parameterNames = parameterNames;
    }

    public MixedParamUrlCodingStrategy(String mountPath, Class bookmarkablePageClass, String[] parameterNames) {
        super(mountPath, bookmarkablePageClass, PageMap.DEFAULT_NAME);
        this.parameterNames = parameterNames;
    }

    protected void appendParameters(AppendingStringBuffer url, Map parameters) {
        if (!url.endsWith("/")) {
            url.append("/");
        }
        HashSet parameterNamesToAdd = new HashSet(parameters.keySet());
        boolean foundParameter = false;
        int lastSpecifiedParameter = this.parameterNames.length;
        while (lastSpecifiedParameter != 0 && !foundParameter) {
            foundParameter = parameters.containsKey(this.parameterNames[--lastSpecifiedParameter]);
        }
        if (foundParameter) {
            for (int i = 0; i <= lastSpecifiedParameter; ++i) {
                String parameterName = this.parameterNames[i];
                String value = (String)parameters.get(parameterName);
                if (value == null) {
                    value = "";
                }
                url.append(this.urlEncode(value)).append("/");
                parameterNamesToAdd.remove(parameterName);
            }
        }
        if (!parameterNamesToAdd.isEmpty()) {
            boolean first = true;
            Iterator<Object> iterator = UnitTestSettings.getSortUrlParameters() ? new TreeSet(parameterNamesToAdd).iterator() : parameterNamesToAdd.iterator();
            while (iterator.hasNext()) {
                url.append(first ? (char)'?' : '&');
                String parameterName = (String)iterator.next();
                String value = (String)parameters.get(parameterName);
                url.append(this.urlEncode(parameterName)).append("=").append(this.urlEncode(value));
                first = false;
            }
        }
    }

    protected ValueMap decodeParameters(String urlFragment, Map urlParameters) {
        PageParameters params = new PageParameters();
        params.putAll(urlParameters);
        String urlPath = urlFragment;
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.length() > 0) {
            String[] pathParts = urlPath.split("/");
            if (pathParts.length > this.parameterNames.length) {
                throw new IllegalArgumentException("Too many path parts, please provide sufficient number of path parameter names");
            }
            for (int i = 0; i < pathParts.length; ++i) {
                params.put(this.parameterNames[i], this.urlDecode(pathParts[i]));
            }
        }
        return params;
    }
}

