/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.protocol.http.UnitTestSettings;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.BookmarkablePageRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.WebRequestEncoder;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.ValueMap;

public class QueryStringUrlCodingStrategy
extends BookmarkablePageRequestTargetUrlCodingStrategy {
    public QueryStringUrlCodingStrategy(String mountPath, Class bookmarkablePageClass) {
        super(mountPath, bookmarkablePageClass, PageMap.DEFAULT_NAME);
    }

    protected void appendParameters(AppendingStringBuffer url, Map parameters) {
        if (!url.endsWith("/")) {
            url.append("/");
        }
        if (parameters != null && parameters.size() > 0) {
            Iterator entries = UnitTestSettings.getSortUrlParameters() ? new TreeMap(parameters).entrySet().iterator() : parameters.entrySet().iterator();
            WebRequestEncoder encoder = new WebRequestEncoder(url);
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() == null) continue;
                encoder.addValue(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        String pageMapName = requestParameters.getPageMapName();
        PageParameters parameters = new PageParameters(requestParameters.getParameters());
        if (requestParameters.getInterfaceName() != null) {
            return new BookmarkableListenerInterfaceRequestTarget(pageMapName, (Class)this.bookmarkablePageClassRef.get(), parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        return new BookmarkablePageRequestTarget(pageMapName, (Class)this.bookmarkablePageClassRef.get(), parameters);
    }

    protected ValueMap decodeParameters(String fragment, Map passedParameters) {
        ValueMap parameters = new ValueMap();
        if (passedParameters != null) {
            parameters.putAll(passedParameters);
        }
        return parameters;
    }
}

