/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.wicket.Application;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class WebRequestEncoder {
    boolean firstParameter = true;
    AppendingStringBuffer url;
    Application application;

    public WebRequestEncoder(AppendingStringBuffer url) {
        this.url = url;
        this.application = Application.get();
    }

    public void addValue(String key, Object value) {
        if (value instanceof String[]) {
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                this.addValue(key, values[i]);
            }
        } else if (value instanceof String) {
            this.addValue(key, (String)value);
        } else {
            throw new IllegalArgumentException("PageParameters can only contain String or String[]");
        }
    }

    public void addValue(String key, String value) {
        String escapedValue = value;
        try {
            escapedValue = URLEncoder.encode(escapedValue, this.application.getRequestCycleSettings().getResponseRequestEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (!this.firstParameter) {
            this.url.append('&');
        } else {
            this.firstParameter = false;
            this.url.append('?');
        }
        this.url.append(key);
        this.url.append('=');
        this.url.append(escapedValue);
    }
}

