/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;

public final class ArrayListStack
extends ArrayList {
    private static final long serialVersionUID = 1L;

    public ArrayListStack(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayListStack() {
        this(10);
    }

    public ArrayListStack(Collection collection) {
        super(collection);
    }

    public final void push(Object item) {
        this.add(item);
    }

    public final Object pop() {
        Object top = this.peek();
        this.remove(this.size() - 1);
        return top;
    }

    public final Object peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.get(size - 1);
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final int search(Object o) {
        int i = this.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }
}

